/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jibx.runtime.IExtensibleWriter;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.XMLWriterNamespaceBase;

public class StAXWriter
extends XMLWriterNamespaceBase
implements IExtensibleWriter {
    private XMLStreamWriter m_writer;

    public StAXWriter(String[] uris) {
        super(uris);
    }

    public StAXWriter(String[] uris, XMLStreamWriter wrtr) {
        this(uris);
        this.m_writer = wrtr;
    }

    public StAXWriter(StAXWriter base, String[] uris) {
        super(base, uris);
        this.m_writer = base.m_writer;
    }

    public void init() {
    }

    public void setWriter(XMLStreamWriter wrtr) {
        this.m_writer = wrtr;
    }

    protected void defineNamespace(int index2, String prefix) throws IOException {
    }

    protected void undefineNamespace(int index2) {
    }

    public void setIndentSpaces(int count2, String newline, char indent) {
    }

    public void writeXMLDecl(String version, String encoding, String standalone) throws IOException {
        try {
            this.m_writer.writeStartDocument(encoding, version);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void startTagOpen(int index2, String name) throws IOException {
        try {
            if (index2 == 0) {
                this.m_writer.writeStartElement(name);
            } else {
                this.m_writer.writeStartElement(this.getNamespacePrefix(index2), name, this.getNamespaceUri(index2));
            }
            this.incrementNesting();
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void startTagNamespaces(int index2, String name, int[] nums, String[] prefs) throws IOException {
        try {
            int[] deltas = this.openNamespaces(nums, prefs);
            this.startTagOpen(index2, name);
            for (int i = 0; i < deltas.length; ++i) {
                int slot = deltas[i];
                String prefix = this.internalNamespacePrefix(slot);
                String uri = this.internalNamespaceUri(slot);
                if (prefix.length() > 0) {
                    this.m_writer.writeNamespace(prefix, uri);
                    continue;
                }
                this.m_writer.writeDefaultNamespace(uri);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void addAttribute(int index2, String name, String value2) throws IOException {
        try {
            if (index2 == 0) {
                this.m_writer.writeAttribute(name, value2);
            } else {
                this.m_writer.writeAttribute(this.getNamespacePrefix(index2), this.getNamespaceUri(index2), name, value2);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void closeStartTag() throws IOException {
    }

    public void closeEmptyTag() throws IOException {
        try {
            this.m_writer.writeEndElement();
            this.decrementNesting();
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void startTagClosed(int index2, String name) throws IOException {
        this.startTagOpen(index2, name);
    }

    public void endTag(int index2, String name) throws IOException {
        this.closeEmptyTag();
    }

    public void writeTextContent(String text2) throws IOException {
        try {
            this.m_writer.writeCharacters(text2);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void writeCData(String text2) throws IOException {
        try {
            this.m_writer.writeCData(text2);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void writeComment(String text2) throws IOException {
        try {
            this.m_writer.writeComment(text2);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void writeEntityRef(String name) throws IOException {
        try {
            this.m_writer.writeEntityRef(name);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void writeDocType(String name, String sys, String pub, String subset) throws IOException {
        try {
            StringBuffer buff = new StringBuffer();
            buff.append("<!DOCTYPE ");
            buff.append(name);
            buff.append(' ');
            if (sys != null) {
                if (pub == null) {
                    buff.append("SYSTEM \"");
                    buff.append(sys);
                } else {
                    buff.append("PUBLIC \"");
                    buff.append(pub);
                    buff.append("\" \"");
                    buff.append(sys);
                }
                buff.append('\"');
            }
            if (subset != null) {
                buff.append('[');
                buff.append(subset);
                buff.append(']');
            }
            buff.append('>');
            this.m_writer.writeDTD(buff.toString());
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void writePI(String target, String data2) throws IOException {
        try {
            this.m_writer.writeProcessingInstruction(target, data2);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void indent() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        try {
            this.m_writer.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("Error closing stream: " + e.getMessage());
        }
    }

    public IXMLWriter createChildWriter(String[] uris) {
        return new StAXWriter(this, uris);
    }
}

