/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.jibx.runtime.impl.IOutByteBuffer;

public class OutByteBuffer
implements IOutByteBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private OutputStream m_stream;
    private byte[] m_buffer;
    private int m_offset;

    public OutByteBuffer(int size2) {
        this.m_buffer = new byte[size2];
    }

    public OutByteBuffer() {
        this(4096);
    }

    public void reset() {
        this.m_offset = 0;
        this.m_stream = null;
    }

    public void setOutput(OutputStream os) {
        try {
            this.finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reset();
        this.m_stream = os;
    }

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public void setOffset(int offset) {
        this.m_offset = offset;
    }

    public void free(int reserve, int size2) throws IOException {
        if (this.m_buffer.length - this.m_offset < size2) {
            if (reserve < this.m_offset) {
                this.m_stream.write(this.m_buffer, 0, reserve);
                this.m_offset -= reserve;
                int need = reserve + size2;
                if (need > this.m_buffer.length) {
                    byte[] newbuf = new byte[Math.max(need, this.m_buffer.length + 2)];
                    System.arraycopy(this.m_buffer, reserve, newbuf, 0, this.m_offset);
                    this.m_buffer = newbuf;
                } else {
                    System.arraycopy(this.m_buffer, reserve, this.m_buffer, 0, this.m_offset);
                }
            } else {
                this.m_stream.write(this.m_buffer, 0, this.m_offset);
                if (size2 > this.m_buffer.length) {
                    this.m_buffer = new byte[Math.max(size2, this.m_buffer.length * 2)];
                }
                this.m_offset = 0;
            }
        }
    }

    public void flush() throws IOException {
        if (this.m_offset > 0) {
            this.m_stream.write(this.m_buffer, 0, this.m_offset);
            this.m_offset = 0;
        }
    }

    public void finish() throws IOException {
        if (this.m_stream != null) {
            this.flush();
            this.m_stream.close();
            this.m_stream = null;
        }
    }
}

