/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import org.jibx.runtime.impl.IInByteBuffer;

public class InByteBuffer
implements IInByteBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private InputStream m_stream;
    private boolean m_isEnd;
    private byte[] m_buffer;
    private int m_limit;
    private int m_offset;

    public InByteBuffer(int size2) {
        this.m_buffer = new byte[size2];
    }

    public InByteBuffer() {
        this(4096);
    }

    private boolean fillBuffer(int size2) throws IOException {
        int rem;
        if (this.m_isEnd) {
            return false;
        }
        byte[] oldbuf = this.m_buffer;
        if (this.m_buffer.length < size2) {
            byte[] newbuf = new byte[Math.max(size2, this.m_buffer.length * 2)];
            this.m_buffer = newbuf;
        }
        if ((rem = this.m_limit - this.m_offset) > 0 && (this.m_offset > 0 || this.m_buffer != oldbuf)) {
            System.arraycopy(oldbuf, this.m_offset, this.m_buffer, 0, rem);
        }
        this.m_offset = 0;
        this.m_limit = rem;
        while (this.m_limit < size2) {
            int max2 = this.m_buffer.length - this.m_limit;
            int actual = this.m_stream.read(this.m_buffer, this.m_limit, max2);
            if (actual >= 0) {
                this.m_limit += actual;
                continue;
            }
            this.m_isEnd = true;
            return false;
        }
        return true;
    }

    public void reset() {
        this.m_isEnd = false;
        this.m_limit = 0;
        this.m_offset = 0;
        this.m_stream = null;
    }

    public void setInput(InputStream is) {
        try {
            this.finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reset();
        this.m_stream = is;
    }

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public void setOffset(int offset) {
        this.m_offset = offset;
    }

    public int getLimit() {
        return this.m_limit;
    }

    public boolean require(int size2) throws IOException {
        if (this.m_limit - this.m_offset < size2) {
            return this.fillBuffer(size2);
        }
        return true;
    }

    public void finish() throws IOException {
        if (this.m_stream != null) {
            this.m_stream.close();
            this.m_stream = null;
        }
    }
}

