/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.lang.reflect.Array;

public class GrowableStringArray {
    public static final int DEFAULT_SIZE = 8;
    private int m_countLimit;
    private int m_countPresent;
    private int m_maximumGrowth;
    private String[] m_baseArray;

    public GrowableStringArray(int size2, int growth) {
        String[] array = new String[size2];
        this.m_countLimit = size2;
        this.m_maximumGrowth = growth;
        this.m_baseArray = array;
    }

    public GrowableStringArray(int size2) {
        this(size2, Integer.MAX_VALUE);
    }

    public GrowableStringArray() {
        this(8);
    }

    public GrowableStringArray(GrowableStringArray base) {
        this(base.m_countLimit, base.m_maximumGrowth);
        System.arraycopy(base.m_baseArray, 0, this.m_baseArray, 0, base.m_countPresent);
        this.m_countPresent = base.m_countPresent;
    }

    private void resizeCopy(Object base, Object grown) {
        System.arraycopy(base, 0, grown, 0, Array.getLength(base));
    }

    private void discardValues(int from2, int to2) {
        for (int i = from2; i < to2; ++i) {
            this.m_baseArray[i] = null;
        }
    }

    private void growArray(int required) {
        int size2 = Math.max(required, this.m_countLimit + Math.min(this.m_countLimit, this.m_maximumGrowth));
        String[] grown = new String[size2];
        this.resizeCopy(this.m_baseArray, grown);
        this.m_countLimit = size2;
        this.m_baseArray = grown;
    }

    public final void ensureCapacity(int min2) {
        if (min2 > this.m_countLimit) {
            this.growArray(min2);
        }
    }

    public void set(int index2, String value2) {
        if (index2 >= this.m_countPresent) {
            throw new IllegalArgumentException("Index value out of range");
        }
        this.m_baseArray[index2] = value2;
    }

    public void add(String value2) {
        int index2 = this.getAddIndex();
        this.m_baseArray[index2] = value2;
    }

    public void addAll(String[] values) {
        this.ensureCapacity(this.m_countPresent + values.length);
        for (int i = 0; i < values.length; ++i) {
            this.m_baseArray[this.m_countPresent++] = values[i];
        }
    }

    public void remove(int count2) {
        int start = this.m_countPresent - count2;
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempt to remove too many values from array");
        }
        this.discardValues(start, this.m_countPresent);
        this.m_countPresent = start;
    }

    public String get(int index2) {
        if (this.m_countPresent > index2) {
            return this.m_baseArray[index2];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to access past end of array");
    }

    public String[] toArray() {
        String[] copy = new String[this.m_countPresent];
        System.arraycopy(this.m_baseArray, 0, copy, 0, this.m_countPresent);
        return copy;
    }

    public Object clone() {
        return new GrowableStringArray(this);
    }

    private int getAddIndex() {
        int index2 = this.m_countPresent++;
        if (this.m_countPresent > this.m_countLimit) {
            this.growArray(this.m_countPresent);
        }
        return index2;
    }

    public int size() {
        return this.m_countPresent;
    }

    public boolean isEmpty() {
        return this.m_countPresent == 0;
    }

    public void clear() {
        this.discardValues(0, this.m_countPresent);
        this.m_countPresent = 0;
    }
}

