/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.lang.reflect.Array;

public class GrowableIntArray {
    public static final int DEFAULT_SIZE = 8;
    private int m_countLimit;
    private int m_countPresent;
    private int m_maximumGrowth;
    private int[] m_baseArray;

    public GrowableIntArray(int size2, int growth) {
        int[] array = new int[size2];
        this.m_countLimit = size2;
        this.m_maximumGrowth = growth;
        this.m_baseArray = array;
    }

    public GrowableIntArray(int size2) {
        this(size2, Integer.MAX_VALUE);
    }

    public GrowableIntArray() {
        this(8);
    }

    public GrowableIntArray(GrowableIntArray base) {
        this(base.m_countLimit, base.m_maximumGrowth);
        System.arraycopy(base.m_baseArray, 0, this.m_baseArray, 0, base.m_countPresent);
        this.m_countPresent = base.m_countPresent;
    }

    private void resizeCopy(Object base, Object grown) {
        System.arraycopy(base, 0, grown, 0, Array.getLength(base));
    }

    private void growArray(int required) {
        int size2 = Math.max(required, this.m_countLimit + Math.min(this.m_countLimit, this.m_maximumGrowth));
        int[] grown = new int[size2];
        this.resizeCopy(this.m_baseArray, grown);
        this.m_countLimit = size2;
        this.m_baseArray = grown;
    }

    public final void ensureCapacity(int min2) {
        if (min2 > this.m_countLimit) {
            this.growArray(min2);
        }
    }

    public void set(int index2, int value2) {
        if (index2 >= this.m_countPresent) {
            throw new IllegalArgumentException("Index value out of range");
        }
        this.m_baseArray[index2] = value2;
    }

    public void add(int value2) {
        int index2 = this.getAddIndex();
        this.m_baseArray[index2] = value2;
    }

    public void addAll(int[] values) {
        this.ensureCapacity(this.m_countPresent + values.length);
        for (int i = 0; i < values.length; ++i) {
            this.m_baseArray[this.m_countPresent++] = values[i];
        }
    }

    public void remove(int count2) {
        int start = this.m_countPresent - count2;
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempt to remove too many values from array");
        }
        this.m_countPresent = start;
    }

    public int get(int index2) {
        if (this.m_countPresent > index2) {
            return this.m_baseArray[index2];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to access past end of array");
    }

    public int[] toArray() {
        int[] copy = new int[this.m_countPresent];
        System.arraycopy(this.m_baseArray, 0, copy, 0, this.m_countPresent);
        return copy;
    }

    public Object clone() {
        return new GrowableIntArray(this);
    }

    private int getAddIndex() {
        int index2 = this.m_countPresent++;
        if (this.m_countPresent > this.m_countLimit) {
            this.growArray(this.m_countPresent);
        }
        return index2;
    }

    public int size() {
        return this.m_countPresent;
    }

    public boolean isEmpty() {
        return this.m_countPresent == 0;
    }

    public void clear() {
        this.m_countPresent = 0;
    }
}

