/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.GrowableStringArray;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.RuntimeSupport;
import org.jibx.runtime.impl.StringIntHashMap;
import org.jibx.runtime.impl.UnmarshallingContext;

public abstract class BindingFactoryBase
implements IBindingFactory {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final String m_bindingName;
    private final int m_majorVersion;
    private final int m_minorVersion;
    private final String[] m_bindingClasses;
    private final String[] m_mapNames;
    private final StringIntHashMap m_classIndexMap;
    private final String[] m_unmarshallers;
    private final String[] m_marshallers;
    private final String[] m_uris;
    private final String[] m_prefixes;
    private final String[] m_globalNames;
    private final String[] m_globalUris;
    private final String[] m_idClassNames;
    private final String[][] m_abstractMappingDetails;
    private final int[][] m_abstractMappingNamespaces;
    private final String[] m_baseNames;
    private final String m_baseHashes;
    private final String[] m_bindingFactories;
    private final Class[] m_marshallerClasses;
    private final Class[] m_unmarshallerClasses;
    private final Map m_bindingNamespaceTables;
    private final int m_hash;
    private boolean m_verified;
    private String[] m_bindingClassesClosure;
    private Map m_unmarshalMap;

    protected BindingFactoryBase(String name, int majorver, int minorver, String boundnames, String mappednames, String umarnames, String marnames, String[] uris, String[] prefixes, String gmapnames, String gmapuris, String[] idclasses, String abmapdetails, String abmapnss, String prenames, String prefacts, String prehashes, String[] prensmaps) {
        int i;
        int i2;
        this.m_bindingName = name;
        this.m_majorVersion = majorver;
        this.m_minorVersion = minorver;
        this.m_bindingClasses = RuntimeSupport.splitClassNames(boundnames);
        this.m_mapNames = RuntimeSupport.splitClassNames(mappednames);
        this.m_classIndexMap = new StringIntHashMap(this.m_mapNames.length, 0.1);
        for (int i3 = 0; i3 < this.m_mapNames.length; ++i3) {
            this.m_classIndexMap.add(this.m_mapNames[i3], i3);
        }
        if (marnames == null) {
            this.m_marshallers = null;
            this.m_marshallerClasses = new Class[0];
        } else {
            this.m_marshallers = RuntimeSupport.splitClassNames(marnames);
            this.m_marshallerClasses = new Class[this.m_marshallers.length];
        }
        if (umarnames == null) {
            this.m_unmarshallers = null;
            this.m_unmarshallerClasses = new Class[0];
        } else {
            this.m_unmarshallers = RuntimeSupport.splitClassNames(umarnames);
            this.m_unmarshallerClasses = new Class[this.m_unmarshallers.length];
        }
        this.m_uris = uris;
        this.m_prefixes = prefixes;
        this.m_globalNames = RuntimeSupport.splitNames(gmapnames);
        this.m_globalUris = RuntimeSupport.expandNamespaces(gmapuris, uris);
        this.m_idClassNames = idclasses;
        String[] names = RuntimeSupport.splitClassNames(abmapdetails);
        int abmapcount = names.length / 11;
        String[][] details = new String[11][];
        for (i2 = 0; i2 < 11; ++i2) {
            details[i2] = new String[abmapcount];
        }
        for (i2 = 0; i2 < names.length; ++i2) {
            details[i2 % 11][i2 / 11] = names[i2];
        }
        this.m_abstractMappingDetails = details;
        int[][] nss = new int[abmapcount][];
        int base = 0;
        for (int i4 = 0; i4 < abmapcount; ++i4) {
            int length;
            if ((length = abmapnss.charAt(base++)) == 1) {
                nss[i4] = EMPTY_INT_ARRAY;
                continue;
            }
            int[] indexes = new int[--length];
            for (int j = 0; j < length; ++j) {
                indexes[j] = abmapnss.charAt(base + j) - '\u0001';
            }
            base += length;
            nss[i4] = indexes;
        }
        this.m_abstractMappingNamespaces = nss;
        this.m_baseNames = RuntimeSupport.splitNames(prenames);
        this.m_baseHashes = prehashes;
        this.m_bindingFactories = RuntimeSupport.splitClassNames(prefacts);
        HashMap<String, int[]> tablemap = new HashMap<String, int[]>();
        for (int i5 = 0; i5 < prensmaps.length; ++i5) {
            String blob = prensmaps[i5];
            if (blob == null) continue;
            int[] indexes = RuntimeSupport.splitInts(blob);
            tablemap.put(this.m_bindingFactories[i5], indexes);
        }
        this.m_bindingNamespaceTables = tablemap;
        int hash = name.hashCode() + majorver + minorver + boundnames.hashCode() + mappednames.hashCode();
        if (umarnames != null) {
            hash += umarnames.hashCode();
        }
        if (marnames != null) {
            hash += marnames.hashCode();
        }
        for (i = 0; i < uris.length; ++i) {
            hash += uris[i].hashCode();
        }
        if (prefixes != null) {
            for (i = 0; i < prefixes.length; ++i) {
                String prefix = prefixes[i];
                if (prefix == null) continue;
                hash += prefix.hashCode();
            }
        }
        hash += gmapnames.hashCode() + gmapuris.hashCode();
        if (idclasses != null) {
            for (i = 0; i < idclasses.length; ++i) {
                hash += idclasses[i].hashCode();
            }
        }
        this.m_hash = hash += abmapdetails.hashCode() + abmapnss.hashCode() + prenames.hashCode() + prefacts.hashCode();
    }

    public Class loadClass(String name) {
        Class<?> clas = null;
        ClassLoader factldr = null;
        factldr = this.getClass().getClassLoader();
        try {
            clas = factldr.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clas == null) {
            ClassLoader thisldr;
            ClassLoader ctxldr = Thread.currentThread().getContextClassLoader();
            if (ctxldr != null) {
                try {
                    clas = ctxldr.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (clas == null && (thisldr = BindingFactoryBase.class.getClassLoader()) != factldr && thisldr != ctxldr) {
                try {
                    clas = thisldr.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return clas;
    }

    public IMarshallingContext createMarshallingContext() throws JiBXException {
        return new MarshallingContext(this.m_mapNames, this.m_marshallers, this.m_uris, this);
    }

    public IUnmarshallingContext createUnmarshallingContext() throws JiBXException {
        return new UnmarshallingContext(this.m_unmarshallers.length, this.m_unmarshallers, this.m_globalUris, this.m_globalNames, this.m_idClassNames, this);
    }

    public String getBindingName() {
        return this.m_bindingName;
    }

    public int getHash() {
        return this.m_hash;
    }

    public int getMajorVersion() {
        return this.m_majorVersion;
    }

    public int getMinorVersion() {
        return this.m_minorVersion;
    }

    public String[] getBindingClasses() throws JiBXException {
        this.verifyBaseBindings();
        return this.m_bindingClassesClosure;
    }

    public String[] getElementNames() {
        return this.m_globalNames;
    }

    public String[] getMarshallerClasses() {
        return this.m_marshallers;
    }

    public String[] getUnmarshallerClasses() {
        return this.m_unmarshallers;
    }

    public String[] getElementNamespaces() {
        return this.m_globalUris;
    }

    public String[] getMappedClasses() {
        return this.m_mapNames;
    }

    public StringIntHashMap getClassIndexMap() {
        return this.m_classIndexMap;
    }

    public String[][] getAbstractMappings() {
        return this.m_abstractMappingDetails;
    }

    public int[] getAbstractMappingNamespaces(int index2) {
        return this.m_abstractMappingNamespaces[index2];
    }

    public String[] getNamespaces() {
        return this.m_uris;
    }

    public String[] getBaseBindings() {
        return this.m_baseNames;
    }

    public void verifyBaseBindings() throws JiBXException {
        if (!this.m_verified) {
            if (this.m_bindingFactories.length == 0) {
                this.m_bindingClassesClosure = this.m_bindingClasses;
            } else {
                GrowableStringArray classes = new GrowableStringArray();
                for (int i = 0; i < this.m_bindingFactories.length; ++i) {
                    String fname = this.m_bindingFactories[i];
                    Class fclas = this.loadClass(fname);
                    if (fclas == null) {
                        throw new JiBXException("Unable to load precompiled base binding '" + this.m_baseNames[i] + "' used by binding '" + this.getBindingName() + '\'');
                    }
                    Exception ex = null;
                    try {
                        IBindingFactory fact;
                        Method method = fclas.getMethod("getInstance", BindingDirectory.EMPTY_ARGS);
                        Object result2 = method.invoke(null, (Object[])null);
                        if (result2 instanceof IBindingFactory) {
                            fact = (IBindingFactory)result2;
                            int match = (this.m_baseHashes.charAt(i * 2) << 16) + this.m_baseHashes.charAt(i * 2 + 1);
                            if (fact.getHash() != match) {
                                throw new JiBXException("Precompiled base binding '" + this.m_baseNames[i] + "' has changed since binding '" + this.getBindingName() + "' was compiled");
                            }
                        } else {
                            throw new JiBXException("Classloader conflict for precompiled base binding '" + this.m_baseNames[i] + "' used by binding '" + this.getBindingName() + '\'');
                        }
                        classes.addAll(fact.getBindingClasses());
                    }
                    catch (IllegalAccessException e) {
                        ex = e;
                    }
                    catch (SecurityException e) {
                        ex = e;
                    }
                    catch (NoSuchMethodException e) {
                        ex = e;
                    }
                    catch (InvocationTargetException e) {
                        ex = e;
                    }
                    if (ex == null) continue;
                    throw new JiBXException("Error creating factory for precompiled base binding '" + this.m_baseNames[i] + "' used by binding '" + this.getBindingName() + "':" + ex.getMessage());
                }
                this.m_bindingClassesClosure = classes.toArray();
            }
            this.m_verified = true;
        }
    }

    public String[] getBaseBindingFactories() {
        return this.m_bindingFactories;
    }

    public Map getNamespaceTranslationTableMap() {
        return this.m_bindingNamespaceTables;
    }

    public String[] getPrefixes() {
        return this.m_prefixes;
    }

    public synchronized Map getUnmarshalMap() {
        if (this.m_unmarshalMap == null) {
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            for (int i = 0; i < this.m_globalNames.length; ++i) {
                String name = this.m_globalNames[i];
                if (name == null) continue;
                Object value2 = map2.get(name);
                if (value2 instanceof Integer) {
                    int[] ints = new int[]{(Integer)value2, i};
                    map2.put(name, ints);
                    continue;
                }
                if (value2 instanceof int[]) {
                    int[] olds = (int[])value2;
                    int length = olds.length;
                    int[] ints = new int[length + 1];
                    System.arraycopy(olds, 0, ints, 0, length);
                    ints[length] = i;
                    map2.put(name, ints);
                    continue;
                }
                map2.put(name, new Integer(i));
            }
            this.m_unmarshalMap = map2;
        }
        return this.m_unmarshalMap;
    }

    public Class getMarshallerClass(int index2) {
        Class clas = this.m_marshallerClasses[index2];
        if (clas == null) {
            clas = this.loadClass(this.m_marshallers[index2]);
        }
        return clas;
    }

    public Class getUnmarshallerClass(int index2) {
        Class clas = this.m_unmarshallerClasses[index2];
        if (clas == null) {
            clas = this.loadClass(this.m_unmarshallers[index2]);
        }
        return clas;
    }
}

