/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.jibx.runtime.IListItemDeserializer;
import org.jibx.runtime.JiBXException;

public abstract class Utility {
    public static final String[] EMPTY_STRING_ARRAY;
    public static final int MINIMUM_GROWN_ARRAY_SIZE = 16;
    private static final int MSPERMINUTE = 60000;
    private static final int MSPERHOUR = 3600000;
    private static final int MSPERDAY = 86400000;
    private static final long LMSPERDAY = 86400000L;
    private static final long MSPERYEAR = 31536000000L;
    private static final long MSPERAVGYEAR = 31557600000L;
    private static final long MSPERCENTURY = 3155695200000L;
    static final long TIME_BASE = 62135596800000L;
    static final int[] MONTHS_NONLEAP;
    static final int[] MONTHS_LEAP;
    private static final long[] BIAS_MONTHMS;
    private static java.util.Date BEGINNING_OF_TIME;
    private static final char PAD_CHAR = '=';
    private static final char[] s_base64Chars;
    private static final byte[] s_base64Values;

    static int parseDigits(String text2, int offset, int length) throws JiBXException {
        int value2 = 0;
        if (length > 9) {
            try {
                value2 = Integer.parseInt(text2.substring(offset, offset + length));
            }
            catch (NumberFormatException ex) {
                throw new JiBXException(ex.getMessage());
            }
        } else {
            int limit = offset + length;
            while (offset < limit) {
                char chr;
                if ((chr = text2.charAt(offset++)) >= '0' && chr <= '9') {
                    value2 = value2 * 10 + (chr - 48);
                    continue;
                }
                throw new JiBXException("Non-digit in number value");
            }
        }
        return value2;
    }

    public static int parseInt(String text2) throws JiBXException {
        text2 = text2.trim();
        int offset = 0;
        int limit = text2.length();
        if (limit == 0) {
            throw new JiBXException("Empty number value");
        }
        boolean negate = false;
        char chr = text2.charAt(0);
        if (chr == '-') {
            if (limit > 9) {
                try {
                    return Integer.parseInt(text2);
                }
                catch (NumberFormatException ex) {
                    throw new JiBXException(ex.getMessage());
                }
            }
            negate = true;
            ++offset;
        } else if (chr == '+') {
            ++offset;
        }
        if (offset >= limit) {
            throw new JiBXException("Invalid number format");
        }
        int value2 = Utility.parseDigits(text2, offset, limit - offset);
        if (negate) {
            return -value2;
        }
        return value2;
    }

    public static String serializeInt(int value2) {
        return Integer.toString(value2);
    }

    public static boolean ifBoolean(String text2) {
        return "0".equals(text2) || "1".equals(text2) || "true".equals(text2) || "false".equals(text2);
    }

    public static long parseLong(String text2) throws JiBXException {
        text2 = text2.trim();
        int offset = 0;
        int limit = text2.length();
        if (limit == 0) {
            throw new JiBXException("Empty number value");
        }
        boolean negate = false;
        char chr = text2.charAt(0);
        if (chr == '-') {
            negate = true;
            ++offset;
        } else if (chr == '+') {
            ++offset;
        }
        if (offset >= limit) {
            throw new JiBXException("Invalid number format");
        }
        long value2 = 0L;
        if (limit - offset > 18) {
            if (chr == '+') {
                text2 = text2.substring(1);
            }
            try {
                value2 = Long.parseLong(text2);
            }
            catch (NumberFormatException ex) {
                throw new JiBXException(ex.getMessage());
            }
        } else {
            while (offset < limit) {
                if ((chr = text2.charAt(offset++)) >= '0' && chr <= '9') {
                    value2 = value2 * 10L + (long)(chr - 48);
                    continue;
                }
                throw new JiBXException("Non-digit in number value");
            }
            if (negate) {
                value2 = -value2;
            }
        }
        return value2;
    }

    public static String serializeLong(long value2) {
        return Long.toString(value2);
    }

    public static long parseYear(String text2) throws JiBXException {
        text2 = text2.trim();
        boolean valid = true;
        int minc = 4;
        char chr = text2.charAt(0);
        if (chr == '-') {
            minc = 5;
        } else if (chr == '+') {
            valid = false;
        }
        if (text2.length() < minc) {
            valid = false;
        }
        if (!valid) {
            throw new JiBXException("Invalid year format");
        }
        int year = Utility.parseInt(text2);
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        if (year > 0) {
            --year;
        }
        long day = (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400);
        return day * 86400000L - 62135596800000L;
    }

    public static short parseShort(String text2) throws JiBXException {
        int value2 = Utility.parseInt(text2);
        if (value2 < Short.MIN_VALUE || value2 > Short.MAX_VALUE) {
            throw new JiBXException("Value out of range");
        }
        return (short)value2;
    }

    public static String serializeShort(short value2) {
        return Short.toString(value2);
    }

    public static byte parseByte(String text2) throws JiBXException {
        int value2 = Utility.parseInt(text2);
        if (value2 < -128 || value2 > 127) {
            throw new JiBXException("Value out of range");
        }
        return (byte)value2;
    }

    public static String serializeByte(byte value2) {
        return Byte.toString(value2);
    }

    public static boolean parseBoolean(String text2) throws JiBXException {
        if ("true".equals(text2 = text2.trim()) || "1".equals(text2)) {
            return true;
        }
        if ("false".equals(text2) || "0".equals(text2)) {
            return false;
        }
        throw new JiBXException("Invalid boolean value");
    }

    public static Boolean deserializeBoolean(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return Utility.parseBoolean(text2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String serializeBoolean(boolean value2) {
        return value2 ? "true" : "false";
    }

    public static String serializeBoolean(Boolean value2) {
        if (value2 == null) {
            return null;
        }
        return Utility.serializeBoolean((boolean)value2);
    }

    public static char parseChar(String text2) throws JiBXException {
        int value2 = Utility.parseInt(text2);
        if (value2 < 0 || value2 > 65535) {
            throw new JiBXException("Value out of range");
        }
        return (char)value2;
    }

    public static String serializeChar(char value2) {
        return Integer.toString(value2);
    }

    public static char parseCharString(String text2) throws JiBXException {
        if (text2.length() == 1) {
            return text2.charAt(0);
        }
        throw new JiBXException("Input must be a single character");
    }

    public static char deserializeCharString(String text2) throws JiBXException {
        if (text2 == null) {
            return '\u0000';
        }
        return Utility.parseCharString(text2);
    }

    public static String serializeCharString(char value2) {
        return String.valueOf(value2);
    }

    public static float parseFloat(String text2) throws JiBXException {
        if ("-INF".equals(text2 = text2.trim())) {
            return Float.NEGATIVE_INFINITY;
        }
        if ("INF".equals(text2)) {
            return Float.POSITIVE_INFINITY;
        }
        try {
            return Float.parseFloat(text2);
        }
        catch (NumberFormatException ex) {
            throw new JiBXException(ex.getMessage());
        }
    }

    public static String serializeFloat(float value2) {
        if (Float.isInfinite(value2)) {
            return value2 < 0.0f ? "-INF" : "INF";
        }
        return Float.toString(value2);
    }

    public static double parseDouble(String text2) throws JiBXException {
        if ("-INF".equals(text2 = text2.trim())) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("INF".equals(text2)) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            return Double.parseDouble(text2);
        }
        catch (NumberFormatException ex) {
            throw new JiBXException(ex.getMessage());
        }
    }

    public static String serializeDouble(double value2) {
        if (Double.isInfinite(value2)) {
            return value2 < 0.0 ? "-INF" : "INF";
        }
        return Double.toString(value2);
    }

    public static long parseYearMonth(String text2) throws JiBXException {
        boolean leap;
        text2 = text2.trim();
        boolean valid = true;
        int minc = 7;
        char chr = text2.charAt(0);
        if (chr == '-') {
            minc = 8;
        } else if (chr == '+') {
            valid = false;
        }
        int split2 = text2.length() - 3;
        if (text2.length() < minc) {
            valid = false;
        } else if (text2.charAt(split2) != '-') {
            valid = false;
        }
        if (!valid) {
            throw new JiBXException("Invalid date format");
        }
        int year = Utility.parseInt(text2.substring(0, split2));
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int month = Utility.parseDigits(text2, split2 + 1, 2) - 1;
        if (month < 0 || month > 11) {
            throw new JiBXException("Month value out of range");
        }
        boolean bl = leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        if (year > 0) {
            --year;
        }
        long day = (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400) + (long)(leap ? MONTHS_LEAP : MONTHS_NONLEAP)[month];
        return day * 86400000L - 62135596800000L;
    }

    public static long parseDate(String text2) throws JiBXException {
        int[] starts2;
        if (!Utility.ifDate(text2)) {
            throw new JiBXException("Invalid date format");
        }
        int split2 = text2.indexOf(45, 1);
        int year = Utility.parseInt(text2.substring(0, split2));
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int month = Utility.parseDigits(text2, split2 + 1, 2) - 1;
        if (month < 0 || month > 11) {
            throw new JiBXException("Month value out of range");
        }
        long day = Utility.parseDigits(text2, split2 + 4, 2) - 1;
        boolean leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        int[] nArray = starts2 = leap ? MONTHS_LEAP : MONTHS_NONLEAP;
        if (day < 0L || day >= (long)(starts2[month + 1] - starts2[month])) {
            throw new JiBXException("Day value out of range");
        }
        if (year > 0) {
            --year;
        }
        return (day += (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400) + (long)starts2[month]) * 86400000L - 62135596800000L;
    }

    public static java.util.Date deserializeDate(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return new java.util.Date(Utility.parseDate(text2));
    }

    public static Date deserializeSqlDate(String text2) throws JiBXException {
        GregorianCalendar cal;
        int[] starts2;
        if (text2 == null) {
            return null;
        }
        if (!Utility.ifDate(text2)) {
            throw new JiBXException("Invalid date format");
        }
        int split2 = text2.indexOf(45, 1);
        int year = Utility.parseInt(text2.substring(0, split2));
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int month = Utility.parseDigits(text2, split2 + 1, 2) - 1;
        if (month < 0 || month > 11) {
            throw new JiBXException("Month value out of range");
        }
        int day = Utility.parseDigits(text2, split2 + 4, 2) - 1;
        boolean leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        int[] nArray = starts2 = leap ? MONTHS_LEAP : MONTHS_NONLEAP;
        if (day < 0 || day >= starts2[month + 1] - starts2[month]) {
            throw new JiBXException("Day value out of range");
        }
        if (year < 0) {
            ++year;
        }
        if (year < 1800) {
            cal = new GregorianCalendar();
            cal.setGregorianChange(BEGINNING_OF_TIME);
            cal.clear();
            cal.set(year, month, day + 1);
        } else {
            cal = new GregorianCalendar(year, month, day + 1);
        }
        return new Date(cal.getTime().getTime());
    }

    public static long parseTimeNoOffset(String text2, int start, int length) throws JiBXException {
        boolean valid;
        long milli = 0L;
        boolean bl = valid = length > start + 7 && text2.charAt(start + 2) == ':' && text2.charAt(start + 5) == ':';
        if (valid) {
            int hour = Utility.parseDigits(text2, start, 2);
            int minute = Utility.parseDigits(text2, start + 3, 2);
            int second = Utility.parseDigits(text2, start + 6, 2);
            if (hour > 24 || minute > 59 || second > 60 || hour == 24 && (minute != 0 || second != 0)) {
                valid = false;
            } else {
                milli = ((hour * 60 + minute) * 60 + second) * 1000;
                int base = start + 8;
                if (length > base && text2.charAt(base) == '.') {
                    char chr;
                    int end;
                    for (end = base + 1; end < length && (chr = text2.charAt(end)) >= '0' && chr <= '9'; ++end) {
                    }
                    double fraction = Double.parseDouble(text2.substring(base, end));
                    valid = hour < 24 || fraction == 0.0;
                    milli = (long)((double)milli + fraction * 1000.0);
                }
            }
        }
        if (valid) {
            return milli;
        }
        throw new JiBXException("Invalid time format: " + text2);
    }

    public static long parseTime(String text2, int start, int length) throws JiBXException {
        long milli = Utility.parseTimeNoOffset(text2, start, length);
        if (length > (start += 8)) {
            if (text2.charAt(length - 1) == 'Z') {
                --length;
            } else {
                char chr = text2.charAt(length - 6);
                if (chr == '-' || chr == '+') {
                    int hour = Utility.parseDigits(text2, length - 5, 2);
                    int minute = Utility.parseDigits(text2, length - 2, 2);
                    if (hour > 14 || minute > 59 || hour == 14 && minute != 0) {
                        throw new JiBXException("Invalid time zone offset: " + text2);
                    }
                    int offset = (hour * 60 + minute) * 60 * 1000;
                    milli = chr == '-' ? (milli += (long)offset) : (milli -= (long)offset);
                }
            }
        }
        return milli;
    }

    public static long parseDateTime(String text2) throws JiBXException {
        int split2 = text2.indexOf(84);
        if (split2 < 0) {
            throw new JiBXException("Missing 'T' separator in dateTime");
        }
        return Utility.parseDate(text2.substring(0, split2)) + Utility.parseTime(text2, split2 + 1, text2.length());
    }

    public static java.util.Date deserializeDateTime(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return new java.util.Date(Utility.parseDateTime(text2));
    }

    public static Timestamp deserializeTimestamp(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        int split2 = text2.indexOf(46);
        int nano = 0;
        if (split2 > 0) {
            char chr;
            if (text2.indexOf(46, split2 + 1) > 0) {
                throw new JiBXException("Not a valid timestamp value");
            }
            int limit = text2.length();
            int scan2 = split2;
            while (++scan2 < limit && (chr = text2.charAt(scan2)) >= '0' && chr <= '9') {
            }
            int length = scan2 - split2 - 1;
            if (length > 9) {
                length = 9;
            }
            nano = Utility.parseDigits(text2, split2 + 1, length);
            while (length < 9) {
                nano *= 10;
                ++length;
            }
            text2 = scan2 < limit ? text2.substring(0, split2) + text2.substring(scan2) : text2.substring(0, split2);
        }
        Timestamp stamp = new Timestamp(Utility.parseDateTime(text2));
        stamp.setNanos(nano);
        return stamp;
    }

    public static Time deserializeSqlTime(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return new Time(Utility.parseTime(text2, 0, text2.length()));
    }

    protected static void formatYearNumber(long year, StringBuffer buff) {
        if (year <= 0L) {
            buff.append('-');
            year = -(year - 1L);
        }
        if (year < 1000L) {
            buff.append('0');
            if (year < 100L) {
                buff.append('0');
                if (year < 10L) {
                    buff.append('0');
                }
            }
        }
        buff.append(year);
    }

    protected static void formatTwoDigits(int value2, StringBuffer buff) {
        if (value2 < 10) {
            buff.append('0');
        }
        buff.append(value2);
    }

    protected static void formatYear(long value2, StringBuffer buff) {
        long yms;
        int yday;
        int month;
        long time = value2 + 26438400000L + 64800000L;
        long century = time / 3155695200000L;
        long adjusted = time + (century - century / 4L) * 86400000L;
        int year = (int)(adjusted / 31557600000L);
        if (adjusted < 0L) {
            --year;
        }
        if ((month = (5 * (yday = (int)((yms = adjusted + 21600000L - (long)(year * 365 + year / 4) * 86400000L) / 86400000L)) + 456) / 153) > 12) {
            ++year;
        }
        Utility.formatYearNumber(year, buff);
    }

    protected static long formatYearMonth(long value2, StringBuffer buff) {
        long yms;
        int yday;
        long time = value2 + 26438400000L + 64800000L;
        long century = time / 3155695200000L;
        long adjusted = time + (century - century / 4L) * 86400000L;
        int year = (int)(adjusted / 31557600000L);
        if (adjusted < 0L) {
            --year;
        }
        if ((yday = (int)((yms = adjusted + 21600000L - (long)(year * 365 + year / 4) * 86400000L) / 86400000L)) == 0) {
            int dcnt;
            boolean bce;
            boolean bl = bce = year < 0;
            if (bce) {
                --year;
            }
            int n = dcnt = year % 4 == 0 ? 366 : 365;
            if (!bce) {
                --year;
            }
            yms += (long)dcnt * 86400000L;
            yday += dcnt;
        }
        int month = (5 * yday + 456) / 153;
        long rem = yms - BIAS_MONTHMS[month] - 86400000L;
        if (month > 12) {
            ++year;
            month -= 12;
        }
        Utility.formatYearNumber(year, buff);
        buff.append('-');
        Utility.formatTwoDigits(month, buff);
        return rem;
    }

    protected static int formatYearMonthDay(long value2, StringBuffer buff) {
        long extra = Utility.formatYearMonth(value2, buff);
        int day = (int)(extra / 86400000L) + 1;
        buff.append('-');
        Utility.formatTwoDigits(day, buff);
        return (int)(extra % 86400000L);
    }

    public static String serializeYear(long time) {
        StringBuffer buff = new StringBuffer(6);
        Utility.formatYear(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeYear(java.util.Date date) {
        return Utility.serializeYear(date.getTime());
    }

    public static String serializeYearMonth(long time) {
        StringBuffer buff = new StringBuffer(12);
        Utility.formatYearMonth(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeYearMonth(java.util.Date date) {
        return Utility.serializeYearMonth(date.getTime());
    }

    public static String serializeDate(long time) {
        StringBuffer buff = new StringBuffer(12);
        Utility.formatYearMonthDay(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeDate(java.util.Date date) {
        return Utility.serializeDate(date.getTime());
    }

    public static String serializeSqlDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setGregorianChange(BEGINNING_OF_TIME);
        cal.setTime(date);
        StringBuffer buff = new StringBuffer(12);
        int year = cal.get(1);
        if (date.getTime() < 0L && cal.get(0) == 0) {
            year = -year + 1;
        }
        Utility.formatYearNumber(year, buff);
        buff.append('-');
        Utility.formatTwoDigits(cal.get(2) + 1, buff);
        buff.append('-');
        Utility.formatTwoDigits(cal.get(5), buff);
        return buff.toString();
    }

    public static void serializeExplicitOffset(int offset, StringBuffer buff) {
        int abs;
        if (offset < 0) {
            abs = -offset;
            buff.append('-');
        } else {
            abs = offset;
            buff.append('+');
        }
        Utility.formatTwoDigits(abs / 3600000, buff);
        buff.append(':');
        Utility.formatTwoDigits((abs %= 3600000) / 60000, buff);
    }

    public static void serializeOffset(int offset, StringBuffer buff) {
        if (offset == 0) {
            buff.append('Z');
        } else {
            Utility.serializeExplicitOffset(offset, buff);
        }
    }

    public static void serializeTime(int time, StringBuffer buff) {
        Utility.formatTwoDigits(time / 3600000, buff);
        buff.append(':');
        Utility.formatTwoDigits((time %= 3600000) / 60000, buff);
        buff.append(':');
        Utility.formatTwoDigits((time %= 60000) / 1000, buff);
        if ((time %= 1000) > 0) {
            buff.append('.');
            buff.append(time / 100);
            if ((time %= 100) > 0) {
                buff.append(time / 10);
                if ((time %= 10) > 0) {
                    buff.append(time);
                }
            }
        }
    }

    public static String serializeDateTime(long time, boolean zone) {
        StringBuffer buff = new StringBuffer(25);
        int extra = Utility.formatYearMonthDay(time + 62135596800000L, buff);
        buff.append('T');
        Utility.serializeTime(extra, buff);
        if (zone) {
            buff.append('Z');
        }
        return buff.toString();
    }

    public static String serializeDateTime(long time) {
        return Utility.serializeDateTime(time, false);
    }

    public static String serializeDateTime(java.util.Date date) {
        return Utility.serializeDateTime(date.getTime(), true);
    }

    public static String serializeTimestamp(Timestamp stamp) {
        int nano = stamp.getNanos();
        if (nano > 0) {
            String value2 = Utility.serializeInt(nano);
            StringBuffer digits = new StringBuffer(9);
            if (value2.length() < 9) {
                int lead = 9 - value2.length();
                for (int i = 0; i < lead; ++i) {
                    digits.append('0');
                }
            }
            digits.append(value2);
            int last2 = 9;
            while (--last2 >= 0 && digits.charAt(last2) == '0') {
            }
            digits.setLength(last2 + 1);
            long time = stamp.getTime();
            return Utility.serializeDateTime(time - time % 1000L, false) + '.' + digits + 'Z';
        }
        return Utility.serializeDateTime(stamp.getTime(), true);
    }

    public static String serializeSqlTime(Time time) {
        StringBuffer buff = new StringBuffer(12);
        Utility.serializeTime((int)time.getTime(), buff);
        return buff.toString();
    }

    public static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static int enumValue(String target, String[] enums, int[] vals) throws JiBXException {
        int base = 0;
        int limit = enums.length - 1;
        while (base <= limit) {
            int cur = base + limit >> 1;
            int diff2 = target.compareTo(enums[cur]);
            if (diff2 < 0) {
                limit = cur - 1;
                continue;
            }
            if (diff2 > 0) {
                base = cur + 1;
                continue;
            }
            if (vals != null) {
                return vals[cur];
            }
            return cur;
        }
        throw new JiBXException("Target value \"" + target + "\" not found in enumeration");
    }

    private static int decodeChunk(int base, char[] chrs, int fill2, byte[] byts) {
        int length = 3;
        if (chrs[base + 3] == '=') {
            length = 2;
            if (chrs[base + 2] == '=') {
                length = 1;
            }
        }
        byte v0 = s_base64Values[chrs[base + 0]];
        byte v1 = s_base64Values[chrs[base + 1]];
        byte v2 = s_base64Values[chrs[base + 2]];
        byte v3 = s_base64Values[chrs[base + 3]];
        switch (length) {
            case 3: {
                byts[fill2 + 2] = (byte)(v2 << 6 | v3);
            }
            case 2: {
                byts[fill2 + 1] = (byte)(v1 << 4 | v2 >> 2);
            }
            case 1: {
                byts[fill2] = (byte)(v0 << 2 | v1 >> 4);
            }
        }
        return length;
    }

    public static byte[] parseBase64(String text2) throws JiBXException {
        char[] chrs = new char[text2.length()];
        int length = 0;
        for (int i = 0; i < text2.length(); ++i) {
            char chr = text2.charAt(i);
            if (chr >= '\u0080' || s_base64Values[chr] < 0) continue;
            chrs[length++] = chr;
        }
        if (length % 4 != 0) {
            throw new JiBXException("Text length for base64 must be a multiple of 4");
        }
        if (length == 0) {
            return new byte[0];
        }
        int blength = length / 4 * 3;
        if (chrs[length - 1] == '=') {
            --blength;
            if (chrs[length - 2] == '=') {
                --blength;
            }
        }
        byte[] byts = new byte[blength];
        int fill2 = 0;
        for (int i = 0; i < length; i += 4) {
            fill2 += Utility.decodeChunk(i, chrs, fill2, byts);
        }
        if (fill2 != blength) {
            throw new JiBXException("Embedded padding characters in byte64 text");
        }
        return byts;
    }

    public static byte[] deserializeBase64(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return Utility.parseBase64(text2);
    }

    public static void encodeChunk(int base, byte[] byts, StringBuffer buff) {
        int length = 3;
        if (base + length > byts.length) {
            length = byts.length - base;
        }
        byte b0 = byts[base];
        int value2 = b0 >> 2 & 0x3F;
        buff.append(s_base64Chars[value2]);
        if (length > 1) {
            byte b1 = byts[base + 1];
            value2 = ((b0 & 3) << 4) + (b1 >> 4 & 0xF);
            buff.append(s_base64Chars[value2]);
            if (length > 2) {
                byte b2 = byts[base + 2];
                value2 = ((b1 & 0xF) << 2) + (b2 >> 6 & 3);
                buff.append(s_base64Chars[value2]);
                value2 = b2 & 0x3F;
                buff.append(s_base64Chars[value2]);
            } else {
                value2 = (b1 & 0xF) << 2;
                buff.append(s_base64Chars[value2]);
                buff.append('=');
            }
        } else {
            value2 = (b0 & 3) << 4;
            buff.append(s_base64Chars[value2]);
            buff.append('=');
            buff.append('=');
        }
    }

    public static String serializeBase64(byte[] byts) {
        StringBuffer buff = new StringBuffer((byts.length + 2) / 3 * 4);
        for (int i = 0; i < byts.length; i += 3) {
            Utility.encodeChunk(i, byts, buff);
            if (i <= 0 || i % 57 != 0 || i + 3 >= byts.length) continue;
            buff.append("\r\n");
        }
        return buff.toString();
    }

    public static Object resizeArray(int size2, Object base) {
        int prior = Array.getLength(base);
        if (size2 == prior) {
            return base;
        }
        Class<?> type = base.getClass().getComponentType();
        Object copy = Array.newInstance(type, size2);
        int count2 = Math.min(size2, prior);
        System.arraycopy(base, 0, copy, 0, count2);
        return copy;
    }

    public static Object growArray(Object base) {
        int length = Array.getLength(base);
        Class<?> type = base.getClass().getComponentType();
        int newlen = Math.max(length * 2, 16);
        Object copy = Array.newInstance(type, newlen);
        System.arraycopy(base, 0, copy, 0, length);
        return copy;
    }

    public static List arrayListFactory() {
        return new ArrayList();
    }

    public static ArrayList deserializeList(String text2, IListItemDeserializer ideser) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        int length = text2.length();
        int base = 0;
        boolean space = true;
        block3: for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!space) {
                        String itext = text2.substring(base, i);
                        items.add(ideser.deserialize(itext));
                        space = true;
                    }
                    base = i + 1;
                    continue block3;
                }
                default: {
                    space = false;
                }
            }
        }
        if (base < length) {
            String itext = text2.substring(base);
            items.add(ideser.deserialize(itext));
        }
        if (items.size() > 0) {
            return items;
        }
        return null;
    }

    public static String[] deserializeTokenList(String text2) throws JiBXException {
        IListItemDeserializer ldser = new IListItemDeserializer(){

            public Object deserialize(String text2) throws JiBXException {
                return text2;
            }
        };
        ArrayList list2 = Utility.deserializeList(text2, ldser);
        if (list2 == null) {
            return null;
        }
        return list2.toArray(new String[list2.size()]);
    }

    public static String serializeTokenList(String[] tokens) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append(tokens[i]);
        }
        return buff.toString();
    }

    public static boolean safeEquals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean ifEqualSubstring(String match, String text2, int offset) {
        int length = match.length();
        if (text2.length() >= offset + length) {
            for (int i = offset; i < length; ++i) {
                if (match.charAt(i) == text2.charAt(offset + i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ifInIntegerRange(String text2, int digitmax, String abslimit) {
        if (text2.length() >= 1) {
            int length = text2.length();
            int first = 0;
            boolean negate = false;
            char chr = text2.charAt(0);
            if (chr == '-') {
                negate = true;
                first = 1;
            } else if (chr == '+') {
                first = 1;
            }
            for (int i = first; i < length; ++i) {
                chr = text2.charAt(i);
                if (chr < '0' || chr > '9') {
                    return false;
                }
                if (chr != '0' || i != first) continue;
                ++first;
            }
            int digitcnt = length - first;
            if (digitcnt > digitmax) {
                return false;
            }
            if (digitcnt == digitmax) {
                String number2 = text2;
                if (first > 0) {
                    number2 = text2.substring(first);
                }
                if (negate) {
                    return abslimit.compareTo(number2) > 0;
                }
                return abslimit.compareTo(number2) >= 0;
            }
            return true;
        }
        return false;
    }

    public static boolean ifByte(String text2) {
        return Utility.ifInIntegerRange(text2, 3, "128");
    }

    public static boolean ifShort(String text2) {
        return Utility.ifInIntegerRange(text2, 5, "32768");
    }

    public static boolean ifInt(String text2) {
        return Utility.ifInIntegerRange(text2, 10, "2147483648");
    }

    public static boolean ifLong(String text2) {
        return Utility.ifInIntegerRange(text2, 19, "9223372036854775808");
    }

    public static boolean ifInteger(String text2) {
        return Utility.ifInIntegerRange(text2, Integer.MAX_VALUE, null);
    }

    public static boolean ifDigits(String text2, int offset, int limit) {
        if (text2.length() < limit) {
            return false;
        }
        for (int i = offset; i < limit; ++i) {
            char chr = text2.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean ifDecimal(String text2) {
        if (text2.length() == 0) {
            return false;
        }
        int length = text2.length();
        int first = 0;
        char chr = text2.charAt(0);
        if (chr == '-') {
            first = 1;
        } else if (chr == '+') {
            first = 1;
        }
        if (first == length) {
            return false;
        }
        boolean decimal = false;
        for (int i = first; i < length; ++i) {
            chr = text2.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            if (!decimal && chr == '.') {
                decimal = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean ifFixedDigits(String text2, int offset, String bound) {
        int length = bound.length();
        boolean lessthan = false;
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(offset + i);
            if (chr < '0' || chr > '9') {
                return false;
            }
            if (lessthan) continue;
            int diff2 = bound.charAt(i) - chr;
            if (diff2 > 0) {
                lessthan = true;
                continue;
            }
            if (diff2 >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean ifZoneSuffix(String text2, int offset) {
        int length = text2.length();
        if (length <= offset) {
            return true;
        }
        char chr = text2.charAt(offset);
        if (length == offset + 1 && chr == 'Z') {
            return true;
        }
        if (length == offset + 6 && (chr == '+' || chr == '-') && text2.charAt(offset + 3) == ':') {
            if (Utility.ifEqualSubstring("14", text2, offset + 1)) {
                return Utility.ifEqualSubstring("00", text2, offset + 4);
            }
            return Utility.ifFixedDigits(text2, offset + 1, "13") && Utility.ifFixedDigits(text2, offset + 4, "59");
        }
        return false;
    }

    public static boolean ifDate(String text2) {
        if (text2.length() < 10) {
            return false;
        }
        int base = 0;
        int split2 = text2.indexOf(45);
        if (split2 == 0) {
            base = 1;
            split2 = text2.indexOf(45, 1);
        }
        if (split2 > 0 && text2.length() - split2 >= 5 && Utility.ifDigits(text2, base, split2) && text2.charAt(split2 + 3) == '-' && Utility.ifFixedDigits(text2, split2 + 1, "12") && Utility.ifFixedDigits(text2, split2 + 4, "31")) {
            return Utility.ifZoneSuffix(text2, split2 + 6);
        }
        return false;
    }

    public static boolean ifTimeSuffix(String text2, int offset) {
        if (text2.length() - offset >= 8 && (Utility.ifEqualSubstring("24:00:00", text2, offset) || Utility.ifFixedDigits(text2, offset, "23") && text2.charAt(offset + 2) == ':' && Utility.ifFixedDigits(text2, offset + 3, "59") && text2.charAt(offset + 5) == ':' && Utility.ifFixedDigits(text2, offset + 6, "60"))) {
            int base = offset + 8;
            int length = text2.length();
            if (base < length && text2.charAt(base) == '.') {
                char chr;
                while (++base < length && (chr = text2.charAt(base)) >= '0' && chr <= '9') {
                }
            }
            return Utility.ifZoneSuffix(text2, base);
        }
        return false;
    }

    public static boolean ifDateTime(String text2) {
        if (text2.length() < 19) {
            return false;
        }
        int base = 0;
        int split2 = text2.indexOf(45);
        if (split2 == 0) {
            base = 1;
            split2 = text2.indexOf(45, 1);
        }
        if (split2 > 0 && text2.length() - split2 >= 14 && Utility.ifDigits(text2, base, split2) && text2.charAt(split2 + 3) == '-' && Utility.ifFixedDigits(text2, split2 + 1, "12") && Utility.ifFixedDigits(text2, split2 + 4, "31") && text2.charAt(split2 + 6) == 'T') {
            return Utility.ifTimeSuffix(text2, split2 + 7);
        }
        return false;
    }

    public static boolean ifTime(String text2) {
        return Utility.ifTimeSuffix(text2, 0);
    }

    static {
        int i;
        EMPTY_STRING_ARRAY = new String[0];
        MONTHS_NONLEAP = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        MONTHS_LEAP = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
        BIAS_MONTHMS = new long[]{0L, 0L, 0L, 0L, 2678400000L, 5270400000L, 7948800000L, 10540800000L, 13219200000L, 15897600000L, 18489600000L, 21168000000L, 23760000000L, 26438400000L, 29116800000L};
        BEGINNING_OF_TIME = new java.util.Date(Long.MIN_VALUE);
        s_base64Chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        s_base64Values = new byte[128];
        for (i = 0; i < s_base64Values.length; ++i) {
            Utility.s_base64Values[i] = -1;
        }
        Utility.s_base64Values[61] = 0;
        for (i = 0; i < s_base64Chars.length; ++i) {
            Utility.s_base64Values[Utility.s_base64Chars[i]] = (byte)i;
        }
    }
}

