/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

public abstract class JodaConvert {
    public static LocalDate deserializeLocalDate(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return new LocalDate(Utility.parseDate(text2), DateTimeZone.UTC);
    }

    public static String serializeLocalDate(LocalDate date) {
        return Utility.serializeDate(date.toDateTimeAtStartOfDay(DateTimeZone.UTC).getMillis());
    }

    protected static DateMidnight deserializeDateMidnight(String text2, DateTimeZone zone) throws JiBXException {
        int[] starts2;
        if (!Utility.ifDate(text2)) {
            throw new JiBXException("Invalid date format");
        }
        int split2 = text2.indexOf(45, 1);
        int year = Utility.parseInt(text2.substring(0, split2));
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int month = Utility.parseDigits(text2, split2 + 1, 2);
        if (month < 1 || month > 12) {
            throw new JiBXException("Month value out of range");
        }
        int day = Utility.parseDigits(text2, split2 + 4, 2);
        boolean leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        int[] nArray = starts2 = leap ? Utility.MONTHS_LEAP : Utility.MONTHS_NONLEAP;
        if (day < 1 || day > starts2[month] - starts2[month - 1]) {
            throw new JiBXException("Day value out of range");
        }
        return new DateMidnight(year, month, day, zone);
    }

    protected static DateTimeZone findZone(String text2, DateTimeZone dflt) throws JiBXException {
        char chr;
        int length = text2.length();
        if (text2.charAt(length - 1) == 'Z') {
            return DateTimeZone.UTC;
        }
        int offset = length - 6;
        if (text2.indexOf(45, 1) < offset && ((chr = text2.charAt(offset)) == '-' || chr == '+')) {
            int hour = Utility.parseDigits(text2, offset + 1, 2);
            int minute = Utility.parseDigits(text2, offset + 4, 2);
            if (hour > 14 || minute > 59 || hour == 14 && minute != 0) {
                throw new JiBXException("Invalid time zone offset: " + text2);
            }
            if (chr == '-') {
                return DateTimeZone.forOffsetHoursMinutes(-hour, minute);
            }
            return DateTimeZone.forOffsetHoursMinutes(hour, minute);
        }
        return dflt;
    }

    public static DateMidnight deserializeZonedDateMidnight(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        DateTimeZone zone = JodaConvert.findZone(text2, DateTimeZone.getDefault());
        return JodaConvert.deserializeDateMidnight(text2, zone);
    }

    public static DateMidnight deserializeLocalDateMidnight(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return JodaConvert.deserializeDateMidnight(text2, DateTimeZone.getDefault());
    }

    public static DateMidnight deserializeUTCDateMidnight(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return JodaConvert.deserializeDateMidnight(text2, DateTimeZone.UTC);
    }

    public static String serializeUnzonedDateMidnight(DateMidnight date) {
        long millis = date.getMillis();
        int offset = date.getZone().getOffset(millis);
        return Utility.serializeDate(millis + (long)offset);
    }

    public static String serializeZonedDateMidnight(DateMidnight date) {
        long millis = date.getMillis();
        int offset = date.getZone().getOffset(millis);
        StringBuffer buff = new StringBuffer(25);
        Utility.formatYearMonthDay(millis + (long)offset + 62135596800000L, buff);
        Utility.serializeOffset(offset, buff);
        return buff.toString();
    }

    public static String serializeUTCDateMidnight(DateMidnight date) {
        long millis = date.getMillis();
        int offset = date.getZone().getOffset(millis);
        StringBuffer buff = new StringBuffer(25);
        Utility.formatYearMonthDay(millis + (long)offset + 62135596800000L, buff);
        buff.append('Z');
        return buff.toString();
    }

    public static LocalTime deserializeLocalTime(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return new LocalTime(Utility.parseTimeNoOffset(text2, 0, text2.length()), DateTimeZone.UTC);
    }

    public static String serializeUnzonedLocalTime(LocalTime time) {
        StringBuffer buff = new StringBuffer(12);
        Utility.serializeTime(time.getMillisOfDay(), buff);
        return buff.toString();
    }

    public static String serializeUTCLocalTime(LocalTime time) {
        StringBuffer buff = new StringBuffer(13);
        Utility.serializeTime(time.getMillisOfDay(), buff);
        buff.append('Z');
        return buff.toString();
    }

    protected static DateTime parseDateTime(String text2, boolean full, DateTimeZone zone) throws JiBXException {
        int split2 = text2.indexOf(84);
        if (split2 < 0) {
            throw new JiBXException("Missing 'T' separator in dateTime");
        }
        int length = text2.length();
        long milli = Utility.parseDate(text2.substring(0, split2)) + Utility.parseTimeNoOffset(text2, split2 + 1, length);
        int start = split2 + 9;
        boolean utc = false;
        if (length > start) {
            char chr;
            utc = true;
            if (text2.charAt(length - 1) != 'Z' && ((chr = text2.charAt(length - 6)) == '-' || chr == '+')) {
                int hour = Utility.parseDigits(text2, length - 5, 2);
                int minute = Utility.parseDigits(text2, length - 2, 2);
                if (hour > 14 || minute > 59 || hour == 14 && minute != 0) {
                    throw new JiBXException("Invalid time zone offset: " + text2);
                }
                int offset = (hour * 60 + minute) * 60 * 1000;
                milli = chr == '-' ? (milli += (long)offset) : (milli -= (long)offset);
            }
        } else if (full) {
            throw new JiBXException("Missing required time zone offset: " + text2);
        }
        if (!utc) {
            milli -= (long)zone.getOffset(milli);
        }
        return new DateTime(milli, zone);
    }

    public static DateTime deserializeZonedDateTime(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        DateTimeZone zone = JodaConvert.findZone(text2, DateTimeZone.getDefault());
        return JodaConvert.parseDateTime(text2, false, zone);
    }

    public static DateTime deserializeUTCDateTime(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return new DateTime(Utility.parseDateTime(text2), DateTimeZone.UTC);
    }

    public static DateTime deserializeLocalDateTime(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return JodaConvert.parseDateTime(text2, false, DateTimeZone.getDefault());
    }

    public static DateTime deserializeStrictUTCDateTime(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return JodaConvert.parseDateTime(text2, true, DateTimeZone.UTC);
    }

    public static DateTime deserializeStrictLocalDateTime(String text2) throws JiBXException {
        if (text2 == null) {
            return null;
        }
        return JodaConvert.parseDateTime(text2, true, DateTimeZone.getDefault());
    }

    public static String serializeZonedDateTime(DateTime time) {
        int offset = time.getZone().getOffset(time.getMillis());
        long msec = time.getMillis() + (long)offset;
        StringBuffer buff = new StringBuffer(25);
        int extra = Utility.formatYearMonthDay(msec + 62135596800000L, buff);
        buff.append('T');
        Utility.serializeTime(extra, buff);
        Utility.serializeOffset(offset, buff);
        return buff.toString();
    }

    public static String serializeUTCDateTime(DateTime time) {
        return Utility.serializeDateTime(time.getMillis(), true);
    }
}

