/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.util.Arrays;
import java.util.Comparator;

public class EnumSet {
    public static final int VALUE_LIMIT = 512;
    private final EnumItem[] m_items;
    private final String[] m_indexedNames;
    private final String[] m_orderedNames;
    private final int[] m_orderedIndexes;

    public EnumSet(EnumItem[] items) {
        this.m_items = items;
        if (items.length > 0) {
            EnumItem item;
            int i;
            Arrays.sort(items, new Comparator(){

                public int compare(Object a, Object b) {
                    return ((EnumItem)a).m_name.compareTo(((EnumItem)b).m_name);
                }
            });
            this.m_orderedNames = new String[items.length];
            this.m_orderedIndexes = new int[items.length];
            int high = -1;
            for (i = 0; i < items.length; ++i) {
                item = items[i];
                if (item.m_value < 0) {
                    throw new IllegalArgumentException("Negative item value " + item.m_value + " not allowed");
                }
                if (item.m_value > high && (high = item.m_value) >= 512) {
                    throw new IllegalArgumentException("Enumeration with value " + high + " too large to be used.");
                }
                this.m_orderedNames[i] = item.m_name;
                this.m_orderedIndexes[i] = item.m_value;
            }
            this.m_indexedNames = new String[high + 1];
            for (i = 0; i < items.length; ++i) {
                item = items[i];
                if (this.m_indexedNames[item.m_value] != null) {
                    throw new IllegalArgumentException("Duplicate index value " + item.m_value);
                }
                this.m_indexedNames[item.m_value] = item.m_name;
            }
        } else {
            this.m_indexedNames = new String[0];
            this.m_orderedNames = new String[0];
            this.m_orderedIndexes = new int[0];
        }
    }

    public EnumSet(int start, String[] names) {
        this(EnumSet.buildItems(start, names));
    }

    public EnumSet(EnumSet base, int start, String[] names) {
        this(EnumSet.mergeItems(base, start, names));
    }

    private static EnumItem[] buildItems(int start, String[] names) {
        EnumItem[] items = new EnumItem[names.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new EnumItem(start + i, names[i]);
        }
        return items;
    }

    private static EnumItem[] mergeItems(EnumSet base, int start, String[] names) {
        int prior = base.m_items.length;
        EnumItem[] merges = new EnumItem[prior + names.length];
        System.arraycopy(base.m_items, 0, merges, 0, prior);
        for (int i = 0; i < names.length; ++i) {
            merges[prior + i] = new EnumItem(start + i, names[i]);
        }
        return merges;
    }

    public String getName(int value2) {
        if (value2 >= 0 && value2 < this.m_indexedNames.length) {
            return this.m_indexedNames[value2];
        }
        return null;
    }

    public String getNameChecked(int value2) {
        String name;
        if (value2 >= 0 && value2 < this.m_indexedNames.length && (name = this.m_indexedNames[value2]) != null) {
            return name;
        }
        throw new IllegalArgumentException("Value " + value2 + " not defined");
    }

    public int getValue(String name) {
        int base = 0;
        int limit = this.m_orderedNames.length - 1;
        while (base <= limit) {
            int cur = base + limit >> 1;
            int diff2 = name.compareTo(this.m_orderedNames[cur]);
            if (diff2 < 0) {
                limit = cur - 1;
                continue;
            }
            if (diff2 > 0) {
                base = cur + 1;
                continue;
            }
            if (this.m_orderedIndexes != null) {
                return this.m_orderedIndexes[cur];
            }
            return cur;
        }
        return -1;
    }

    public int getValueChecked(String name) {
        int index2 = this.getValue(name);
        if (index2 >= 0) {
            return index2;
        }
        throw new IllegalArgumentException("Name " + name + " not defined");
    }

    public void checkValue(int value2) {
        if (value2 < 0 || value2 >= this.m_indexedNames.length || this.m_indexedNames[value2] == null) {
            throw new IllegalArgumentException("Value " + value2 + " not defined");
        }
    }

    public int maxIndex() {
        return this.m_indexedNames.length - 1;
    }

    public static class EnumItem {
        public final int m_value;
        public final String m_name;

        public EnumItem(int value2, String name) {
            this.m_value = value2;
            this.m_name = name;
        }
    }
}

