/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.JiBXException;

public abstract class BindingDirectory {
    public static final String BINDINGLIST_NAME = "JiBX_bindingList";
    public static final String GENERATE_PREFIX = "JiBX_";
    public static final String BINDINGFACTORY_SUFFIX = "Factory";
    public static final String FACTORY_INSTMETHOD = "getInstance";
    public static final Class[] EMPTY_ARGS = new Class[0];

    private static String getBindingList(Class clas) throws JiBXException {
        try {
            Field field2 = clas.getDeclaredField(BINDINGLIST_NAME);
            try {
                field2.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (String)field2.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new JiBXException("Unable to access binding information for class " + clas.getName() + "\nMake sure the binding has been compiled", e);
        }
        catch (IllegalAccessException e) {
            throw new JiBXException("Error in added code for class " + clas.getName() + "Please report this to the JiBX developers", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IBindingFactory getFactoryFromName(String name, Class clas, ClassLoader loader) throws JiBXException {
        boolean incompat;
        Throwable throwable;
        block21: {
            throwable = null;
            Object result2 = null;
            IBindingFactory ifact = null;
            incompat = false;
            try {
                try {
                    Class<?> factory = loader.loadClass(name);
                    Method method = factory.getMethod(FACTORY_INSTMETHOD, EMPTY_ARGS);
                    result2 = method.invoke(null, (Object[])null);
                }
                catch (SecurityException e) {
                    SecurityException securityException = e;
                    Object var10_20 = null;
                    if (securityException != null) {
                        if (!incompat) throw new JiBXException("Unable to access binding information for class " + clas.getName() + "\nMake sure classes generated by the " + "binding compiler are available at runtime", securityException);
                        throw new JiBXException("Incompatible binding version for class " + clas.getName() + ", recompile binding with current JiBX distribution", securityException);
                    }
                    if (!(result2 instanceof IBindingFactory)) throw new JiBXException("Classloader conflict for binding factory '" + name + "' - factory does not implement required interface");
                    ifact = (IBindingFactory)result2;
                    int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                    if ((diff2 & 0xFFFF0000) != 0) {
                        throw new JiBXException("Binding information for class " + clas.getName() + " must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
                    }
                    ifact.verifyBaseBindings();
                    return ifact;
                }
                catch (ClassNotFoundException e) {
                    ClassNotFoundException classNotFoundException = e;
                    Object var10_21 = null;
                    if (classNotFoundException != null) {
                        if (!incompat) throw new JiBXException("Unable to access binding information for class " + clas.getName() + "\nMake sure classes generated by the " + "binding compiler are available at runtime", classNotFoundException);
                        throw new JiBXException("Incompatible binding version for class " + clas.getName() + ", recompile binding with current JiBX distribution", classNotFoundException);
                    }
                    if (!(result2 instanceof IBindingFactory)) throw new JiBXException("Classloader conflict for binding factory '" + name + "' - factory does not implement required interface");
                    ifact = (IBindingFactory)result2;
                    int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                    if ((diff2 & 0xFFFF0000) != 0) {
                        throw new JiBXException("Binding information for class " + clas.getName() + " must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
                    }
                    ifact.verifyBaseBindings();
                    return ifact;
                }
                catch (NoSuchMethodException e) {
                    NoSuchMethodException noSuchMethodException = e;
                    Object var10_22 = null;
                    if (noSuchMethodException != null) {
                        if (!incompat) throw new JiBXException("Unable to access binding information for class " + clas.getName() + "\nMake sure classes generated by the " + "binding compiler are available at runtime", noSuchMethodException);
                        throw new JiBXException("Incompatible binding version for class " + clas.getName() + ", recompile binding with current JiBX distribution", noSuchMethodException);
                    }
                    if (!(result2 instanceof IBindingFactory)) throw new JiBXException("Classloader conflict for binding factory '" + name + "' - factory does not implement required interface");
                    ifact = (IBindingFactory)result2;
                    int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                    if ((diff2 & 0xFFFF0000) != 0) {
                        throw new JiBXException("Binding information for class " + clas.getName() + " must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
                    }
                    ifact.verifyBaseBindings();
                    return ifact;
                }
                catch (IllegalAccessException e) {
                    IllegalAccessException illegalAccessException = e;
                    Object var10_23 = null;
                    if (illegalAccessException != null) {
                        if (!incompat) throw new JiBXException("Unable to access binding information for class " + clas.getName() + "\nMake sure classes generated by the " + "binding compiler are available at runtime", illegalAccessException);
                        throw new JiBXException("Incompatible binding version for class " + clas.getName() + ", recompile binding with current JiBX distribution", illegalAccessException);
                    }
                    if (!(result2 instanceof IBindingFactory)) throw new JiBXException("Classloader conflict for binding factory '" + name + "' - factory does not implement required interface");
                    ifact = (IBindingFactory)result2;
                    int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                    if ((diff2 & 0xFFFF0000) != 0) {
                        throw new JiBXException("Binding information for class " + clas.getName() + " must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
                    }
                    ifact.verifyBaseBindings();
                    return ifact;
                }
                catch (InvocationTargetException e) {
                    InvocationTargetException invocationTargetException = e;
                    incompat = true;
                    Object var10_24 = null;
                    if (invocationTargetException != null) {
                        if (!incompat) throw new JiBXException("Unable to access binding information for class " + clas.getName() + "\nMake sure classes generated by the " + "binding compiler are available at runtime", invocationTargetException);
                        throw new JiBXException("Incompatible binding version for class " + clas.getName() + ", recompile binding with current JiBX distribution", invocationTargetException);
                    }
                    if (!(result2 instanceof IBindingFactory)) throw new JiBXException("Classloader conflict for binding factory '" + name + "' - factory does not implement required interface");
                    ifact = (IBindingFactory)result2;
                    int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                    if ((diff2 & 0xFFFF0000) != 0) {
                        throw new JiBXException("Binding information for class " + clas.getName() + " must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
                    }
                    ifact.verifyBaseBindings();
                    return ifact;
                }
                Object var10_19 = null;
                if (throwable != null) break block21;
            }
            catch (Throwable throwable2) {
                Object var10_25 = null;
                if (throwable != null) {
                    if (!incompat) throw new JiBXException("Unable to access binding information for class " + clas.getName() + "\nMake sure classes generated by the " + "binding compiler are available at runtime", throwable);
                    throw new JiBXException("Incompatible binding version for class " + clas.getName() + ", recompile binding with current JiBX distribution", throwable);
                }
                if (!(result2 instanceof IBindingFactory)) throw new JiBXException("Classloader conflict for binding factory '" + name + "' - factory does not implement required interface");
                ifact = (IBindingFactory)result2;
                int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                if ((diff2 & 0xFFFF0000) != 0) {
                    throw new JiBXException("Binding information for class " + clas.getName() + " must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
                }
                ifact.verifyBaseBindings();
                throw throwable2;
            }
            if (!(result2 instanceof IBindingFactory)) throw new JiBXException("Classloader conflict for binding factory '" + name + "' - factory does not implement required interface");
            ifact = (IBindingFactory)result2;
            int diff2 = ifact.getCompilerVersion() ^ 0x30000;
            if ((diff2 & 0xFFFF0000) != 0) {
                throw new JiBXException("Binding information for class " + clas.getName() + " must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
            }
            ifact.verifyBaseBindings();
            return ifact;
        }
        if (!incompat) throw new JiBXException("Unable to access binding information for class " + clas.getName() + "\nMake sure classes generated by the " + "binding compiler are available at runtime", throwable);
        throw new JiBXException("Incompatible binding version for class " + clas.getName() + ", recompile binding with current JiBX distribution", throwable);
    }

    public static IBindingFactory getFactory(String name, Class clas, ClassLoader loader) throws JiBXException {
        String match;
        String list2 = BindingDirectory.getBindingList(clas);
        int index2 = list2.indexOf(match = GENERATE_PREFIX + BindingDirectory.convertName(name) + BINDINGFACTORY_SUFFIX + '|');
        if (index2 >= 0) {
            int mark = list2.lastIndexOf(124, index2);
            String fname = list2.substring(mark + 1, index2 + match.length() - 1);
            if ((mark = fname.indexOf(61)) >= 0) {
                fname = fname.substring(0, mark);
            }
            return BindingDirectory.getFactoryFromName(fname, clas, loader);
        }
        throw new JiBXException("Binding '" + name + "' not found for class " + clas.getName());
    }

    public static IBindingFactory getFactory(String name, Class clas) throws JiBXException {
        return BindingDirectory.getFactory(name, clas, clas.getClassLoader());
    }

    public static IBindingFactory getFactory(Class clas) throws JiBXException {
        String fact;
        String list2 = BindingDirectory.getBindingList(clas);
        if (list2 != null && list2.length() > 2 && (fact = list2.substring(1, list2.length() - 1)).indexOf(124) < 0) {
            return BindingDirectory.getFactoryFromName(fact, clas, clas.getClassLoader());
        }
        throw new JiBXException("Multiple bindings defined for class " + clas.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IBindingFactory getFactory(String bname, String pack, ClassLoader loader) throws JiBXException {
        String cname = (pack == null ? "" : pack + '.') + GENERATE_PREFIX + BindingDirectory.convertName(bname) + BINDINGFACTORY_SUFFIX;
        Throwable throwable = null;
        Object result2 = null;
        IBindingFactory ifact = null;
        try {
            try {
                Class<?> factory = loader.loadClass(cname);
                Method method = factory.getMethod(FACTORY_INSTMETHOD, EMPTY_ARGS);
                result2 = method.invoke(null, (Object[])null);
            }
            catch (SecurityException e) {
                SecurityException securityException = e;
                Object var10_20 = null;
                if (securityException != null) {
                    throw new JiBXException("Unable to access binding '" + bname + "'\nMake sure classes generated by the " + "binding compiler are available at runtime", securityException);
                }
                if (!(result2 instanceof IBindingFactory)) {
                    throw new JiBXException("Classloader conflict for binding '" + bname + "' - factory does not implement required interface");
                }
                ifact = (IBindingFactory)result2;
                int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                if ((diff2 & 0xFFFF0000) == 0) return ifact;
                throw new JiBXException("Binding '" + bname + "' must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
            }
            catch (ClassNotFoundException e) {
                ClassNotFoundException classNotFoundException = e;
                Object var10_21 = null;
                if (classNotFoundException != null) {
                    throw new JiBXException("Unable to access binding '" + bname + "'\nMake sure classes generated by the " + "binding compiler are available at runtime", classNotFoundException);
                }
                if (!(result2 instanceof IBindingFactory)) {
                    throw new JiBXException("Classloader conflict for binding '" + bname + "' - factory does not implement required interface");
                }
                ifact = (IBindingFactory)result2;
                int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                if ((diff2 & 0xFFFF0000) == 0) return ifact;
                throw new JiBXException("Binding '" + bname + "' must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
            }
            catch (NoSuchMethodException e) {
                NoSuchMethodException noSuchMethodException = e;
                Object var10_22 = null;
                if (noSuchMethodException != null) {
                    throw new JiBXException("Unable to access binding '" + bname + "'\nMake sure classes generated by the " + "binding compiler are available at runtime", noSuchMethodException);
                }
                if (!(result2 instanceof IBindingFactory)) {
                    throw new JiBXException("Classloader conflict for binding '" + bname + "' - factory does not implement required interface");
                }
                ifact = (IBindingFactory)result2;
                int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                if ((diff2 & 0xFFFF0000) == 0) return ifact;
                throw new JiBXException("Binding '" + bname + "' must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
            }
            catch (IllegalAccessException e) {
                IllegalAccessException illegalAccessException = e;
                Object var10_23 = null;
                if (illegalAccessException != null) {
                    throw new JiBXException("Unable to access binding '" + bname + "'\nMake sure classes generated by the " + "binding compiler are available at runtime", illegalAccessException);
                }
                if (!(result2 instanceof IBindingFactory)) {
                    throw new JiBXException("Classloader conflict for binding '" + bname + "' - factory does not implement required interface");
                }
                ifact = (IBindingFactory)result2;
                int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                if ((diff2 & 0xFFFF0000) == 0) return ifact;
                throw new JiBXException("Binding '" + bname + "' must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
            }
            catch (InvocationTargetException e) {
                InvocationTargetException invocationTargetException = e;
                Object var10_24 = null;
                if (invocationTargetException != null) {
                    throw new JiBXException("Unable to access binding '" + bname + "'\nMake sure classes generated by the " + "binding compiler are available at runtime", invocationTargetException);
                }
                if (!(result2 instanceof IBindingFactory)) {
                    throw new JiBXException("Classloader conflict for binding '" + bname + "' - factory does not implement required interface");
                }
                ifact = (IBindingFactory)result2;
                int diff2 = ifact.getCompilerVersion() ^ 0x30000;
                if ((diff2 & 0xFFFF0000) == 0) return ifact;
                throw new JiBXException("Binding '" + bname + "' must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
            }
            Object var10_19 = null;
            if (throwable != null) throw new JiBXException("Unable to access binding '" + bname + "'\nMake sure classes generated by the " + "binding compiler are available at runtime", throwable);
        }
        catch (Throwable throwable2) {
            Object var10_25 = null;
            if (throwable != null) {
                throw new JiBXException("Unable to access binding '" + bname + "'\nMake sure classes generated by the " + "binding compiler are available at runtime", throwable);
            }
            if (!(result2 instanceof IBindingFactory)) {
                throw new JiBXException("Classloader conflict for binding '" + bname + "' - factory does not implement required interface");
            }
            ifact = (IBindingFactory)result2;
            int diff2 = ifact.getCompilerVersion() ^ 0x30000;
            if ((diff2 & 0xFFFF0000) == 0) throw throwable2;
            throw new JiBXException("Binding '" + bname + "' must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
        }
        if (!(result2 instanceof IBindingFactory)) {
            throw new JiBXException("Classloader conflict for binding '" + bname + "' - factory does not implement required interface");
        }
        ifact = (IBindingFactory)result2;
        int diff2 = ifact.getCompilerVersion() ^ 0x30000;
        if ((diff2 & 0xFFFF0000) == 0) return ifact;
        throw new JiBXException("Binding '" + bname + "' must be recompiled with current binding " + "compiler (compiled with " + ifact.getCompilerDistribution() + ", runtime is " + "jibx_1_2_5_SNAPSHOT" + ")");
    }

    public static IBindingFactory getFactory(String bname, String pack) throws JiBXException {
        return BindingDirectory.getFactory(bname, pack, BindingDirectory.class.getClassLoader());
    }

    public static String convertName(String name) {
        StringBuffer buff = new StringBuffer(name);
        for (int i = 0; i < buff.length(); ++i) {
            if (Character.isJavaIdentifierPart(buff.charAt(i))) continue;
            buff.setCharAt(i, '_');
        }
        return buff.toString();
    }
}

