/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jibx.extras.DocumentModelMapperBase;
import org.jibx.runtime.JiBXException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomMapperBase
extends DocumentModelMapperBase {
    protected Document m_document;
    protected String m_defaultNamespaceURI;
    protected int m_defaultNamespaceIndex;

    protected DomMapperBase() throws JiBXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            this.m_document = dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new JiBXException("Unable to create DOM document", e);
        }
    }

    private int findNamespaceIndex(String prefix, String uri) {
        if ((prefix == null || "".equals(prefix)) && (uri == null || "".equals(uri))) {
            return 0;
        }
        if ("xml".equals(prefix) && "http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return 1;
        }
        if (prefix == null) {
            if (this.m_defaultNamespaceURI == null) {
                int index2 = this.m_xmlWriter.getPrefixIndex("");
                if (index2 >= 0) {
                    this.m_defaultNamespaceURI = this.getNamespaceUri(index2);
                    this.m_defaultNamespaceIndex = index2;
                    if (this.m_defaultNamespaceURI.equals(uri)) {
                        return index2;
                    }
                    return -1;
                }
                return -1;
            }
            return this.m_defaultNamespaceURI.equals(uri) ? this.m_defaultNamespaceIndex : -1;
        }
        int index3 = this.m_xmlWriter.getPrefixIndex(prefix);
        if (index3 >= 0) {
            return this.getNamespaceUri(index3).equals(uri) ? index3 : -1;
        }
        return -1;
    }

    protected void marshalNode(Node node) throws JiBXException, IOException {
        switch (node.getNodeType()) {
            case 4: {
                this.m_xmlWriter.writeCData(node.getNodeValue());
                break;
            }
            case 8: {
                this.m_xmlWriter.writeComment(node.getNodeValue());
                break;
            }
            case 1: {
                this.marshalElement((Element)node);
                break;
            }
            case 5: {
                this.m_xmlWriter.writeEntityRef(node.getNodeName());
                break;
            }
            case 7: {
                this.m_xmlWriter.writePI(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 3: {
                this.m_xmlWriter.writeTextContent(node.getNodeValue());
                break;
            }
        }
    }

    protected void marshalContent(NodeList content) throws JiBXException, IOException {
        int size2 = content.getLength();
        for (int i = 0; i < size2; ++i) {
            this.marshalNode(content.item(i));
        }
    }

    private void addNamespace(String prefix, String uri, ArrayList nss) {
        nss.add(prefix == null ? "" : prefix);
        nss.add(uri == null ? "" : uri);
    }

    private boolean isEquivalent(String a, String b) {
        return a.equals(b) || a.length() == 0 && b == null;
    }

    private void addNamespaceUnique(String prefix, String uri, ArrayList nss) {
        boolean found = false;
        for (int i = 0; i < nss.size(); i += 2) {
            if (!this.isEquivalent((String)nss.get(i), prefix) || !this.isEquivalent((String)nss.get(i + 1), uri)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addNamespace(prefix, uri, nss);
        }
    }

    protected void marshalElement(Element element) throws JiBXException, IOException {
        String uri;
        ArrayList nss = null;
        NamedNodeMap attrs = element.getAttributes();
        int size2 = attrs.getLength();
        for (int i = 0; i < size2; ++i) {
            String decluri;
            Attr attr = (Attr)attrs.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            String declpref = attr.getLocalName();
            if ("xmlns".equals(declpref)) {
                declpref = null;
            }
            if (this.findNamespaceIndex(declpref, decluri = attr.getValue()) >= 0) continue;
            if (nss == null) {
                nss = new ArrayList();
            }
            this.addNamespace(declpref, decluri, nss);
        }
        String prefix = element.getPrefix();
        int nsi = this.findNamespaceIndex(prefix, uri = element.getNamespaceURI());
        if (nsi < 0) {
            if (nss == null) {
                nss = new ArrayList();
            }
            this.addNamespaceUnique(prefix, uri, nss);
        }
        for (int i = 0; i < size2; ++i) {
            String attrpref;
            String attruri;
            Attr attr = (Attr)attrs.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || (attruri = attr.getNamespaceURI()) == null || this.findNamespaceIndex(attrpref = attr.getPrefix(), attruri) >= 0) continue;
            if (nss == null) {
                nss = new ArrayList();
            }
            this.addNamespaceUnique(attrpref, attruri, nss);
        }
        int defind = -1;
        String defuri = null;
        if (nss != null) {
            for (int i = 0; i < nss.size(); i += 2) {
                if (!"".equals(nss.get(i))) continue;
                defind = i / 2;
                defuri = (String)nss.get(i + 1);
            }
        }
        String[] uris = null;
        String name = element.getLocalName();
        if (name == null) {
            name = element.getTagName();
        }
        if (nss == null) {
            this.m_xmlWriter.startTagOpen(nsi, name);
        } else {
            int base = this.getNextNamespaceIndex();
            if (defind >= 0) {
                this.m_defaultNamespaceIndex = base + defind;
                this.m_defaultNamespaceURI = defuri;
            }
            int length = nss.size() / 2;
            uris = new String[length];
            int[] nums = new int[length];
            String[] prefs = new String[length];
            for (int i = 0; i < length; ++i) {
                prefs[i] = (String)nss.get(i * 2);
                uris[i] = (String)nss.get(i * 2 + 1);
                nums[i] = base + i;
                if (nsi >= 0 || !uri.equals(uris[i]) || (prefix != null || prefs[i] != "") && (prefix == null || !prefix.equals(prefs[i]))) continue;
                nsi = base + i;
            }
            this.m_xmlWriter.pushExtensionNamespaces(uris);
            this.m_xmlWriter.startTagNamespaces(nsi, name, nums, prefs);
            if (defind >= 0) {
                this.m_defaultNamespaceIndex = defind;
                this.m_defaultNamespaceURI = defuri;
            }
        }
        for (int i = 0; i < size2; ++i) {
            String aname;
            Attr attr = (Attr)attrs.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            int index2 = 0;
            String apref = attr.getPrefix();
            if (apref != null) {
                index2 = this.findNamespaceIndex(apref, attr.getNamespaceURI());
            }
            if ((aname = attr.getLocalName()) == null) {
                aname = attr.getName();
            }
            this.m_xmlWriter.addAttribute(index2, aname, attr.getValue());
        }
        NodeList nodes = element.getChildNodes();
        size2 = nodes.getLength();
        if (size2 > 0) {
            this.m_xmlWriter.closeStartTag();
            this.marshalContent(element.getChildNodes());
            this.m_xmlWriter.endTag(nsi, name);
        } else {
            this.m_xmlWriter.closeEmptyTag();
        }
        if (nss != null) {
            this.m_xmlWriter.popExtensionNamespaces();
            if (defind >= 0) {
                this.m_defaultNamespaceURI = null;
            }
        }
    }

    protected Node unmarshalNode() throws JiBXException, IOException {
        while (true) {
            int cev = this.m_unmarshalContext.currentEvent();
            switch (cev) {
                case 5: {
                    String text2 = this.m_unmarshalContext.getText();
                    this.m_unmarshalContext.nextToken();
                    return this.m_document.createCDATASection(text2);
                }
                case 9: {
                    String text3 = this.m_unmarshalContext.getText();
                    this.m_unmarshalContext.nextToken();
                    return this.m_document.createComment(text3);
                }
                case 3: {
                    return null;
                }
                case 6: {
                    if (this.m_unmarshalContext.getText() == null) {
                        String name = this.m_unmarshalContext.getName();
                        this.m_unmarshalContext.nextToken();
                        return this.m_document.createEntityReference(name);
                    }
                    String text4 = this.accumulateText();
                    return this.m_document.createTextNode(text4);
                }
                case 8: {
                    String text5 = this.m_unmarshalContext.getText();
                    this.m_unmarshalContext.nextToken();
                    int index2 = 0;
                    while (++index2 < text5.length() && !this.isWhitespace(text5.charAt(index2))) {
                    }
                    if (index2 < text5.length()) {
                        String target = text5.substring(0, index2);
                        while (++index2 < text5.length() && this.isWhitespace(text5.charAt(index2))) {
                        }
                        String data2 = text5.substring(index2);
                        return this.m_document.createProcessingInstruction(target, data2);
                    }
                    return this.m_document.createProcessingInstruction(text5, "");
                }
                case 2: {
                    return this.unmarshalElement();
                }
                case 4: {
                    return this.m_document.createTextNode(this.accumulateText());
                }
            }
            this.m_unmarshalContext.nextToken();
        }
    }

    protected void unmarshalContent(Node parent) throws JiBXException, IOException {
        Node node;
        while ((node = this.unmarshalNode()) != null) {
            parent.appendChild(node);
        }
    }

    protected Element unmarshalElement() throws JiBXException, IOException {
        String uri = this.m_unmarshalContext.getNamespace();
        String prefix = this.m_unmarshalContext.getPrefix();
        String name = this.m_unmarshalContext.getName();
        if (prefix != null) {
            name = prefix + ':' + name;
        }
        Element element = this.m_document.createElementNS(uri, name);
        int ncount = this.m_unmarshalContext.getNamespaceCount();
        for (int i = 0; i < ncount; ++i) {
            prefix = this.m_unmarshalContext.getNamespacePrefix(i);
            uri = this.m_unmarshalContext.getNamespaceUri(i);
            if (prefix == null) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", uri);
                continue;
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
        int acount = this.m_unmarshalContext.getAttributeCount();
        for (int i = 0; i < acount; ++i) {
            prefix = this.m_unmarshalContext.getAttributePrefix(i);
            uri = this.m_unmarshalContext.getAttributeNamespace(i);
            name = this.m_unmarshalContext.getAttributeName(i);
            if (prefix != null) {
                name = prefix + ':' + name;
            }
            String value2 = this.m_unmarshalContext.getAttributeValue(i);
            element.setAttributeNS(uri, name, value2);
        }
        int event = this.m_unmarshalContext.nextToken();
        if (event != 3) {
            this.unmarshalContent(element);
        }
        this.m_unmarshalContext.nextToken();
        return element;
    }
}

