/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.serialization;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class CompatibleObjectEncoder
extends OneToOneEncoder {
    private final AtomicReference<ChannelBuffer> buffer = new AtomicReference();
    private final int resetInterval;
    private volatile ObjectOutputStream oout;
    private int writtenObjects;

    public CompatibleObjectEncoder() {
        this(16);
    }

    public CompatibleObjectEncoder(int resetInterval) {
        if (resetInterval < 0) {
            throw new IllegalArgumentException("resetInterval: " + resetInterval);
        }
        this.resetInterval = resetInterval;
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws Exception {
        return new ObjectOutputStream(out);
    }

    protected Object encode(ChannelHandlerContext context, Channel channel, Object msg) throws Exception {
        ChannelBuffer buffer = this.buffer(context);
        ObjectOutputStream oout = this.oout;
        if (this.resetInterval != 0) {
            ++this.writtenObjects;
            if (this.writtenObjects % this.resetInterval == 0) {
                oout.reset();
                buffer.discardReadBytes();
            }
        }
        oout.writeObject(msg);
        oout.flush();
        ChannelBuffer encoded = buffer.readBytes(buffer.readableBytes());
        return encoded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelBuffer buffer(ChannelHandlerContext ctx) throws Exception {
        ChannelBuffer buf = this.buffer.get();
        if (buf == null) {
            ChannelBufferFactory factory = ctx.getChannel().getConfig().getBufferFactory();
            buf = ChannelBuffers.dynamicBuffer(factory);
            if (this.buffer.compareAndSet(null, buf)) {
                boolean success2 = false;
                try {
                    this.oout = this.newObjectOutputStream(new ChannelBufferOutputStream(buf));
                    success2 = true;
                }
                finally {
                    if (!success2) {
                        this.oout = null;
                    }
                }
            } else {
                buf = this.buffer.get();
            }
        }
        return buf;
    }
}

