/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.Queue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.embedder.EncoderEmbedder;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.util.internal.LinkedTransferQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpContentEncoder
extends SimpleChannelHandler {
    private final Queue<String> acceptEncodingQueue = new LinkedTransferQueue<String>();
    private volatile EncoderEmbedder<ChannelBuffer> encoder;

    protected HttpContentEncoder() {
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (!(msg instanceof HttpMessage)) {
            ctx.sendUpstream(e);
            return;
        }
        HttpMessage m = (HttpMessage)msg;
        String acceptedEncoding = m.getHeader("Accept-Encoding");
        if (acceptedEncoding == null) {
            acceptedEncoding = "identity";
        }
        boolean offered = this.acceptEncodingQueue.offer(acceptedEncoding);
        assert (offered);
        ctx.sendUpstream(e);
    }

    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpMessage) {
            HttpMessage m = (HttpMessage)msg;
            this.encoder = null;
            String acceptEncoding = this.acceptEncodingQueue.poll();
            if (acceptEncoding == null) {
                throw new IllegalStateException("cannot send more responses than requests");
            }
            this.encoder = this.newContentEncoder(acceptEncoding);
            if (this.encoder != null) {
                m.setHeader("Content-Encoding", this.getTargetContentEncoding(acceptEncoding));
                if (!m.isChunked()) {
                    ChannelBuffer content = m.getContent();
                    content = ChannelBuffers.wrappedBuffer(this.encode(content), this.finishEncode());
                    m.setContent(content);
                    if (m.containsHeader("Content-Length")) {
                        m.setHeader("Content-Length", Integer.toString(content.readableBytes()));
                    }
                }
            }
            ctx.sendDownstream(e);
        } else if (msg instanceof HttpChunk) {
            HttpChunk c = (HttpChunk)msg;
            ChannelBuffer content = c.getContent();
            if (this.encoder != null) {
                if (!c.isLast()) {
                    if ((content = this.encode(content)).readable()) {
                        c.setContent(content);
                        ctx.sendDownstream(e);
                    }
                } else {
                    ChannelBuffer lastProduct = this.finishEncode();
                    if (lastProduct.readable()) {
                        Channels.write(ctx, Channels.succeededFuture(e.getChannel()), new DefaultHttpChunk(lastProduct), e.getRemoteAddress());
                    }
                    ctx.sendDownstream(e);
                }
            } else {
                ctx.sendDownstream(e);
            }
        } else {
            ctx.sendDownstream(e);
        }
    }

    protected abstract EncoderEmbedder<ChannelBuffer> newContentEncoder(String var1) throws Exception;

    protected abstract String getTargetContentEncoding(String var1) throws Exception;

    private ChannelBuffer encode(ChannelBuffer buf) {
        this.encoder.offer(buf);
        return ChannelBuffers.wrappedBuffer(this.encoder.pollAll(new ChannelBuffer[this.encoder.size()]));
    }

    private ChannelBuffer finishEncode() {
        ChannelBuffer result2 = this.encoder.finish() ? ChannelBuffers.wrappedBuffer(this.encoder.pollAll(new ChannelBuffer[this.encoder.size()])) : ChannelBuffers.EMPTY_BUFFER;
        this.encoder = null;
        return result2;
    }
}

