/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.SystemPropertyUtil;

class NioProviderMetadata {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioProviderMetadata.class);
    private static final String CONSTRAINT_LEVEL_PROPERTY = "org.jboss.netty.channel.socket.nio.constraintLevel";
    private static final String OLD_CONSTRAINT_LEVEL_PROPERTY = "java.nio.channels.spi.constraintLevel";
    static final int CONSTRAINT_LEVEL;

    private static int detectConstraintLevelFromSystemProperties() {
        String provider;
        String version = SystemPropertyUtil.get("java.specification.version");
        String vminfo = SystemPropertyUtil.get("java.vm.info", "");
        String os = SystemPropertyUtil.get("os.name");
        String vendor = SystemPropertyUtil.get("java.vm.vendor");
        try {
            provider = SelectorProvider.provider().getClass().getName();
        }
        catch (Exception e) {
            provider = null;
        }
        if (version == null || os == null || vendor == null || provider == null) {
            return -1;
        }
        os = os.toLowerCase();
        if ((vendor = vendor.toLowerCase()).indexOf("sun") >= 0) {
            if (os.indexOf("linux") >= 0 ? provider.equals("sun.nio.ch.EPollSelectorProvider") || provider.equals("sun.nio.ch.PollSelectorProvider") : (os.indexOf("windows") >= 0 ? provider.equals("sun.nio.ch.WindowsSelectorProvider") : (os.indexOf("sun") >= 0 || os.indexOf("solaris") >= 0) && provider.equals("sun.nio.ch.DevPollSelectorProvider"))) {
                return 0;
            }
        } else if (vendor.indexOf("apple") >= 0) {
            if (os.indexOf("mac") >= 0 && os.indexOf("os") >= 0 && provider.equals("sun.nio.ch.KQueueSelectorProvider")) {
                return 0;
            }
        } else if (vendor.indexOf("ibm") >= 0) {
            if (os.indexOf("linux") >= 0 || os.indexOf("aix") >= 0) {
                Pattern datePattern;
                Matcher dateMatcher;
                if (version.equals("1.5") || version.matches("^1\\.5\\D.*$")) {
                    if (provider.equals("sun.nio.ch.PollSelectorProvider")) {
                        return 1;
                    }
                } else if ((version.equals("1.6") || version.matches("^1\\.6\\D.*$")) && (dateMatcher = (datePattern = Pattern.compile("(?:^|[^0-9])([2-9][0-9]{3}(?:0[1-9]|1[0-2])(?:0[1-9]|[12][0-9]|3[01]))(?:$|[^0-9])")).matcher(vminfo)).find()) {
                    long dateValue = Long.parseLong(dateMatcher.group(1));
                    if (dateValue < 20081105L) {
                        return 2;
                    }
                    if (provider.equals("sun.nio.ch.EPollSelectorProvider")) {
                        return 0;
                    }
                    if (provider.equals("sun.nio.ch.PollSelectorProvider")) {
                        return 1;
                    }
                }
            }
        } else if (vendor.indexOf("bea") >= 0 || vendor.indexOf("oracle") >= 0) {
            if (os.indexOf("linux") >= 0 ? provider.equals("sun.nio.ch.EPollSelectorProvider") || provider.equals("sun.nio.ch.PollSelectorProvider") : os.indexOf("windows") >= 0 && provider.equals("sun.nio.ch.WindowsSelectorProvider")) {
                return 0;
            }
        } else if (vendor.indexOf("apache") >= 0 && provider.equals("org.apache.harmony.nio.internal.SelectorProviderImpl")) {
            return 1;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            System.out.println(e.getKey() + ": " + e.getValue());
        }
        System.out.println();
        System.out.println("Hard-coded Constraint Level: " + CONSTRAINT_LEVEL);
        System.out.println("Auto-detected Constraint Level: " + new ConstraintLevelAutodetector().autodetect());
    }

    private NioProviderMetadata() {
    }

    static {
        int constraintLevel = -1;
        constraintLevel = SystemPropertyUtil.get(CONSTRAINT_LEVEL_PROPERTY, -1);
        if (constraintLevel < 0 || constraintLevel > 2) {
            constraintLevel = SystemPropertyUtil.get(OLD_CONSTRAINT_LEVEL_PROPERTY, -1);
            if (constraintLevel < 0 || constraintLevel > 2) {
                constraintLevel = -1;
            } else {
                logger.warn("System property 'java.nio.channels.spi.constraintLevel' has been deprecated.  Use 'org.jboss.netty.channel.socket.nio.constraintLevel' instead.");
            }
        }
        if (constraintLevel >= 0) {
            logger.debug("Setting the NIO constraint level to: " + constraintLevel);
        }
        if (constraintLevel < 0) {
            constraintLevel = NioProviderMetadata.detectConstraintLevelFromSystemProperties();
            if (constraintLevel < 0) {
                constraintLevel = 2;
                logger.debug("Couldn't determine the NIO constraint level from the system properties; using the safest level (2)");
            } else if (constraintLevel != 0) {
                logger.info("Using the autodetected NIO constraint level: " + constraintLevel + " (Use better NIO provider for better performance)");
            } else {
                logger.debug("Using the autodetected NIO constraint level: " + constraintLevel);
            }
        }
        if ((CONSTRAINT_LEVEL = constraintLevel) < 0 || CONSTRAINT_LEVEL > 2) {
            throw new Error("Unexpected NIO constraint level: " + CONSTRAINT_LEVEL + ", please report this error.");
        }
    }

    private static final class SelectorLoop
    implements Runnable {
        final Selector selector = Selector.open();
        volatile boolean done;
        volatile boolean selecting;

        SelectorLoop() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.done) {
                SelectorLoop selectorLoop = this;
                synchronized (selectorLoop) {
                }
                try {
                    Object var4_7;
                    this.selecting = true;
                    try {
                        this.selector.select(1000L);
                        var4_7 = null;
                        this.selecting = false;
                    }
                    catch (Throwable throwable) {
                        var4_7 = null;
                        this.selecting = false;
                        throw throwable;
                    }
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    for (SelectionKey k : keys) {
                        k.interestOps(0);
                    }
                    keys.clear();
                }
                catch (IOException e) {
                    logger.warn("Failed to wait for a temporary selector.", e);
                }
            }
        }
    }

    private static final class ConstraintLevelAutodetector {
        ConstraintLevelAutodetector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        int autodetect() {
            int constraintLevel;
            block101: {
                Throwable e3222222222;
                SelectorLoop loop2;
                ServerSocketChannel ch;
                ExecutorService executor;
                block93: {
                    block92: {
                        long startTime;
                        int i;
                        executor = Executors.newCachedThreadPool();
                        ch = null;
                        loop2 = null;
                        ch = ServerSocketChannel.open();
                        try {
                            ch.socket().bind(new InetSocketAddress(0));
                            ch.configureBlocking(false);
                        }
                        catch (Throwable e2) {
                            Throwable e3222222222;
                            logger.warn("Failed to configure a temporary socket.", e2);
                            int n = -1;
                            Object var14_14 = null;
                            if (ch != null) {
                                try {
                                    ch.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary socket.", e3222222222);
                                }
                            }
                            if (loop2 != null) {
                                loop2.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop2.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e3222222222) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e3222222222) {
                                    // empty catch block
                                }
                                try {
                                    loop2.selector.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary selector.", e3222222222);
                                }
                            }
                            return n;
                        }
                        try {
                            loop2 = new SelectorLoop();
                        }
                        catch (Throwable e4) {
                            Throwable e3222222222;
                            logger.warn("Failed to open a temporary selector.", e4);
                            int n = -1;
                            Object var14_15 = null;
                            if (ch != null) {
                                try {
                                    ch.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary socket.", e3222222222);
                                }
                            }
                            if (loop2 != null) {
                                loop2.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop2.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e3222222222) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e3222222222) {
                                    // empty catch block
                                }
                                try {
                                    loop2.selector.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary selector.", e3222222222);
                                }
                            }
                            return n;
                        }
                        try {
                            ch.register(loop2.selector, 0);
                        }
                        catch (Throwable e5) {
                            Throwable e3222222222;
                            logger.warn("Failed to register a temporary selector.", e5);
                            int n = -1;
                            Object var14_16 = null;
                            if (ch != null) {
                                try {
                                    ch.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary socket.", e3222222222);
                                }
                            }
                            if (loop2 != null) {
                                loop2.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop2.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e3222222222) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e3222222222) {
                                    // empty catch block
                                }
                                try {
                                    loop2.selector.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary selector.", e3222222222);
                                }
                            }
                            return n;
                        }
                        SelectionKey key = ch.keyFor(loop2.selector);
                        executor.execute(loop2);
                        boolean success2 = true;
                        for (i = 0; i < 10; ++i) {
                            while (true) {
                                if (!loop2.selecting) {
                                    Thread.yield();
                                    continue;
                                }
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException e6) {
                                    // empty catch block
                                }
                                if (loop2.selecting) break;
                            }
                            startTime = System.nanoTime();
                            key.interestOps(key.interestOps() | 0x10);
                            key.interestOps(key.interestOps() & 0xFFFFFFEF);
                            if (System.nanoTime() - startTime < 500000000L) continue;
                            success2 = false;
                            break;
                        }
                        if (success2) {
                            constraintLevel = 0;
                            break block92;
                        }
                        success2 = true;
                        for (i = 0; i < 10; ++i) {
                            while (true) {
                                if (!loop2.selecting) {
                                    Thread.yield();
                                    continue;
                                }
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException e7) {
                                    // empty catch block
                                }
                                if (loop2.selecting) break;
                            }
                            startTime = System.nanoTime();
                            int interestOps = key.interestOps();
                            SelectorLoop selectorLoop = loop2;
                            synchronized (selectorLoop) {
                                loop2.selector.wakeup();
                                key.interestOps(interestOps | 0x10);
                                key.interestOps(interestOps & 0xFFFFFFEF);
                            }
                            if (System.nanoTime() - startTime < 500000000L) continue;
                            success2 = false;
                            break;
                        }
                        if (success2) {
                            constraintLevel = 1;
                            break block92;
                        }
                        constraintLevel = 2;
                    }
                    Object var14_17 = null;
                    if (ch == null) break block93;
                    try {
                        ch.close();
                    }
                    catch (Throwable e3222222222) {
                        logger.warn("Failed to close a temporary socket.", e3222222222);
                    }
                }
                if (loop2 != null) {
                    loop2.done = true;
                    try {
                        executor.shutdownNow();
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                    try {
                        while (true) {
                            loop2.selector.wakeup();
                            try {
                                if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                            }
                            catch (InterruptedException e3222222222) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable e3222222222) {
                        // empty catch block
                    }
                    try {
                        loop2.selector.close();
                    }
                    catch (Throwable e3222222222) {
                        logger.warn("Failed to close a temporary selector.", e3222222222);
                    }
                }
                break block101;
                {
                    catch (Throwable e8) {
                        Throwable e3222222222;
                        int n = -1;
                        Object var14_18 = null;
                        if (ch != null) {
                            try {
                                ch.close();
                            }
                            catch (Throwable e3222222222) {
                                logger.warn("Failed to close a temporary socket.", e3222222222);
                            }
                        }
                        if (loop2 != null) {
                            loop2.done = true;
                            try {
                                executor.shutdownNow();
                            }
                            catch (NullPointerException ex) {
                                // empty catch block
                            }
                            try {
                                while (true) {
                                    loop2.selector.wakeup();
                                    try {
                                        if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                    }
                                    catch (InterruptedException e3222222222) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable e3222222222) {
                                // empty catch block
                            }
                            try {
                                loop2.selector.close();
                            }
                            catch (Throwable e3222222222) {
                                logger.warn("Failed to close a temporary selector.", e3222222222);
                            }
                        }
                        return n;
                    }
                }
                catch (Throwable throwable) {
                    Throwable e3222222222;
                    Object var14_19 = null;
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable e3222222222) {
                            logger.warn("Failed to close a temporary socket.", e3222222222);
                        }
                    }
                    if (loop2 != null) {
                        loop2.done = true;
                        try {
                            executor.shutdownNow();
                        }
                        catch (NullPointerException ex) {
                            // empty catch block
                        }
                        try {
                            while (true) {
                                loop2.selector.wakeup();
                                try {
                                    if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                }
                                catch (InterruptedException e3222222222) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable e3222222222) {
                            // empty catch block
                        }
                        try {
                            loop2.selector.close();
                        }
                        catch (Throwable e3222222222) {
                            logger.warn("Failed to close a temporary selector.", e3222222222);
                        }
                    }
                    throw throwable;
                }
            }
            return constraintLevel;
        }
    }
}

