/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.netty.buffer.AbstractChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.HeapChannelBufferFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeChannelBuffer
extends AbstractChannelBuffer {
    private final ByteOrder order;
    private ChannelBuffer[] components;
    private int[] indices;
    private int lastAccessedComponentId;

    public CompositeChannelBuffer(ByteOrder endianness, List<ChannelBuffer> buffers) {
        this.order = endianness;
        this.setComponents(buffers);
    }

    public List<ChannelBuffer> decompose(int index2, int length) {
        int readableBytes;
        if (length == 0) {
            return Collections.emptyList();
        }
        if (index2 + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        int componentId = this.componentId(index2);
        ArrayList<ChannelBuffer> slice2 = new ArrayList<ChannelBuffer>(this.components.length);
        ChannelBuffer first = this.components[componentId].duplicate();
        first.readerIndex(index2 - this.indices[componentId]);
        ChannelBuffer buf = first;
        int bytesToSlice = length;
        do {
            if (bytesToSlice <= (readableBytes = buf.readableBytes())) {
                buf.writerIndex(buf.readerIndex() + bytesToSlice);
                slice2.add(buf);
                break;
            }
            slice2.add(buf);
            buf = this.components[++componentId].duplicate();
        } while ((bytesToSlice -= readableBytes) > 0);
        for (int i = 0; i < slice2.size(); ++i) {
            slice2.set(i, ((ChannelBuffer)slice2.get(i)).slice());
        }
        return slice2;
    }

    private void setComponents(List<ChannelBuffer> newComponents) {
        int i;
        assert (!newComponents.isEmpty());
        this.lastAccessedComponentId = 0;
        this.components = new ChannelBuffer[newComponents.size()];
        for (i = 0; i < this.components.length; ++i) {
            ChannelBuffer c = newComponents.get(i);
            if (c.order() != this.order()) {
                throw new IllegalArgumentException("All buffers must have the same endianness.");
            }
            assert (c.readerIndex() == 0);
            assert (c.writerIndex() == c.capacity());
            this.components[i] = c;
        }
        this.indices = new int[this.components.length + 1];
        this.indices[0] = 0;
        for (i = 1; i <= this.components.length; ++i) {
            this.indices[i] = this.indices[i - 1] + this.components[i - 1].capacity();
        }
        this.setIndex(0, this.capacity());
    }

    private CompositeChannelBuffer(CompositeChannelBuffer buffer) {
        this.order = buffer.order;
        this.components = (ChannelBuffer[])buffer.components.clone();
        this.indices = (int[])buffer.indices.clone();
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    @Override
    public ChannelBufferFactory factory() {
        return HeapChannelBufferFactory.getInstance(this.order());
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int capacity() {
        return this.indices[this.components.length];
    }

    @Override
    public byte getByte(int index2) {
        int componentId = this.componentId(index2);
        return this.components[componentId].getByte(index2 - this.indices[componentId]);
    }

    @Override
    public short getShort(int index2) {
        int componentId = this.componentId(index2);
        if (index2 + 2 <= this.indices[componentId + 1]) {
            return this.components[componentId].getShort(index2 - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this.getByte(index2) & 0xFF) << 8 | this.getByte(index2 + 1) & 0xFF);
        }
        return (short)(this.getByte(index2) & 0xFF | (this.getByte(index2 + 1) & 0xFF) << 8);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        int componentId = this.componentId(index2);
        if (index2 + 3 <= this.indices[componentId + 1]) {
            return this.components[componentId].getUnsignedMedium(index2 - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index2) & 0xFFFF) << 8 | this.getByte(index2 + 2) & 0xFF;
        }
        return this.getShort(index2) & 0xFFFF | (this.getByte(index2 + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int index2) {
        int componentId = this.componentId(index2);
        if (index2 + 4 <= this.indices[componentId + 1]) {
            return this.components[componentId].getInt(index2 - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index2) & 0xFFFF) << 16 | this.getShort(index2 + 2) & 0xFFFF;
        }
        return this.getShort(index2) & 0xFFFF | (this.getShort(index2 + 2) & 0xFFFF) << 16;
    }

    @Override
    public long getLong(int index2) {
        int componentId = this.componentId(index2);
        if (index2 + 8 <= this.indices[componentId + 1]) {
            return this.components[componentId].getLong(index2 - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this.getInt(index2) & 0xFFFFFFFFL) << 32 | (long)this.getInt(index2 + 4) & 0xFFFFFFFFL;
        }
        return (long)this.getInt(index2) & 0xFFFFFFFFL | ((long)this.getInt(index2 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    public void getBytes(int index2, byte[] dst, int dstIndex, int length) {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length || dstIndex > dst.length - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = componentId;
        while (length > 0) {
            ChannelBuffer s2 = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s2.capacity() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBytes(int index2, ByteBuffer dst) {
        int componentId = this.componentId(index2);
        int limit = dst.limit();
        int length = dst.remaining();
        if (index2 > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = componentId;
        try {
            while (length > 0) {
                ChannelBuffer s2 = this.components[i];
                int adjustment = this.indices[i];
                int localLength = Math.min(length, s2.capacity() - (index2 - adjustment));
                dst.limit(dst.position() + localLength);
                s2.getBytes(index2 - adjustment, dst);
                index2 += localLength;
                length -= localLength;
                ++i;
            }
        }
        finally {
            dst.limit(limit);
        }
    }

    @Override
    public void getBytes(int index2, ChannelBuffer dst, int dstIndex, int length) {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length || dstIndex > dst.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = componentId;
        while (length > 0) {
            ChannelBuffer s2 = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s2.capacity() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        return out.write(this.toByteBuffer(index2, length));
    }

    @Override
    public void getBytes(int index2, OutputStream out, int length) throws IOException {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = componentId;
        while (length > 0) {
            ChannelBuffer s2 = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s2.capacity() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, out, localLength);
            index2 += localLength;
            length -= localLength;
            ++i;
        }
    }

    @Override
    public void setByte(int index2, int value2) {
        int componentId = this.componentId(index2);
        this.components[componentId].setByte(index2 - this.indices[componentId], value2);
    }

    @Override
    public void setShort(int index2, int value2) {
        int componentId = this.componentId(index2);
        if (index2 + 2 <= this.indices[componentId + 1]) {
            this.components[componentId].setShort(index2 - this.indices[componentId], value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setByte(index2, (byte)(value2 >>> 8));
            this.setByte(index2 + 1, (byte)value2);
        } else {
            this.setByte(index2, (byte)value2);
            this.setByte(index2 + 1, (byte)(value2 >>> 8));
        }
    }

    @Override
    public void setMedium(int index2, int value2) {
        int componentId = this.componentId(index2);
        if (index2 + 3 <= this.indices[componentId + 1]) {
            this.components[componentId].setMedium(index2 - this.indices[componentId], value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index2, (short)(value2 >> 8));
            this.setByte(index2 + 2, (byte)value2);
        } else {
            this.setShort(index2, (short)value2);
            this.setByte(index2 + 2, (byte)(value2 >>> 16));
        }
    }

    @Override
    public void setInt(int index2, int value2) {
        int componentId = this.componentId(index2);
        if (index2 + 4 <= this.indices[componentId + 1]) {
            this.components[componentId].setInt(index2 - this.indices[componentId], value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index2, (short)(value2 >>> 16));
            this.setShort(index2 + 2, (short)value2);
        } else {
            this.setShort(index2, (short)value2);
            this.setShort(index2 + 2, (short)(value2 >>> 16));
        }
    }

    @Override
    public void setLong(int index2, long value2) {
        int componentId = this.componentId(index2);
        if (index2 + 8 <= this.indices[componentId + 1]) {
            this.components[componentId].setLong(index2 - this.indices[componentId], value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setInt(index2, (int)(value2 >>> 32));
            this.setInt(index2 + 4, (int)value2);
        } else {
            this.setInt(index2, (int)value2);
            this.setInt(index2 + 4, (int)(value2 >>> 32));
        }
    }

    @Override
    public void setBytes(int index2, byte[] src, int srcIndex, int length) {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length || srcIndex > src.length - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = componentId;
        while (length > 0) {
            ChannelBuffer s2 = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s2.capacity() - (index2 - adjustment));
            s2.setBytes(index2 - adjustment, src, srcIndex, localLength);
            index2 += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int index2, ByteBuffer src) {
        int componentId = this.componentId(index2);
        int limit = src.limit();
        int length = src.remaining();
        if (index2 > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = componentId;
        try {
            while (length > 0) {
                ChannelBuffer s2 = this.components[i];
                int adjustment = this.indices[i];
                int localLength = Math.min(length, s2.capacity() - (index2 - adjustment));
                src.limit(src.position() + localLength);
                s2.setBytes(index2 - adjustment, src);
                index2 += localLength;
                length -= localLength;
                ++i;
            }
        }
        finally {
            src.limit(limit);
        }
    }

    @Override
    public void setBytes(int index2, ChannelBuffer src, int srcIndex, int length) {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length || srcIndex > src.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = componentId;
        while (length > 0) {
            ChannelBuffer s2 = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s2.capacity() - (index2 - adjustment));
            s2.setBytes(index2 - adjustment, src, srcIndex, localLength);
            index2 += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = componentId;
        int readBytes = 0;
        do {
            int localLength;
            int adjustment;
            ChannelBuffer s2;
            int localReadBytes;
            if ((localReadBytes = (s2 = this.components[i]).setBytes(index2 - (adjustment = this.indices[i]), in, localLength = Math.min(length, s2.capacity() - (index2 - adjustment)))) < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            if (localReadBytes == localLength) {
                index2 += localLength;
                length -= localLength;
                readBytes += localLength;
                ++i;
                continue;
            }
            index2 += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
        } while (length > 0);
        return readBytes;
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = componentId;
        int readBytes = 0;
        do {
            int localLength;
            int adjustment;
            ChannelBuffer s2;
            int localReadBytes;
            if ((localReadBytes = (s2 = this.components[i]).setBytes(index2 - (adjustment = this.indices[i]), in, localLength = Math.min(length, s2.capacity() - (index2 - adjustment)))) == localLength) {
                index2 += localLength;
                length -= localLength;
                readBytes += localLength;
                ++i;
                continue;
            }
            index2 += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
        } while (length > 0);
        return readBytes;
    }

    @Override
    public ChannelBuffer duplicate() {
        CompositeChannelBuffer duplicate = new CompositeChannelBuffer(this);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    @Override
    public ChannelBuffer copy(int index2, int length) {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        ChannelBuffer dst = this.factory().getBuffer(this.order(), length);
        this.copyTo(index2, length, componentId, dst);
        return dst;
    }

    private void copyTo(int index2, int length, int componentId, ChannelBuffer dst) {
        int dstIndex = 0;
        int i = componentId;
        while (length > 0) {
            ChannelBuffer s2 = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s2.capacity() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
        dst.writerIndex(dst.capacity());
    }

    @Override
    public ChannelBuffer slice(int index2, int length) {
        if (index2 == 0) {
            if (length == 0) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
        } else {
            if (index2 < 0 || index2 > this.capacity() - length) {
                throw new IndexOutOfBoundsException();
            }
            if (length == 0) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
        }
        List<ChannelBuffer> components = this.decompose(index2, length);
        switch (components.size()) {
            case 0: {
                return ChannelBuffers.EMPTY_BUFFER;
            }
            case 1: {
                return components.get(0);
            }
        }
        return new CompositeChannelBuffer(this.order(), components);
    }

    @Override
    public ByteBuffer toByteBuffer(int index2, int length) {
        if (this.components.length == 1) {
            return this.components[0].toByteBuffer(index2, length);
        }
        ByteBuffer[] buffers = this.toByteBuffers(index2, length);
        ByteBuffer merged = ByteBuffer.allocate(length).order(this.order());
        for (ByteBuffer b : buffers) {
            merged.put(b);
        }
        merged.flip();
        return merged;
    }

    @Override
    public ByteBuffer[] toByteBuffers(int index2, int length) {
        int componentId = this.componentId(index2);
        if (index2 + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.components.length);
        int i = componentId;
        while (length > 0) {
            ChannelBuffer s2 = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s2.capacity() - (index2 - adjustment));
            buffers.add(s2.toByteBuffer(index2 - adjustment, localLength));
            index2 += localLength;
            length -= localLength;
            ++i;
        }
        return buffers.toArray(new ByteBuffer[buffers.size()]);
    }

    private int componentId(int index2) {
        int lastComponentId = this.lastAccessedComponentId;
        if (index2 >= this.indices[lastComponentId]) {
            if (index2 < this.indices[lastComponentId + 1]) {
                return lastComponentId;
            }
            for (int i = lastComponentId + 1; i < this.components.length; ++i) {
                if (index2 >= this.indices[i + 1]) continue;
                this.lastAccessedComponentId = i;
                return i;
            }
        } else {
            for (int i = lastComponentId - 1; i >= 0; --i) {
                if (index2 < this.indices[i]) continue;
                this.lastAccessedComponentId = i;
                return i;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void discardReadBytes() {
        int localReaderIndex = this.readerIndex();
        if (localReaderIndex == 0) {
            return;
        }
        int localWriterIndex = this.writerIndex();
        int bytesToMove = this.capacity() - localReaderIndex;
        List<ChannelBuffer> list2 = this.decompose(localReaderIndex, bytesToMove);
        ChannelBuffer padding = ChannelBuffers.buffer(this.order(), localReaderIndex);
        padding.writerIndex(localReaderIndex);
        list2.add(padding);
        int localMarkedReaderIndex = localReaderIndex;
        try {
            this.resetReaderIndex();
            localMarkedReaderIndex = this.readerIndex();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        int localMarkedWriterIndex = localWriterIndex;
        try {
            this.resetWriterIndex();
            localMarkedWriterIndex = this.writerIndex();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this.setComponents(list2);
        localMarkedReaderIndex = Math.max(localMarkedReaderIndex - localReaderIndex, 0);
        localMarkedWriterIndex = Math.max(localMarkedWriterIndex - localReaderIndex, 0);
        this.setIndex(localMarkedReaderIndex, localMarkedWriterIndex);
        this.markReaderIndex();
        this.markWriterIndex();
        localWriterIndex = Math.max(localWriterIndex - localReaderIndex, 0);
        this.setIndex(0, localWriterIndex);
    }

    @Override
    public String toString() {
        String result2 = super.toString();
        result2 = result2.substring(0, result2.length() - 1);
        return result2 + ", components=" + this.components.length + ")";
    }
}

