/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.helper.CoreField;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Login;
import org.eclipse.persistence.internal.oxm.record.AbstractMarshalRecordImpl;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.ValidatingMarshalRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class MarshalRecord<MARSHALLER extends Marshaller>
extends AbstractMarshalRecordImpl<CoreAbstractSession, CoreField, MARSHALLER, NamespaceResolver>
implements org.eclipse.persistence.internal.oxm.record.MarshalRecord<CoreAbstractSession, CoreField, MARSHALLER, NamespaceResolver> {
    private ArrayList<XPathNode> groupingElements;
    private HashMap positionalNodes;
    protected XPathFragment textWrapperFragment;
    private MarshalRecord.CycleDetectionStack<Object> cycleDetectionStack = new MarshalRecord.CycleDetectionStack();
    private Stack<CoreAttributeGroup> attributeGroupStack;
    protected static final String COLON_W_SCHEMA_NIL_ATTRIBUTE = ":nil";
    protected static final String TRUE = "true";

    public MarshalRecord() {
        super(null);
        this.namespaceResolver = new NamespaceResolver();
    }

    @Override
    public void forceValueWrapper() {
    }

    public HashMap getPositionalNodes() {
        if (this.positionalNodes == null) {
            this.positionalNodes = new HashMap();
        }
        return this.positionalNodes;
    }

    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    @Override
    public Node getDOM() {
        return null;
    }

    @Override
    public void addGroupingElement(XPathNode xPathNode) {
        if (this.groupingElements == null) {
            this.groupingElements = new ArrayList(2);
        }
        this.groupingElements.add(xPathNode);
    }

    @Override
    public void removeGroupingElement(XPathNode xPathNode) {
        if (this.groupingElements != null) {
            this.groupingElements.remove(xPathNode);
        }
    }

    public String transformToXML() {
        return null;
    }

    @Override
    public void setSession(CoreAbstractSession session) {
        super.setSession(session);
        if (session != null && session.getDatasourceLogin() instanceof Login) {
            this.equalNamespaceResolvers = ((Login)session.getDatasourceLogin()).hasEqualNamespaceResolvers();
        }
    }

    @Override
    public void add(CoreField key, Object value2) {
        if (value2 == null) {
            return;
        }
        Field xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        if (lastFragment.nameIsText()) {
            this.characters(xmlField.getSchemaType(), value2, null, xmlField.isCDATA());
        } else if (lastFragment.isAttribute()) {
            this.attribute(lastFragment, (NamespaceResolver)xmlField.getNamespaceResolver(), value2, xmlField.getSchemaType());
        } else {
            this.element(lastFragment);
        }
    }

    @Override
    public Object put(CoreField key, Object value2) {
        this.add(key, value2);
        return null;
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return;
        }
        String namespaceURI = namespaceResolver.getDefaultNamespaceURI();
        if (namespaceURI != null) {
            this.defaultNamespaceDeclaration(namespaceURI);
        }
        if (namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry2 : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                String namespacePrefix = entry2.getKey();
                this.namespaceDeclaration(namespacePrefix, entry2.getValue());
            }
        }
    }

    @Override
    public boolean emptyCollection(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, boolean openGrouping) {
        if (openGrouping) {
            XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
            this.closeStartGroupingElements(groupingFragment);
            return true;
        }
        return false;
    }

    @Override
    public void namespaceDeclaration(String prefix, String namespaceURI) {
        this.attribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, namespaceURI);
    }

    public void defaultNamespaceDeclaration(String defaultNamespace) {
        this.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", defaultNamespace);
    }

    public abstract void startDocument(String var1, String var2);

    public void writeHeader() {
    }

    public abstract void endDocument();

    public void marshalWithoutRootElement(ObjectBuilder treeObjectBuilder, Object object, Descriptor descriptor, Root root2, boolean isXMLRoot) {
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null && namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry2 : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                this.startPrefixMapping(entry2.getKey(), entry2.getValue());
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    public abstract void element(XPathFragment var1);

    @Override
    public abstract void attribute(XPathFragment var1, NamespaceResolver var2, String var3);

    @Override
    public abstract void attribute(String var1, String var2, String var3, String var4);

    @Override
    public abstract void closeStartElement();

    @Override
    public abstract void endElement(XPathFragment var1, NamespaceResolver var2);

    @Override
    public abstract void characters(String var1);

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Object value2, QName schemaType) {
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value2);
            this.attribute(xPathFragment, namespaceResolver, convertedValue);
        } else {
            String convertedValue = (String)((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value2, CoreClassConstants.STRING, schemaType);
            this.attribute(xPathFragment, namespaceResolver, convertedValue);
        }
    }

    @Override
    public void characters(QName schemaType, Object value2, String mimeType, boolean isCDATA) {
        if (mimeType != null) {
            value2 = value2 instanceof List ? XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesListForBinaryValues((List)value2, this.marshaller, mimeType) : (Object)XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(value2, this.marshaller, mimeType).getData();
        }
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value2);
            this.characters(convertedValue);
        } else {
            String convertedValue = (String)((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value2, CoreClassConstants.STRING, schemaType);
            if (isCDATA) {
                this.cdata(convertedValue);
            } else {
                this.characters(convertedValue);
            }
        }
    }

    @Override
    public String getValueToWrite(QName schemaType, Object value2, ConversionManager conversionManager) {
        if (value2 == null) {
            return null;
        }
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            return this.getStringForQName((QName)value2);
        }
        if (value2.getClass() == String.class) {
            return (String)value2;
        }
        return (String)conversionManager.convertObject(value2, CoreClassConstants.STRING, schemaType);
    }

    protected String getStringForQName(QName qName) {
        if (qName == null) {
            return null;
        }
        String namespaceURI = qName.getNamespaceURI();
        if (namespaceURI == null || namespaceURI.length() == 0) {
            if (this.getNamespaceResolver() != null && ((NamespaceResolver)this.getNamespaceResolver()).getDefaultNamespaceURI() != null) {
                this.defaultNamespaceDeclaration(namespaceURI);
            }
            return qName.getLocalPart();
        }
        Object namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(namespaceURI);
        }
        if (namespaceURI.equals(((NamespaceResolver)namespaceResolver).getDefaultNamespaceURI())) {
            return qName.getLocalPart();
        }
        String prefix = ((NamespaceResolver)namespaceResolver).resolveNamespaceURI(namespaceURI);
        if (prefix == null) {
            prefix = namespaceURI.equals("http://www.w3.org/2001/XMLSchema") ? ((NamespaceResolver)namespaceResolver).generatePrefix("xsd") : ((NamespaceResolver)namespaceResolver).generatePrefix();
            this.namespaceDeclaration(prefix, namespaceURI);
        }
        if ("".equals(prefix)) {
            return qName.getLocalPart();
        }
        return String.valueOf(prefix) + ':' + qName.getLocalPart();
    }

    @Override
    public abstract void cdata(String var1);

    @Override
    public void node(Node node, NamespaceResolver resolver) {
        this.node(node, resolver, null, null);
    }

    public abstract void node(Node var1, NamespaceResolver var2, String var3, String var4);

    @Override
    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        if (this.groupingElements == null) {
            return null;
        }
        XPathFragment xPathFragment = null;
        int x = 0;
        int groupingElementsSize = this.groupingElements.size();
        while (x < groupingElementsSize) {
            XPathNode xPathNode = this.groupingElements.get(x);
            xPathFragment = xPathNode.getXPathFragment();
            this.openStartElement(xPathFragment, namespaceResolver);
            this.predicateAttribute(xPathFragment, namespaceResolver);
            if (x != groupingElementsSize - 1) {
                this.closeStartElement();
            }
            ++x;
        }
        this.groupingElements = null;
        return xPathFragment;
    }

    @Override
    public void closeStartGroupingElements(XPathFragment groupingFragment) {
        if (groupingFragment != null) {
            this.closeStartElement();
        }
    }

    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (xPathFragment.containsIndex()) {
            String shortName = xPathFragment.getShortName();
            Integer index2 = (Integer)this.getPositionalNodes().get(shortName);
            int start = index2 == null ? 1 : index2;
            int x = start;
            while (x < xPathFragment.getIndexValue()) {
                this.element(xPathFragment);
                ++x;
            }
            this.getPositionalNodes().put(shortName, xPathFragment.getIndexValue() + 1);
        }
    }

    @Override
    public void beforeContainmentMarshal(Object child) {
        Object marshalListener;
        if (this.marshaller != null && (marshalListener = this.marshaller.getMarshalListener()) != null) {
            try {
                marshalListener.beforeMarshal(child);
            }
            catch (EclipseLinkException e) {
                ErrorHandler errorHandler = this.marshaller.getErrorHandler();
                if (errorHandler == null) {
                    throw e;
                }
                try {
                    ValidatingMarshalRecord.MarshalSAXParseException saxParseException = new ValidatingMarshalRecord.MarshalSAXParseException(null, null, null, -1, -1, e, child);
                    errorHandler.error(saxParseException);
                }
                catch (SAXException sAXException) {
                    throw e;
                }
            }
        }
        this.setOwningObject(child);
    }

    @Override
    public void afterContainmentMarshal(Object parent, Object child) {
        Object marshalListener;
        if (this.marshaller != null && (marshalListener = this.marshaller.getMarshalListener()) != null) {
            try {
                marshalListener.afterMarshal(child);
            }
            catch (EclipseLinkException e) {
                ErrorHandler errorHandler = this.marshaller.getErrorHandler();
                if (errorHandler == null) {
                    throw e;
                }
                try {
                    ValidatingMarshalRecord.MarshalSAXParseException saxParseException = new ValidatingMarshalRecord.MarshalSAXParseException(null, null, null, -1, -1, e, child);
                    errorHandler.error(saxParseException);
                }
                catch (SAXException sAXException) {
                    throw e;
                }
            }
        }
        this.setOwningObject(parent);
    }

    @Override
    public ArrayList<XPathNode> getGroupingElements() {
        return this.groupingElements;
    }

    @Override
    public void setGroupingElement(ArrayList<XPathNode> elements) {
        this.groupingElements = elements;
    }

    @Override
    public void predicateAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment predicateXPathFragment;
        XPathPredicate predicate;
        if (xPathFragment != null && (predicate = xPathFragment.getPredicate()) != null && (predicateXPathFragment = predicate.getXPathFragment()).isAttribute()) {
            this.attribute(predicateXPathFragment, namespaceResolver, predicate.getValue());
        }
    }

    @Override
    public void startCollection() {
    }

    @Override
    public void emptyAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.attribute(xPathFragment, namespaceResolver, "");
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void emptyComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.closeStartElement();
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void emptySimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void nilSimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        StringBuilder qName = new StringBuilder(Constants.ATTRIBUTE.charValue());
        qName.append(xsiPrefix).append(COLON_W_SCHEMA_NIL_ATTRIBUTE);
        XPathFragment nilFragment = new XPathFragment(qName.toString());
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void nilComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        XPathFragment nilFragment = new XPathFragment(Constants.ATTRIBUTE + xsiPrefix + COLON_W_SCHEMA_NIL_ATTRIBUTE);
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartElement();
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void endCollection() {
    }

    protected String processNamespaceResolverForXSIPrefix(NamespaceResolver namespaceResolver) {
        String xsiPrefix;
        if (namespaceResolver == null) {
            xsiPrefix = "xsi";
            namespaceResolver = new NamespaceResolver();
            namespaceResolver.put(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            this.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            if (xsiPrefix == null) {
                xsiPrefix = namespaceResolver.generatePrefix("xsi");
                this.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        return xsiPrefix;
    }

    @Override
    public XPathFragment getTextWrapperFragment() {
        return null;
    }

    protected String getNameForFragment(XPathFragment xPathFragment) {
        String prefix;
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getShortName();
        }
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI().length() > 0 && (prefix = this.getPrefixForFragment(xPathFragment)) != null && prefix.length() > 0) {
            return String.valueOf(prefix) + ':' + xPathFragment.getLocalName();
        }
        return xPathFragment.getLocalName();
    }

    protected byte[] getPrefixBytes(XPathFragment xPathFragment) {
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getPrefixBytes();
        }
        String prefix = this.getPrefixForFragment(xPathFragment);
        if (prefix == null || prefix.isEmpty()) {
            return null;
        }
        return prefix.getBytes(Constants.DEFAULT_CHARSET);
    }

    protected String getPrefixForFragment(XPathFragment xPathFragment) {
        if (!this.hasCustomNamespaceMapper) {
            return xPathFragment.getPrefix();
        }
        String uri = xPathFragment.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return "";
        }
        String defaultNamespace = ((NamespaceResolver)this.getNamespaceResolver()).getDefaultNamespaceURI();
        if (defaultNamespace != null && defaultNamespace.equals(uri)) {
            return "";
        }
        String prefix = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(uri);
        if (prefix != null) {
            return prefix;
        }
        for (Object next2 : ((NamespaceResolver)this.getNamespaceResolver()).getNamespaces()) {
            Namespace ns = (Namespace)next2;
            uri = ns.getNamespaceURI();
            prefix = ns.getPrefix();
        }
        return xPathFragment.getPrefix();
    }

    @Override
    public MarshalRecord.CycleDetectionStack<Object> getCycleDetectionStack() {
        return this.cycleDetectionStack;
    }

    private Field convertToXMLField(CoreField field2) {
        return (Field)field2;
    }

    @Override
    public boolean isWrapperAsCollectionName() {
        return false;
    }

    @Override
    public CoreAttributeGroup getCurrentAttributeGroup() {
        if (this.attributeGroupStack == null || this.attributeGroupStack.isEmpty()) {
            return DEFAULT_ATTRIBUTE_GROUP;
        }
        return this.attributeGroupStack.peek();
    }

    @Override
    public void pushAttributeGroup(CoreAttributeGroup group) {
        if (group == DEFAULT_ATTRIBUTE_GROUP && this.attributeGroupStack == null) {
            return;
        }
        if (this.attributeGroupStack == null) {
            this.attributeGroupStack = new Stack();
        }
        this.attributeGroupStack.push(group);
    }

    @Override
    public void popAttributeGroup() {
        if (this.attributeGroupStack != null) {
            this.attributeGroupStack.pop();
        }
    }

    @Override
    public void flush() {
    }
}

