/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.ReferenceResolver;
import org.eclipse.persistence.internal.oxm.UnmarshalXPathEngine;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.AbstractUnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.TransformationRecord;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.IDResolver;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.record.XMLEntry;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRecord
extends XMLRecord
implements TransformationRecord {
    private Node dom;
    private Node currentNode;
    private XMLField lastUpdatedField;
    private ReferenceResolver referenceResolver;

    public DOMRecord() {
        this.setNamespaceResolver(new NamespaceResolver());
        this.referenceResolver = new ReferenceResolver();
    }

    public DOMRecord(String rootElementName) {
        this(rootElementName, (NamespaceResolver)null);
    }

    public DOMRecord(String rootElementName, NamespaceResolver namespaceResolver) {
        this();
        String rootElementNamespaceURI = this.resolveNamespace(namespaceResolver, rootElementName);
        this.setDOM(this.createNewDocument(rootElementName, rootElementNamespaceURI));
    }

    public DOMRecord(String rootElementName, String rootElementNamespaceURI) {
        this();
        this.setDOM(this.createNewDocument(rootElementName, rootElementNamespaceURI));
    }

    public DOMRecord(String localRootElementName, Node parent) {
        this(localRootElementName, null, parent);
    }

    public DOMRecord(String localRootElementName, NamespaceResolver namespaceResolver, Node parent) {
        this();
        Document document2 = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        String localRootElementNamespaceURI = this.resolveNamespace(namespaceResolver, localRootElementName);
        Element child = document2.createElementNS(localRootElementNamespaceURI, localRootElementName);
        parent.appendChild(child);
        this.setDOM(child);
    }

    public DOMRecord(Element element) {
        this();
        this.setDOM(element);
    }

    public DOMRecord(Node node) {
        this();
        this.setDOM(node);
    }

    public DOMRecord(Document document2) {
        this();
        this.setDOM(document2.getDocumentElement());
    }

    @Override
    public String getLocalName() {
        String localName = this.getDOM().getLocalName();
        if (localName != null) {
            return localName;
        }
        return this.getDOM().getNodeName();
    }

    @Override
    public String getNamespaceURI() {
        return this.getDOM().getNamespaceURI();
    }

    public ReferenceResolver getReferenceResolver() {
        if (this.referenceResolver == null) {
            this.referenceResolver = new ReferenceResolver();
        }
        return this.referenceResolver;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    @Override
    public void add(DatabaseField key, Object value2) {
        Object nodeValue = this.convertToNodeValue(value2);
        XPathEngine.getInstance().create(this.convertToXMLField(key), this.dom, nodeValue, this.session);
    }

    private Object convertToNodeValue(Object value2) {
        if (value2 instanceof List) {
            List values = (List)value2;
            Vector<Object> nodeValues = new Vector<Object>(values.size());
            int index2 = 0;
            while (index2 < values.size()) {
                Object nestedValue = values.get(index2);
                nodeValues.add(this.convertToNodeValue(nestedValue));
                ++index2;
            }
            return nodeValues;
        }
        if (value2 instanceof DOMRecord) {
            return ((DOMRecord)value2).getDOM();
        }
        if (value2 != null && value2.getClass() == XMLEntry.class) {
            XMLEntry entry2 = (XMLEntry)value2;
            entry2.setValue(this.convertToNodeValue(entry2.getValue()));
            return entry2;
        }
        return value2;
    }

    @Override
    public void clear() {
        if (this.getDOM() instanceof Element) {
            String domName = ((Element)this.getDOM()).getTagName();
            this.currentNode = this.dom = this.createNewDocument(domName, null);
        }
    }

    @Override
    public DOMRecord clone() {
        DOMRecord clone2 = (DOMRecord)super.clone();
        if (clone2 != null) {
            clone2.setDOM((Element)this.dom.cloneNode(true));
        }
        return clone2;
    }

    public Node createNewDocument(String defaultRootElementName) {
        return this.createNewDocument(defaultRootElementName, null);
    }

    public Node createNewDocument(String defaultRootElementName, String namespaceURI) {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        Document document2 = xmlPlatform.createDocument();
        if (defaultRootElementName == null || defaultRootElementName.length() == 0) {
            DocumentFragment fragment = document2.createDocumentFragment();
            return fragment;
        }
        Element rootNode = document2.createElementNS(namespaceURI, defaultRootElementName);
        document2.appendChild(rootNode);
        return document2.getDocumentElement();
    }

    @Override
    public Document getDocument() {
        return this.getDOM().getOwnerDocument();
    }

    @Override
    public boolean containsKey(DatabaseField key) {
        XMLField xmlField = this.convertToXMLField(key);
        NodeList nodeList = UnmarshalXPathEngine.getInstance().selectNodes(this.dom, xmlField, (XMLNamespaceResolver)xmlField.getNamespaceResolver());
        return nodeList.getLength() > 0;
    }

    @Override
    public boolean contains(Object value2) {
        return this.values().contains(value2);
    }

    @Override
    public Object get(DatabaseField key) {
        Object value2 = this.getIndicatingNoEntry(key);
        if (value2 == noEntry) {
            return null;
        }
        return value2;
    }

    @Override
    public Object getIndicatingNoEntry(DatabaseField key) {
        return this.getIndicatingNoEntry(key, false, false);
    }

    public Object getIndicatingNoEntry(DatabaseField key, boolean shouldReturnNode) {
        return this.getIndicatingNoEntry(key, shouldReturnNode, false);
    }

    public Object getIndicatingNoEntry(DatabaseField key, boolean shouldReturnNode, boolean checkForXsiNil) {
        XMLField field2 = this.convertToXMLField(key);
        if (field2.isSelfField()) {
            return this;
        }
        Object result2 = UnmarshalXPathEngine.getInstance().selectSingleNode(this.dom, field2, (XMLNamespaceResolver)field2.getNamespaceResolver(), checkForXsiNil);
        if (result2 == noEntry) {
            if (shouldReturnNode) {
                return null;
            }
            return noEntry;
        }
        if (result2 == NIL) {
            return NIL;
        }
        Node node = (Node)result2;
        if (shouldReturnNode) {
            return node;
        }
        if (node == null) {
            return null;
        }
        if (1 != node.getNodeType()) {
            if (node.getNodeType() == 2) {
                this.getValueFromAttribute((Attr)node, field2);
            }
            return this.getValueFromElement((Element)node.getParentNode(), node, field2);
        }
        return this.buildNestedRow((Element)node);
    }

    @Override
    public Object getValues(String key) {
        Object value2 = this.getValuesIndicatingNoEntry(new XMLField(key));
        if (value2 == AbstractRecord.noEntry) {
            return null;
        }
        return value2;
    }

    @Override
    public Object getValues(DatabaseField key) {
        return this.getValues(key, null);
    }

    public Object getValues(DatabaseField key, AbstractNullPolicy nullPolicy) {
        Object value2 = this.getValuesIndicatingNoEntry(key, nullPolicy);
        if (value2 == AbstractRecord.noEntry) {
            return null;
        }
        return value2;
    }

    public Object getValuesIndicatingNoEntry(DatabaseField key) {
        return this.getValuesIndicatingNoEntry(key, null);
    }

    public Object getValuesIndicatingNoEntry(DatabaseField key, AbstractNullPolicy nullPolicy) {
        return this.getValuesIndicatingNoEntry(key, false, nullPolicy);
    }

    public List<XMLEntry> getValuesIndicatingNoEntry(List<DatabaseField> keys) {
        return this.getValuesIndicatingNoEntry(keys, false);
    }

    public List<XMLEntry> getValuesIndicatingNoEntry(List<DatabaseField> keys, boolean shouldReturnNodes) {
        List<XMLField> xmlFields = this.convertToXMLField(keys);
        List<XMLEntry> values = UnmarshalXPathEngine.getInstance().selectNodes(this.dom, xmlFields, (XMLNamespaceResolver)xmlFields.get(0).getNamespaceResolver());
        if (shouldReturnNodes) {
            return values;
        }
        for (XMLEntry next2 : values) {
            Node nextNode = (Node)next2.getValue();
            if (nextNode.getNodeType() != 1) {
                Object value2 = this.getValueFromElement((Element)nextNode.getParentNode(), nextNode, next2.getXMLField());
                next2.setValue(value2);
                continue;
            }
            next2.setValue(this.buildNestedRow((Element)nextNode));
        }
        return values;
    }

    public Object getValuesIndicatingNoEntry(DatabaseField key, boolean shouldReturnNodes) {
        return this.getValuesIndicatingNoEntry(key, shouldReturnNodes, null);
    }

    public Object getValuesIndicatingNoEntry(DatabaseField key, boolean shouldReturnNodes, AbstractNullPolicy nullPolicy) {
        XMLField field2 = this.convertToXMLField(key);
        NodeList nodeList = UnmarshalXPathEngine.getInstance().selectNodes(this.dom, field2, (XMLNamespaceResolver)field2.getNamespaceResolver(), nullPolicy);
        if (nodeList == null) {
            return null;
        }
        int resultSize = nodeList.getLength();
        Vector<Object> result2 = new Vector<Object>(resultSize);
        if (resultSize == 0) {
            return result2;
        }
        if (shouldReturnNodes) {
            int i = 0;
            while (i < resultSize) {
                result2.add(nodeList.item(i));
                ++i;
            }
            return result2;
        }
        Node firstNode = nodeList.item(0);
        if (firstNode == null || firstNode.getNodeType() != 1) {
            if (field2.usesSingleNode() && resultSize == 1) {
                Node next2 = nodeList.item(0);
                if (next2 == null) {
                    result2.add(null);
                } else {
                    Vector<Object> list2 = new Vector<Object>();
                    String sourceObject = next2.getNodeValue();
                    StringTokenizer tokenizer = new StringTokenizer(sourceObject, " ");
                    while (tokenizer.hasMoreElements()) {
                        String token2 = tokenizer.nextToken();
                        Object nextItem = this.convertValue((Element)next2.getParentNode(), field2, token2);
                        list2.add(nextItem);
                    }
                    return list2;
                }
            }
            int x = 0;
            while (x < resultSize) {
                Node next3 = nodeList.item(x);
                if (next3 == null) {
                    result2.add(null);
                } else {
                    result2.add(this.getValueFromElement((Element)next3.getParentNode(), next3, field2));
                }
                ++x;
            }
        } else {
            int x = 0;
            while (x < resultSize) {
                result2.add(this.buildNestedRow((Element)nodeList.item(x)));
                ++x;
            }
        }
        return result2;
    }

    private Object getValueFromAttribute(Attr node, XMLField key) {
        this.currentNode = node.getOwnerElement();
        Object convertedValue = key.convertValueBasedOnSchemaType((Object)node.getNodeValue(), (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager(), (AbstractUnmarshalRecord)this);
        this.currentNode = this.getDOM();
        return convertedValue;
    }

    private Object getValueFromElement(Element node, Node textChild, Field key) {
        String value2 = textChild.getNodeValue();
        return this.convertValue(node, key, value2);
    }

    private Object convertValue(Element node, Field key, Object value2) {
        String schemaType;
        XMLConversionManager xmlCnvMgr = (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager();
        if (key.isTypedTextField() && node != null && (schemaType = node.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) != null && schemaType.length() > 0) {
            QName qname = null;
            int index2 = schemaType.indexOf(58);
            if (index2 == -1) {
                qname = new QName(schemaType);
                Class convertClass = key.getJavaClass(qname, xmlCnvMgr);
                return xmlCnvMgr.convertObject(value2, convertClass);
            }
            String prefix = schemaType.substring(0, index2);
            String localPart = schemaType.substring(index2 + 1);
            XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            String url = xmlPlatform.resolveNamespacePrefix(node, prefix);
            qname = new QName(url, localPart);
            Class convertClass = key.getJavaClass(qname, xmlCnvMgr);
            return xmlCnvMgr.convertObject(value2, convertClass, qname);
        }
        this.currentNode = node;
        Object convertedValue = key.convertValueBasedOnSchemaType(value2, xmlCnvMgr, this);
        this.currentNode = this.getDOM();
        return convertedValue;
    }

    public XMLRecord buildNestedRow(Element element) {
        DOMRecord record = new DOMRecord(element);
        record.setUnmarshaller(this.getUnmarshaller());
        record.setOwningObject(this.getCurrentObject());
        record.setDocPresPolicy(this.getDocPresPolicy());
        record.setReferenceResolver(this.referenceResolver);
        return record;
    }

    @Override
    public Node getDOM() {
        return this.dom;
    }

    @Override
    public Object put(DatabaseField key, Object value2) {
        XMLField field2 = this.convertToXMLField(key);
        Object nodeValue = this.convertToNodeValue(value2);
        NodeList replaced = null;
        boolean isEmptyCollection = false;
        if (nodeValue instanceof Collection) {
            isEmptyCollection = ((Collection)nodeValue).size() == 0;
            replaced = XPathEngine.getInstance().replaceCollection(this.convertToXMLField(key), this.dom, (Collection)nodeValue, this.session);
        } else {
            replaced = XPathEngine.getInstance().replaceValue(this.convertToXMLField(key), this.dom, nodeValue, this.session);
        }
        if (replaced.getLength() == 0) {
            XPathEngine.getInstance().create(this.convertToXMLField(key), this.dom, nodeValue, (Field)this.lastUpdatedField, this.getDocPresPolicy(), (CoreAbstractSession)this.session);
        } else if (replaced.item(0) == this.getDOM()) {
            this.setDOM(this.getDocument().getDocumentElement());
        }
        if (!(field2.getXPathFragment().isAttribute() || field2.getXPathFragment().nameIsText() || value2 == null || isEmptyCollection)) {
            this.lastUpdatedField = field2;
        }
        return replaced;
    }

    public Object put(List<XMLField> xmlFields, List<XMLEntry> values) {
        Vector valuesToWrite = (Vector)this.convertToNodeValue(values);
        List<XMLEntry> replaced = null;
        replaced = XPathEngine.getInstance().replaceCollection(xmlFields, valuesToWrite, this.dom, this.getDocPresPolicy(), this.lastUpdatedField, this.session);
        if (replaced.size() == 0) {
            XPathEngine.getInstance().create(xmlFields, this.dom, valuesToWrite, (Field)this.lastUpdatedField, this.getDocPresPolicy(), (CoreAbstractSession)this.session);
        }
        return replaced;
    }

    @Override
    public Object put(Object key, Object value2) throws ValidationException {
        if (key instanceof String) {
            return this.put((String)key, value2);
        }
        if (key instanceof DatabaseField) {
            return this.put((DatabaseField)key, value2);
        }
        if (key instanceof List) {
            return this.put((List)key, (List)value2);
        }
        throw ValidationException.onlyFieldsAreValidKeysForDatabaseRows();
    }

    @Override
    public Object remove(DatabaseField key) {
        return XPathEngine.getInstance().remove(this.convertToXMLField(key), this.dom, true);
    }

    @Override
    public void replaceAt(Object value2, int index2) {
        throw XMLMarshalException.operationNotSupported("replaceAt(Object value, int index)");
    }

    @Override
    public Set entrySet() {
        int size2 = this.size();
        HashMap tempMap = new HashMap(size2);
        Vector fields = this.getFields();
        Vector values = this.getValues();
        int i = 0;
        while (i < size2) {
            tempMap.put(fields.elementAt(i), values.elementAt(i));
            ++i;
        }
        return tempMap.entrySet();
    }

    @Override
    protected void setFields(Vector fields) throws XMLMarshalException {
        throw XMLMarshalException.operationNotSupported("setField(Vector fields)");
    }

    public Vector getFields() {
        int length = this.getDOM().getChildNodes().getLength();
        Node nextNode = null;
        if (length > 0) {
            nextNode = this.getDOM().getChildNodes().item(0);
        }
        Vector<DatabaseField> fields = new Vector<DatabaseField>(length);
        while (nextNode != null) {
            fields.add(new DatabaseField(nextNode.getNodeName()));
            nextNode = nextNode.getNextSibling();
        }
        return fields;
    }

    @Override
    public Vector getValues() {
        int length = this.getDOM().getChildNodes().getLength();
        Node nextNode = null;
        if (length > 0) {
            nextNode = this.getDOM().getFirstChild();
        }
        Vector<Node> values = new Vector<Node>(length);
        while (nextNode != null) {
            values.add(nextNode);
            nextNode = nextNode.getNextSibling();
        }
        return values;
    }

    @Override
    protected void setValues(Vector values) throws XMLMarshalException {
        throw XMLMarshalException.operationNotSupported("setValues(Vector values)");
    }

    public void setDOM(Node element) {
        this.dom = element;
        this.currentNode = element;
        this.getNamespaceResolver().setDOM(element);
    }

    public void setDOM(Element element) {
        this.dom = element;
        this.currentNode = element;
        this.getNamespaceResolver().setDOM(element);
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("(");
        this.transformToWriter(writer);
        writer.write(")");
        return writer.toString();
    }

    @Override
    public Set keySet() {
        int length = this.getDOM().getChildNodes().getLength();
        HashSet<String> keys = new HashSet<String>(length);
        int index2 = 0;
        while (index2 < length) {
            keys.add(this.getDOM().getChildNodes().item(index2).getNodeName());
            ++index2;
        }
        return keys;
    }

    @Override
    public Collection values() {
        int length = this.getDOM().getChildNodes().getLength();
        Vector<Node> values = new Vector<Node>(length);
        int index2 = 0;
        while (index2 < length) {
            values.add(this.getDOM().getChildNodes().item(index2));
            ++index2;
        }
        return values;
    }

    @Override
    public int size() {
        return this.getDOM().getAttributes().getLength() + this.getDOM().getChildNodes().getLength();
    }

    public void transformFromXML(String xml) {
        StringReader reader = new StringReader(xml);
        this.transformFromXML(reader);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String localName) {
        if (localName == null) {
            return null;
        }
        int colonIndex = localName.indexOf(58);
        if (colonIndex < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.getDefaultNamespaceURI();
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(localName);
        }
        String prefix = localName.substring(0, colonIndex);
        String uri = namespaceResolver.resolveNamespacePrefix(prefix);
        if (uri == null) {
            throw XMLMarshalException.namespaceNotFound(prefix);
        }
        return uri;
    }

    @Override
    public void setSession(AbstractSession session) {
        this.session = session;
        if (session != null && session.getDatasourceLogin() instanceof XMLLogin) {
            this.equalNamespaceResolvers = ((XMLLogin)session.getDatasourceLogin()).hasEqualNamespaceResolvers();
        }
    }

    public void transformFromXML(Reader reader) {
        XMLParser parser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
        Document document2 = parser.parse(reader);
        this.setDOM(document2.getDocumentElement());
    }

    @Override
    public String transformToXML() {
        StringWriter writer = new StringWriter();
        this.transformToWriter(writer);
        return writer.toString();
    }

    public void transformToWriter(Writer writer) {
        XMLTransformer xmlTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        xmlTransformer.transform(this.getDOM(), writer);
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        return xmlPlatform.resolveNamespacePrefix(this.currentNode, prefix);
    }

    public void resolveReferences(CoreAbstractSession abstractSession, IDResolver idResolver) {
        if (this.referenceResolver != null) {
            this.referenceResolver.resolveReferences(abstractSession, idResolver, this.unmarshaller.getErrorHandler());
        }
    }
}

