/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLChoiceFieldToClassAssociation;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceObjectMapping;
import org.eclipse.persistence.internal.oxm.record.AbstractMarshalRecord;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.converters.XMLRootConverter;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class XMLChoiceObjectMapping
extends DatabaseMapping
implements ChoiceObjectMapping<AttributeAccessor, AbstractSession, ContainerPolicy, Converter, ClassDescriptor, DatabaseField, XMLMarshaller, Session, XMLUnmarshaller, XMLField, XMLMapping, XMLRecord>,
XMLMapping {
    private Map<XMLField, Class> fieldToClassMappings = new HashMap<XMLField, Class>();
    private Map<Class, XMLField> classToFieldMappings;
    private Map<String, XMLField> classNameToFieldMappings;
    private Map<Class, List<XMLField>> classToSourceFieldsMappings;
    private Map<String, List<XMLField>> classNameToSourceFieldsMappings;
    private Map<XMLField, String> fieldToClassNameMappings = new HashMap<XMLField, String>();
    private Map<XMLField, XMLMapping> choiceElementMappings;
    private Map<Class, XMLMapping> choiceElementMappingsByClass;
    private Map<String, XMLMapping> choiceElementMappingsByClassName;
    private Map<XMLField, Converter> fieldsToConverters;
    private Map<String, Converter> classNameToConverter;
    private Map<Class, Converter> classToConverter;
    private Converter converter;
    private boolean isWriteOnly;
    private static final AttributeAccessor temporaryAccessor = new InstanceVariableAttributeAccessor();
    private static final String DATA_HANDLER = "javax.activation.DataHandler";
    private static final String MIME_MULTIPART = "javax.mail.MimeMultipart";
    private static final String IMAGE = "java.awt.Image";

    public XMLChoiceObjectMapping() {
        this.classToFieldMappings = new HashMap<Class, XMLField>();
        this.classNameToFieldMappings = new HashMap<String, XMLField>();
        this.choiceElementMappings = new LinkedHashMap<XMLField, XMLMapping>();
        this.choiceElementMappingsByClass = new LinkedHashMap<Class, XMLMapping>();
        this.choiceElementMappingsByClassName = new LinkedHashMap<String, XMLMapping>();
        this.fieldsToConverters = new HashMap<XMLField, Converter>();
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    @Override
    public void buildBackupClone(Object clone2, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupClone");
    }

    @Override
    public void buildClone(Object original, CacheKey cacheKey, Object clone2, Integer refreshCascade, AbstractSession cloningSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildClone");
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone2, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneFromRow");
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public ChangeRecord compareForChange(Object clone2, Object backup, ObjectChangeSet owner, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareForChange");
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareObjects");
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
        throw DescriptorException.invalidMappingOperation(this, "fixObjectReferences");
    }

    @Override
    public Object getFieldValue(Object object, CoreAbstractSession session, AbstractMarshalRecord record) {
        Object attributeValue = super.getAttributeValueFromObject(object);
        attributeValue = this.convertObjectValueToDataValue(attributeValue, (AbstractSession)session, (XMLMarshaller)record.getMarshaller());
        return attributeValue;
    }

    @Override
    public void iterate(DescriptorIterator iterator2) {
        throw DescriptorException.invalidMappingOperation(this, "iterate");
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        throw DescriptorException.invalidMappingOperation(this, "mergeChangesIntoObject");
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUninitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        throw DescriptorException.invalidMappingOperation(this, "mergeIntoObject");
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        for (XMLMapping nextMapping : this.choiceElementMappings.values()) {
            Object value2 = ((DatabaseMapping)((Object)nextMapping)).valueFromRow(row, joinManager, sourceQuery, cacheKey, executionSession, isTargetProtected, wasCacheUsed);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        XMLMapping mapping;
        List<XMLField> xflds;
        XMLField valueField;
        Object value2 = this.getAttributeValueFromObject(object);
        Class<?> valueClass = value2.getClass();
        if (valueClass == XMLRoot.class) {
            XMLRoot root2 = (XMLRoot)value2;
            for (DatabaseField next2 : this.fields) {
                XMLField xmlField = (XMLField)next2;
                XPathFragment fragment = xmlField.getXPathFragment();
                while (fragment != null && !fragment.nameIsText()) {
                    if ((fragment.getNextFragment() == null || fragment.getHasText()) && fragment.getLocalName().equals(root2.getLocalName())) {
                        String fragUri = fragment.getNamespaceURI();
                        String namespaceUri = root2.getNamespaceURI();
                        if (namespaceUri == null && fragUri == null || namespaceUri != null && fragUri != null && namespaceUri.equals(fragUri)) {
                            XMLMapping mapping2 = this.choiceElementMappings.get(xmlField);
                            mapping2.writeSingleValue(value2, object, (XMLRecord)row, session);
                            return;
                        }
                    }
                    fragment = fragment.getNextFragment();
                }
            }
            valueClass = root2.getObject().getClass();
        }
        if ((valueField = this.classToFieldMappings.get(valueClass)) == null && (xflds = this.getClassToSourceFieldsMappings().get(valueClass)) != null) {
            valueField = xflds.get(0);
        }
        if ((mapping = this.choiceElementMappings.get(valueField)) != null) {
            mapping.writeSingleValue(value2, object, (XMLRecord)row, session);
        }
    }

    @Override
    public void writeSingleValue(Object value2, Object parent, XMLRecord row, AbstractSession session) {
    }

    @Override
    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, CacheKey parentCacheKey, ObjectBuildingQuery sourceQuery, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        Object toReturn = super.readFromRowIntoObject(databaseRow, joinManager, targetObject, parentCacheKey, sourceQuery, executionSession, isTargetProtected);
        for (XMLMapping next2 : this.choiceElementMappings.values()) {
            if (!((DatabaseMapping)((Object)next2)).isObjectReferenceMapping()) continue;
            ((DatabaseMapping)((Object)next2)).readFromRowIntoObject(databaseRow, joinManager, targetObject, parentCacheKey, sourceQuery, executionSession, isTargetProtected);
        }
        return toReturn;
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public Vector<DatabaseField> getFields() {
        return this.collectFields();
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(this.getFieldToClassMappings().keySet());
        return fields;
    }

    public void addChoiceElement(String xpath, Class elementType) {
        XMLField field2 = new XMLField(xpath);
        this.addChoiceElement(field2, elementType);
    }

    public void addChoiceElement(String srcXPath, Class elementType, String tgtXPath) {
        XMLField srcField = new XMLField(srcXPath);
        XMLField tgtField = new XMLField(tgtXPath);
        this.addChoiceElement(srcField, elementType, tgtField);
    }

    public void addChoiceElement(String xpath, String elementTypeName, boolean xmlRoot) {
        XMLField field2 = new XMLField(xpath);
        this.fieldToClassNameMappings.put(field2, elementTypeName);
        if (this.classNameToFieldMappings.get(elementTypeName) != null) {
            this.classNameToFieldMappings.put(elementTypeName, field2);
        }
        if (xmlRoot) {
            this.fieldsToConverters.put(field2, new XMLRootConverter(field2));
        }
        this.addChoiceElementMapping(field2, elementTypeName);
    }

    @Override
    public void addChoiceElement(String srcXpath, String elementTypeName, String tgtXpath) {
        XMLField field2 = new XMLField(srcXpath);
        XMLField tgtField = new XMLField(tgtXpath);
        this.fieldToClassNameMappings.put(field2, elementTypeName);
        if (this.classNameToFieldMappings.get(elementTypeName) == null) {
            this.classNameToFieldMappings.put(elementTypeName, field2);
        }
        this.addChoiceElementMapping(field2, elementTypeName, tgtField);
    }

    @Override
    public void addChoiceElement(String xpath, String elementTypeName) {
        this.addChoiceElement(xpath, elementTypeName, false);
    }

    public void addChoiceElement(XMLField xmlField, Class elementType) {
        this.getFieldToClassMappings().put(xmlField, elementType);
        this.fieldToClassNameMappings.put(xmlField, elementType.getName());
        if (this.classToFieldMappings.get(elementType) == null) {
            this.classToFieldMappings.put(elementType, xmlField);
        }
        this.addChoiceElementMapping(xmlField, elementType);
    }

    public void addChoiceElement(XMLField sourceField, Class elementType, XMLField targetField) {
        this.getFieldToClassMappings().put(sourceField, elementType);
        this.fieldToClassNameMappings.put(sourceField, elementType.getName());
        if (this.classToFieldMappings.get(elementType) == null) {
            this.classToFieldMappings.put(elementType, sourceField);
        }
        this.addChoiceElementMapping(sourceField, elementType, targetField);
    }

    public void addChoiceElement(XMLField sourceField, String elementTypeName, XMLField targetField) {
        this.fieldToClassNameMappings.put(sourceField, elementTypeName);
        this.addChoiceElementMapping(sourceField, elementTypeName, targetField);
    }

    public void addChoiceElement(List<XMLField> srcFields, Class elementType, List<XMLField> tgtFields) {
        for (XMLField sourceField : srcFields) {
            this.getFieldToClassMappings().put(sourceField, elementType);
            this.fieldToClassNameMappings.put(sourceField, elementType.getName());
        }
        if (this.getClassToSourceFieldsMappings().get(elementType) == null) {
            this.getClassToSourceFieldsMappings().put(elementType, srcFields);
        }
        this.addChoiceElementMapping(srcFields, elementType, tgtFields);
    }

    @Override
    public void addChoiceElement(List<XMLField> srcFields, String elementTypeName, List<XMLField> tgtFields) {
        for (XMLField sourceField : srcFields) {
            this.fieldToClassNameMappings.put(sourceField, elementTypeName);
        }
        if (this.getClassNameToSourceFieldsMappings().get(elementTypeName) == null) {
            this.getClassNameToSourceFieldsMappings().put(elementTypeName, srcFields);
        }
        this.addChoiceElementMapping(srcFields, elementTypeName, tgtFields);
    }

    @Override
    public void addChoiceElement(XMLField field2, String elementTypeName) {
        this.fieldToClassNameMappings.put(field2, elementTypeName);
        if (this.classNameToFieldMappings.get(elementTypeName) == null) {
            this.classNameToFieldMappings.put(elementTypeName, field2);
        }
        this.addChoiceElementMapping(field2, elementTypeName);
    }

    @Override
    public Map<XMLField, Class> getFieldToClassMappings() {
        return this.fieldToClassMappings;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.converter != null) {
            this.converter.initialize(this, session);
        }
        ArrayList<XMLMapping> mappingsList = new ArrayList<XMLMapping>();
        mappingsList.addAll(this.getChoiceElementMappings().values());
        for (XMLMapping next2 : this.getChoiceElementMappingsByClass().values()) {
            if (mappingsList.contains(next2)) continue;
            mappingsList.add(next2);
        }
        for (DatabaseMapping databaseMapping : mappingsList) {
            Converter converter = null;
            if (this.fieldsToConverters != null) {
                converter = this.fieldsToConverters.get(databaseMapping.getField());
            }
            if (databaseMapping.isAbstractDirectMapping()) {
                XMLConversionManager xmlConversionManager;
                QName schemaType;
                ((XMLDirectMapping)databaseMapping).setIsWriteOnly(this.isWriteOnly());
                if (converter != null) {
                    ((AbstractDirectMapping)databaseMapping).setConverter(converter);
                }
                if ((schemaType = (xmlConversionManager = (XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).schemaType(databaseMapping.getAttributeClassification())) != null && ((XMLField)databaseMapping.getField()).getSchemaType() == null) {
                    ((XMLField)databaseMapping.getField()).setSchemaType(schemaType);
                }
            } else if (databaseMapping instanceof XMLObjectReferenceMapping) {
                ((XMLObjectReferenceMapping)databaseMapping).setIsWriteOnly(this.isWriteOnly);
            } else if (databaseMapping instanceof XMLBinaryDataMapping) {
                ((XMLBinaryDataMapping)databaseMapping).setIsCDATA(this.isWriteOnly);
                if (converter != null) {
                    ((XMLBinaryDataMapping)databaseMapping).setConverter(converter);
                }
            } else {
                ((XMLCompositeObjectMapping)databaseMapping).setIsWriteOnly(this.isWriteOnly());
                if (converter != null) {
                    ((AbstractCompositeObjectMapping)databaseMapping).setConverter(converter);
                }
            }
            databaseMapping.initialize(session);
        }
    }

    @Override
    public Map<Class, XMLField> getClassToFieldMappings() {
        return this.classToFieldMappings;
    }

    @Override
    public Map<XMLField, XMLMapping> getChoiceElementMappings() {
        return this.choiceElementMappings;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class elementType;
        String className;
        for (Map.Entry<XMLField, String> entry2 : this.fieldToClassNameMappings.entrySet()) {
            Class elementType2;
            block35: {
                String className2 = entry2.getValue();
                elementType2 = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            elementType2 = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className2, true, classLoader));
                            break block35;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(className2, exception.getException());
                        }
                    }
                    elementType2 = PrivilegedAccessHelper.getClassForName(className2, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(className2, exc);
                }
            }
            XMLMapping mapping = this.choiceElementMappings.get(entry2.getKey());
            mapping.convertClassNamesToClasses(classLoader);
            if (this.fieldToClassMappings.get(entry2.getKey()) != null) continue;
            this.fieldToClassMappings.put(entry2.getKey(), elementType2);
        }
        for (Map.Entry entry3 : this.classNameToFieldMappings.entrySet()) {
            block36: {
                className = (String)entry3.getKey();
                elementType = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            elementType = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader));
                            break block36;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(className, exception.getException());
                        }
                    }
                    elementType = PrivilegedAccessHelper.getClassForName(className, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(className, exc);
                }
            }
            this.classToFieldMappings.put(elementType, (XMLField)entry3.getValue());
        }
        if (this.classNameToSourceFieldsMappings != null) {
            for (Map.Entry<String, List<XMLField>> nextEntry : this.classNameToSourceFieldsMappings.entrySet()) {
                Class elementType3;
                List<XMLField> fields;
                block37: {
                    className = nextEntry.getKey();
                    fields = nextEntry.getValue();
                    elementType3 = null;
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                elementType3 = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader));
                                break block37;
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(className, exception.getException());
                            }
                        }
                        elementType3 = PrivilegedAccessHelper.getClassForName(className, true, classLoader);
                    }
                    catch (ClassNotFoundException exc) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(className, exc);
                    }
                }
                this.getClassToSourceFieldsMappings().put(elementType3, fields);
            }
        }
        if (this.classNameToConverter != null) {
            if (this.classToConverter == null) {
                this.classToConverter = new HashMap<Class, Converter>();
            }
            for (Map.Entry<String, Object> entry4 : this.classNameToConverter.entrySet()) {
                block38: {
                    className = entry4.getKey();
                    elementType = null;
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                elementType = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader));
                                break block38;
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(className, exception.getException());
                            }
                        }
                        elementType = PrivilegedAccessHelper.getClassForName(className, true, classLoader);
                    }
                    catch (ClassNotFoundException exc) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(className, exc);
                    }
                }
                this.classToConverter.put(elementType, (Converter)entry4.getValue());
            }
        }
        if (!this.choiceElementMappingsByClassName.isEmpty()) {
            for (Map.Entry<String, Object> entry5 : this.choiceElementMappingsByClassName.entrySet()) {
                Class elementType2;
                block39: {
                    elementType2 = null;
                    String className3 = entry5.getKey();
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                elementType2 = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className3, true, classLoader));
                                break block39;
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(className3, exception.getException());
                            }
                        }
                        elementType2 = PrivilegedAccessHelper.getClassForName(className3, true, classLoader);
                    }
                    catch (ClassNotFoundException exc) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(className3, exc);
                    }
                }
                if (this.choiceElementMappingsByClass.get(elementType2) == null) {
                    this.choiceElementMappingsByClass.put(elementType2, (XMLMapping)entry5.getValue());
                }
                ((XMLMapping)entry5.getValue()).convertClassNamesToClasses(classLoader);
            }
        }
    }

    @Override
    public void addConverter(XMLField field2, Converter converter) {
        if (this.fieldsToConverters == null) {
            this.fieldsToConverters = new HashMap<XMLField, Converter>();
        }
        this.fieldsToConverters.put(field2, converter);
    }

    @Override
    public Converter getConverter(XMLField field2) {
        if (this.fieldsToConverters != null) {
            Converter converter = this.fieldsToConverters.get(field2);
            if (converter != null) {
                return converter;
            }
            if (this.choiceElementMappings != null) {
                DatabaseMapping mapping = (DatabaseMapping)((Object)this.choiceElementMappings.get(field2));
                if (mapping == null) {
                    return null;
                }
                if (mapping.isAbstractCompositeDirectCollectionMapping()) {
                    return ((XMLCompositeDirectCollectionMapping)mapping).getValueConverter();
                }
                if (mapping.isAbstractDirectMapping()) {
                    return ((XMLDirectMapping)mapping).getConverter();
                }
            }
        }
        return null;
    }

    public ArrayList getChoiceFieldToClassAssociations() {
        ArrayList associations = new ArrayList();
        if (this.fieldToClassNameMappings.size() > 0) {
            Set<Map.Entry<XMLField, String>> entries = this.fieldToClassNameMappings.entrySet();
            for (Map.Entry<XMLField, String> nextEntry : entries) {
                XMLField xmlField = nextEntry.getKey();
                String className = nextEntry.getValue();
                XMLChoiceFieldToClassAssociation association = new XMLChoiceFieldToClassAssociation(xmlField, className);
                associations.add(association);
            }
        }
        return associations;
    }

    public void setChoiceFieldToClassAssociations(ArrayList associations) {
        if (associations.size() > 0) {
            for (Object next2 : associations) {
                XMLChoiceFieldToClassAssociation association = (XMLChoiceFieldToClassAssociation)next2;
                this.addChoiceElement((XMLField)association.getXmlField(), association.getClassName());
                if (association.getConverter() == null) continue;
                this.addConverter((XMLField)association.getXmlField(), (Converter)association.getConverter());
            }
        }
    }

    private void addChoiceElementMapping(XMLField xmlField, String className) {
        if (xmlField.getLastXPathFragment().nameIsText() || xmlField.getLastXPathFragment().isAttribute()) {
            XMLDirectMapping xmlMapping = new XMLDirectMapping();
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            xmlMapping.setAttributeClassificationName(className);
            xmlMapping.setField(xmlField);
            if (this.choiceElementMappings.get(xmlField) == null) {
                this.choiceElementMappings.put(xmlField, xmlMapping);
            }
            if (this.choiceElementMappingsByClassName.get(className) == null) {
                this.choiceElementMappingsByClassName.put(className, xmlMapping);
            }
        } else if (this.isBinaryType(className)) {
            XMLBinaryDataMapping xmlMapping = new XMLBinaryDataMapping();
            xmlMapping.setField(xmlField);
            Class theClass = XMLConversionManager.getDefaultXMLManager().convertClassNameToClass(className);
            xmlMapping.setAttributeClassification(theClass);
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            if (this.choiceElementMappings.get(xmlField) == null) {
                this.choiceElementMappings.put(xmlField, xmlMapping);
            }
            if (this.choiceElementMappingsByClass.get(theClass) == null) {
                this.choiceElementMappingsByClass.put(theClass, xmlMapping);
            }
        } else {
            XMLCompositeObjectMapping xmlMapping = new XMLCompositeObjectMapping();
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            if (!className.equals("java.lang.Object")) {
                xmlMapping.setReferenceClassName(className);
            }
            xmlMapping.setField(xmlField);
            if (this.choiceElementMappings.get(xmlField) == null) {
                this.choiceElementMappings.put(xmlField, xmlMapping);
            }
            if (this.choiceElementMappingsByClassName.get(className) == null) {
                this.choiceElementMappingsByClassName.put(className, xmlMapping);
            }
        }
    }

    private void addChoiceElementMapping(XMLField xmlField, Class theClass) {
        if (xmlField.getLastXPathFragment().nameIsText() || xmlField.getLastXPathFragment().isAttribute()) {
            XMLDirectMapping xmlMapping = new XMLDirectMapping();
            xmlMapping.setAttributeClassification(theClass);
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            xmlMapping.setField(xmlField);
            this.choiceElementMappings.put(xmlField, xmlMapping);
            this.choiceElementMappingsByClass.put(theClass, xmlMapping);
        } else if (this.isBinaryType(theClass)) {
            XMLBinaryDataMapping xmlMapping = new XMLBinaryDataMapping();
            xmlMapping.setField(xmlField);
            xmlMapping.setAttributeClassification(theClass);
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            this.choiceElementMappings.put(xmlField, xmlMapping);
            this.choiceElementMappingsByClass.put(theClass, xmlMapping);
        } else {
            XMLCompositeObjectMapping xmlMapping = new XMLCompositeObjectMapping();
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            if (!theClass.equals(ClassConstants.OBJECT)) {
                xmlMapping.setReferenceClass(theClass);
            }
            xmlMapping.setField(xmlField);
            this.choiceElementMappings.put(xmlField, xmlMapping);
            this.choiceElementMappingsByClass.put(theClass, xmlMapping);
        }
    }

    private void addChoiceElementMapping(XMLField sourceField, Class theClass, XMLField targetField) {
        XMLObjectReferenceMapping mapping = new XMLObjectReferenceMapping();
        mapping.setReferenceClass(theClass);
        mapping.setAttributeAccessor(temporaryAccessor);
        mapping.addSourceToTargetKeyFieldAssociation(sourceField, targetField);
        this.choiceElementMappings.put(sourceField, mapping);
        this.choiceElementMappingsByClass.put(theClass, mapping);
    }

    private void addChoiceElementMapping(XMLField sourceField, String className, XMLField targetField) {
        XMLObjectReferenceMapping mapping = new XMLObjectReferenceMapping();
        mapping.setReferenceClassName(className);
        mapping.setAttributeAccessor(temporaryAccessor);
        mapping.addSourceToTargetKeyFieldAssociation(sourceField, targetField);
        this.choiceElementMappings.put(sourceField, mapping);
        this.choiceElementMappingsByClassName.put(className, mapping);
    }

    private void addChoiceElementMapping(List<XMLField> sourceFields, Class theClass, List<XMLField> targetFields) {
        XMLObjectReferenceMapping xmlMapping = new XMLObjectReferenceMapping();
        xmlMapping.setReferenceClass(theClass);
        xmlMapping.setAttributeAccessor(temporaryAccessor);
        int i = 0;
        while (i < sourceFields.size()) {
            XMLField sourceField = sourceFields.get(i);
            xmlMapping.addSourceToTargetKeyFieldAssociation(sourceField, targetFields.get(i));
            this.choiceElementMappings.put(sourceField, xmlMapping);
            ++i;
        }
        this.choiceElementMappingsByClass.put(theClass, xmlMapping);
    }

    private void addChoiceElementMapping(List<XMLField> sourceFields, String theClass, List<XMLField> targetFields) {
        XMLObjectReferenceMapping xmlMapping = new XMLObjectReferenceMapping();
        xmlMapping.setReferenceClassName(theClass);
        xmlMapping.setAttributeAccessor(temporaryAccessor);
        int i = 0;
        while (i < sourceFields.size()) {
            XMLField sourceField = sourceFields.get(i);
            xmlMapping.addSourceToTargetKeyFieldAssociation(sourceField, targetFields.get(i));
            this.choiceElementMappings.put(sourceField, xmlMapping);
            ++i;
        }
        this.choiceElementMappingsByClassName.put(theClass, xmlMapping);
    }

    @Override
    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    @Override
    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        ((AttributeAccessor)this.getAttributeAccessor()).setIsWriteOnly(this.isWriteOnly());
        ((AttributeAccessor)this.getAttributeAccessor()).setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
        ArrayList<XMLMapping> mappingsList = new ArrayList<XMLMapping>();
        mappingsList.addAll(this.getChoiceElementMappings().values());
        for (XMLMapping next2 : this.getChoiceElementMappingsByClass().values()) {
            if (mappingsList.contains(next2)) continue;
            mappingsList.add(next2);
        }
        for (XMLMapping next2 : this.getChoiceElementMappingsByClass().values()) {
            if (mappingsList.contains(next2)) continue;
            mappingsList.add(next2);
        }
        for (DatabaseMapping databaseMapping : mappingsList) {
            databaseMapping.setDescriptor((ClassDescriptor)this.getDescriptor());
            databaseMapping.setAttributeName(this.getAttributeName());
            if (databaseMapping.getAttributeAccessor() == temporaryAccessor) {
                databaseMapping.setAttributeAccessor((AttributeAccessor)this.getAttributeAccessor());
            }
            databaseMapping.preInitialize(session);
        }
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value2) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value2);
    }

    @Override
    public Map<Class, List<XMLField>> getClassToSourceFieldsMappings() {
        if (this.classToSourceFieldsMappings == null) {
            this.classToSourceFieldsMappings = new HashMap<Class, List<XMLField>>();
        }
        return this.classToSourceFieldsMappings;
    }

    private Map<String, List<XMLField>> getClassNameToSourceFieldsMappings() {
        if (this.classNameToSourceFieldsMappings == null) {
            this.classNameToSourceFieldsMappings = new HashMap<String, List<XMLField>>();
        }
        return this.classNameToSourceFieldsMappings;
    }

    private boolean isBinaryType(String className) {
        return className.equals(byte[].class.getName()) || className.equals(Byte[].class.getName()) || className.equals(DATA_HANDLER) || className.equals(IMAGE) || className.equals(MIME_MULTIPART);
    }

    private boolean isBinaryType(Class theClass) {
        String className = theClass.getName();
        return className.equals(byte[].class.getName()) || className.equals(Byte[].class.getName()) || className.equals(DATA_HANDLER) || className.equals(IMAGE) || className.equals(MIME_MULTIPART);
    }

    @Override
    public Map<String, XMLField> getClassNameToFieldMappings() {
        return this.classNameToFieldMappings;
    }

    @Override
    public Map<Class, XMLMapping> getChoiceElementMappingsByClass() {
        return this.choiceElementMappingsByClass;
    }

    public void setChoiceElementMappingsByClass(Map<Class, XMLMapping> choiceElementMappingsByClass) {
        this.choiceElementMappingsByClass = choiceElementMappingsByClass;
    }

    @Override
    public Object convertObjectValueToDataValue(Object value2, Session session, XMLMarshaller marshaller) {
        if (this.converter != null) {
            if (this.converter instanceof XMLConverter) {
                return ((XMLConverter)this.converter).convertObjectValueToDataValue(value2, session, marshaller);
            }
            return this.converter.convertObjectValueToDataValue(value2, session);
        }
        return value2;
    }

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session, XMLUnmarshaller unmarshaller) {
        if (this.converter != null) {
            if (this.converter instanceof XMLConverter) {
                return ((XMLConverter)this.converter).convertDataValueToObjectValue(fieldValue, session, unmarshaller);
            }
            return this.converter.convertDataValueToObjectValue(fieldValue, session);
        }
        return fieldValue;
    }
}

