/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;

public class XMLEventReaderReader
extends XMLReaderAdapter {
    private int depth = 0;
    private Map<Integer, List<Namespace>> namespaces = new HashMap<Integer, List<Namespace>>();
    private XMLEventReaderAttributes indexedAttributeList = new XMLEventReaderAttributes();
    private XMLEvent lastEvent;

    public XMLEventReaderReader() {
    }

    public XMLEventReaderReader(Unmarshaller xmlUnmarshaller) {
        super(xmlUnmarshaller);
    }

    @Override
    public void parse(InputSource input2) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (input2 instanceof XMLEventReaderInputSource) {
            XMLEventReader xmlEventReader = ((XMLEventReaderInputSource)input2).getXmlEventReader();
            this.parse(xmlEventReader);
        }
    }

    @Override
    public Locator getLocator() {
        if (this.locator == null) {
            this.locator = new EventReaderLocator();
        }
        ((EventReaderLocator)this.locator).setEvent(this.lastEvent);
        return this.locator;
    }

    private void parse(XMLEventReader xmlEventReader) throws SAXException {
        try {
            this.contentHandler.startDocument();
            this.parseEvent(xmlEventReader.nextEvent());
            while (this.depth > 0) {
                this.parseEvent(xmlEventReader.nextEvent());
            }
            this.contentHandler.endDocument();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void parseEvent(XMLEvent xmlEvent) throws SAXException {
        switch (xmlEvent.getEventType()) {
            case 10: {
                break;
            }
            case 12: {
                Characters characters2 = xmlEvent.asCharacters();
                if (this.lexicalHandler == null) {
                    this.contentHandler.characters(characters2.getData().toCharArray(), 0, characters2.getData().length());
                    break;
                }
                this.lexicalHandler.startCDATA();
                this.contentHandler.characters(characters2.getData().toCharArray(), 0, characters2.getData().length());
                this.lexicalHandler.endCDATA();
                break;
            }
            case 4: {
                char[] characters3 = xmlEvent.asCharacters().getData().toCharArray();
                this.contentHandler.characters(characters3, 0, characters3.length);
                break;
            }
            case 5: {
                if (this.lexicalHandler == null) break;
                char[] comment2 = ((Comment)xmlEvent).getText().toCharArray();
                this.lexicalHandler.comment(comment2, 0, comment2.length);
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                --this.depth;
                return;
            }
            case 2: {
                List<Namespace> declaredNs = this.namespaces.get(this.depth);
                --this.depth;
                EndElement endElement = xmlEvent.asEndElement();
                QName name = endElement.getName();
                String prefix = endElement.getName().getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    this.contentHandler.endElement(name.getNamespaceURI(), name.getLocalPart(), name.getLocalPart());
                } else {
                    this.contentHandler.endElement(name.getNamespaceURI(), name.getLocalPart(), String.valueOf(prefix) + ':' + name.getLocalPart());
                }
                if (declaredNs == null) break;
                for (Namespace next2 : declaredNs) {
                    this.contentHandler.endPrefixMapping(next2.getPrefix());
                }
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                ProcessingInstruction pi = (ProcessingInstruction)xmlEvent;
                this.contentHandler.processingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 6: {
                char[] characters4 = xmlEvent.asCharacters().getData().toCharArray();
                this.contentHandler.characters(characters4, 0, characters4.length);
                break;
            }
            case 7: {
                ++this.depth;
                break;
            }
            case 1: {
                this.lastEvent = xmlEvent;
                ++this.depth;
                StartElement startElement2 = xmlEvent.asStartElement();
                Iterator<Namespace> namespaces = startElement2.getNamespaces();
                ArrayList<Namespace> declaredNs = null;
                if (namespaces.hasNext()) {
                    declaredNs = new ArrayList<Namespace>();
                }
                while (namespaces.hasNext()) {
                    Namespace next3 = namespaces.next();
                    this.contentHandler.startPrefixMapping(next3.getPrefix(), next3.getNamespaceURI());
                    declaredNs.add(next3);
                }
                if (declaredNs != null) {
                    this.namespaces.put(this.depth, declaredNs);
                }
                QName qName = startElement2.getName();
                String prefix = qName.getPrefix();
                this.indexedAttributeList.setIterators(startElement2.getAttributes(), startElement2.getNamespaces());
                if (prefix == null || prefix.length() == 0) {
                    this.contentHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart(), this.indexedAttributeList);
                    break;
                }
                this.contentHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), String.valueOf(prefix) + ':' + qName.getLocalPart(), this.indexedAttributeList);
            }
        }
    }

    private static final class EventReaderLocator
    implements Locator2 {
        private XMLEvent event;

        public void setEvent(XMLEvent e) {
            this.event = e;
        }

        @Override
        public String getPublicId() {
            if (this.event == null) {
                return null;
            }
            return this.event.getLocation().getPublicId();
        }

        @Override
        public String getSystemId() {
            if (this.event == null) {
                return null;
            }
            return this.event.getLocation().getSystemId();
        }

        @Override
        public int getLineNumber() {
            if (this.event == null) {
                return -1;
            }
            return this.event.getLocation().getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            if (this.event == null) {
                return -1;
            }
            return this.event.getLocation().getColumnNumber();
        }

        @Override
        public String getXMLVersion() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }
    }

    private static final class XMLEventReaderAttributes
    extends XMLReaderAdapter.IndexedAttributeList {
        private Iterator namespaces;
        private Iterator attrs;

        private XMLEventReaderAttributes() {
        }

        public void setIterators(Iterator attrs, Iterator namespaces) {
            this.reset();
            this.namespaces = namespaces;
            this.attrs = attrs;
        }

        @Override
        protected XMLReaderAdapter.Attribute[] attributes() {
            if (this.attributes == null) {
                if (this.attrs.hasNext() || this.namespaces.hasNext()) {
                    String localName;
                    String uri;
                    Attribute next2;
                    ArrayList<XMLReaderAdapter.Attribute> attributesList = new ArrayList<XMLReaderAdapter.Attribute>();
                    while (this.namespaces.hasNext()) {
                        String qName;
                        next2 = (Namespace)this.namespaces.next();
                        uri = "http://www.w3.org/2000/xmlns/";
                        localName = next2.getPrefix();
                        if (localName == null || localName.length() == 0) {
                            localName = "xmlns";
                            qName = "xmlns";
                        } else {
                            qName = "xmlns:" + localName;
                        }
                        String value2 = next2.getNamespaceURI();
                        attributesList.add(new XMLReaderAdapter.Attribute(uri, localName, qName, value2));
                    }
                    while (this.attrs.hasNext()) {
                        next2 = (Attribute)this.attrs.next();
                        uri = next2.getName().getNamespaceURI();
                        localName = next2.getName().getLocalPart();
                        String prefix = next2.getName().getPrefix();
                        String qName = prefix == null || prefix.length() == 0 ? localName : String.valueOf(prefix) + ':' + localName;
                        String value3 = next2.getValue();
                        attributesList.add(new XMLReaderAdapter.Attribute(uri, localName, qName, value3));
                    }
                    this.attributes = attributesList.toArray(new XMLReaderAdapter.Attribute[attributesList.size()]);
                } else {
                    this.attributes = NO_ATTRIBUTES;
                }
            }
            return this.attributes;
        }
    }
}

