/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomToXMLStreamWriter {
    public void writeToStream(Node dom, String newUri, String newName, XMLStreamWriter xsw) throws XMLStreamException {
        Node currentNode = dom;
        if (dom.getNodeType() == 9) {
            Document doc = (Document)dom;
            xsw.writeStartDocument(doc.getXmlEncoding(), doc.getXmlVersion());
            currentNode = doc.getDocumentElement();
        }
        if (currentNode.getNodeType() == 1) {
            this.writeElement((Element)currentNode, newUri, newName, xsw);
        } else if (currentNode.getNodeType() == 2) {
            Attr attribute = (Attr)currentNode;
            if (attribute.getPrefix() != null && attribute.getPrefix().equals("xmlns")) {
                xsw.writeNamespace(attribute.getLocalName(), attribute.getValue());
            } else if (attribute.getPrefix() == null) {
                xsw.writeAttribute(attribute.getName(), attribute.getValue());
            } else {
                xsw.writeAttribute(attribute.getPrefix(), attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getValue());
            }
        } else if (currentNode.getNodeType() == 3) {
            xsw.writeCharacters(((Text)currentNode).getNodeValue());
        }
        if (dom.getNodeType() == 9) {
            xsw.writeEndDocument();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeElement(Element elem2, String newNamespace, String newName, XMLStreamWriter xsw) throws XMLStreamException {
        void var14_19;
        void var14_16;
        String prefix = null;
        String namespace = null;
        String localName = null;
        String nodeName = null;
        if (newName != null) {
            namespace = newNamespace;
            localName = newName;
            nodeName = newName;
            if (newNamespace != null && newNamespace.length() > 0) {
                NamespaceResolver tempNR = new NamespaceResolver();
                tempNR.setDOM(elem2);
                prefix = tempNR.resolveNamespaceURI(namespace);
                if (prefix == null || prefix.length() == 0) {
                    String defaultNamespace = elem2.getAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
                    prefix = defaultNamespace == null ? tempNR.generatePrefix() : (defaultNamespace != namespace ? tempNR.generatePrefix() : "");
                }
            }
        } else {
            prefix = elem2.getPrefix();
            namespace = elem2.getNamespaceURI();
            localName = elem2.getLocalName();
            nodeName = elem2.getNodeName();
        }
        String defaultNamespace = xsw.getNamespaceContext().getNamespaceURI("");
        boolean needToAddDefaultNS = false;
        if (prefix != null && prefix.length() > 0) {
            String namespaceURI = xsw.getNamespaceContext().getNamespaceURI(prefix);
            xsw.writeStartElement(prefix, localName, namespace);
            if (!namespace.equals(namespaceURI)) {
                xsw.writeNamespace(prefix, namespace);
            }
        } else if (namespace == null || namespace.length() == 0) {
            xsw.writeStartElement(nodeName);
            if (defaultNamespace != null && defaultNamespace.length() > 0) {
                xsw.writeDefaultNamespace("");
            }
        } else {
            needToAddDefaultNS = true;
            xsw.writeStartElement("", localName, namespace);
        }
        NodeList childNodes = elem2.getChildNodes();
        NamedNodeMap attrs = elem2.getAttributes();
        ArrayList<Object> nonNamespaceDeclAttrs = new ArrayList<Object>();
        boolean bl = false;
        while (var14_16 < attrs.getLength()) {
            Attr next2 = (Attr)attrs.item((int)var14_16);
            if (next2.getNodeType() == 2) {
                Object attribute = next2;
                if (next2.getPrefix() != null && next2.getPrefix().equals("xmlns")) {
                    String currentUri = xsw.getNamespaceContext().getNamespaceURI(next2.getLocalName());
                    if (currentUri == null || !currentUri.equals(next2.getValue())) {
                        xsw.writeNamespace(next2.getLocalName(), next2.getValue());
                    }
                } else if (next2.getName().equals("xmlns")) {
                    xsw.writeDefaultNamespace(next2.getValue());
                    needToAddDefaultNS = false;
                } else {
                    nonNamespaceDeclAttrs.add(attribute);
                }
            }
            ++var14_16;
        }
        if (needToAddDefaultNS && (defaultNamespace == null || !defaultNamespace.equals(namespace))) {
            xsw.writeDefaultNamespace(namespace);
        }
        for (Attr attr : nonNamespaceDeclAttrs) {
            if (attr.getPrefix() == null) {
                xsw.writeAttribute(attr.getName(), attr.getValue());
                continue;
            }
            xsw.writeAttribute(attr.getPrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getValue());
        }
        boolean bl2 = false;
        while (var14_19 < childNodes.getLength()) {
            Node next2 = childNodes.item((int)var14_19);
            if (next2.getNodeType() == 3) {
                xsw.writeCharacters(((Text)next2).getNodeValue());
            } else if (next2.getNodeType() == 4) {
                xsw.writeCData(next2.getNodeValue());
            } else if (next2.getNodeType() == 8) {
                xsw.writeComment(next2.getNodeValue());
            } else if (next2.getNodeType() == 1) {
                this.writeElement((Element)next2, null, null, xsw);
            }
            ++var14_19;
        }
        xsw.writeEndElement();
    }

    protected String getPrefix(NamespaceContext nc, Element elem2, String uri) {
        NamespaceResolver tempResovler = new NamespaceResolver();
        tempResovler.setDOM(elem2);
        String prefix = tempResovler.resolveNamespaceURI(uri);
        if (prefix == null || prefix.length() == 0) {
            prefix = tempResovler.generatePrefix();
        }
        return prefix;
    }
}

