/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.CompoundExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractColumnMapping;
import org.eclipse.persistence.queries.ReportQuery;

public class RelationExpression
extends CompoundExpression {
    protected Boolean isObjectComparisonExpression;

    protected boolean allChildrenAreFields() {
        return this.firstChild.getFields().size() == 1 && this.secondChild.getFields().size() == 1;
    }

    @Override
    protected void convertNodeToUseOuterJoin() {
        if (this.operator.getSelector() == 4 && this.allChildrenAreFields()) {
            this.setOperator(this.getOperator(6));
        }
    }

    @Override
    public String descriptionOfNodeType() {
        return "Relation";
    }

    @Override
    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        if (this.secondChild.getBuilder().getSession() == null || this.firstChild.getBuilder().getSession() == null) {
            throw QueryException.cannotConformExpression();
        }
        Object rightValue = this.secondChild.valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        Object leftValue = this.firstChild.valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        if (rightValue instanceof Collection) {
            if (this.operator.getSelector() == 13 || this.operator.getSelector() == 14) {
                if (this.isObjectComparison(session)) {
                    throw QueryException.cannotConformExpression();
                }
                if (leftValue instanceof Vector) {
                    return this.doesAnyOfLeftValuesConform((Vector)leftValue, rightValue, session);
                }
                return this.operator.doesRelationConform(leftValue, rightValue);
            }
            Enumeration rightEnum = ((Vector)rightValue).elements();
            while (rightEnum.hasMoreElements()) {
                Object tempRight = rightEnum.nextElement();
                if (leftValue instanceof Vector && this.doesAnyOfLeftValuesConform((Vector)leftValue, tempRight, session)) {
                    return true;
                }
                if (!this.doValuesConform(leftValue, tempRight, session)) continue;
                return true;
            }
            return false;
        }
        if (leftValue instanceof Vector) {
            return this.doesAnyOfLeftValuesConform((Vector)leftValue, rightValue, session);
        }
        return this.doValuesConform(leftValue, rightValue, session);
    }

    protected boolean doesAnyOfLeftValuesConform(Vector leftValues, Object rightValue, AbstractSession session) {
        int index2 = 0;
        while (index2 < leftValues.size()) {
            Object leftValue = leftValues.get(index2);
            if (this.doValuesConform(leftValue, rightValue, session)) {
                return true;
            }
            ++index2;
        }
        return false;
    }

    protected boolean doValuesConform(Object leftValue, Object rightValue, AbstractSession session) {
        if (this.isObjectComparison(session)) {
            return this.doesObjectConform(leftValue, rightValue, session);
        }
        return this.operator.doesRelationConform(leftValue, rightValue);
    }

    public boolean doesObjectConform(Object leftValue, Object rightValue, AbstractSession session) {
        if (leftValue == null && rightValue == null) {
            return this.performSelector(true);
        }
        if (leftValue == null || rightValue == null) {
            return this.performSelector(false);
        }
        Class<?> javaClass = leftValue.getClass();
        if (javaClass != rightValue.getClass()) {
            return this.performSelector(false);
        }
        ClassDescriptor descriptor = session.getDescriptor(javaClass);
        if (descriptor.isAggregateDescriptor()) {
            throw QueryException.cannotConformExpression();
        }
        Object leftPrimaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(leftValue, session);
        Object rightPrimaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(rightValue, session);
        return this.performSelector(leftPrimaryKey.equals(rightPrimaryKey));
    }

    @Override
    public boolean extractValues(boolean primaryKeyOnly, boolean requireExactMatch, ClassDescriptor descriptor, AbstractRecord primaryKeyRow, AbstractRecord translationRow) {
        if (requireExactMatch && this.operator.getSelector() != 4) {
            return false;
        }
        if (!requireExactMatch && this.operator.getSelector() == 13) {
            return false;
        }
        DatabaseField field2 = null;
        Object value2 = null;
        if (this.secondChild.isConstantExpression()) {
            value2 = ((ConstantExpression)this.secondChild).getValue();
        } else if (this.secondChild.isParameterExpression() && translationRow != null) {
            value2 = translationRow.get(((ParameterExpression)this.secondChild).getField());
        } else if (this.firstChild.isConstantExpression()) {
            value2 = ((ConstantExpression)this.firstChild).getValue();
        } else if (this.firstChild.isParameterExpression() && translationRow != null) {
            value2 = translationRow.get(((ParameterExpression)this.firstChild).getField());
        }
        if (value2 == null) {
            return false;
        }
        ClassDescriptor descriptorForChild = null;
        if (this.firstChild.isFieldExpression()) {
            FieldExpression child = (FieldExpression)this.firstChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            field2 = child.getField();
        } else if (this.firstChild.isQueryKeyExpression()) {
            DatabaseMapping mapping;
            QueryKeyExpression child = (QueryKeyExpression)this.firstChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            descriptorForChild = ((ExpressionBuilder)child.getBaseExpression()).getDescriptor();
            if (descriptorForChild == null) {
                descriptorForChild = descriptor;
            }
            if ((mapping = descriptorForChild.getObjectBuilder().getMappingForAttributeName(child.getName())) != null) {
                if (primaryKeyOnly && !mapping.isPrimaryKeyMapping()) {
                    return false;
                }
                if (mapping.isObjectReferenceMapping() || mapping.isAggregateObjectMapping()) {
                    mapping.writeFromAttributeIntoRow(value2, primaryKeyRow, this.getSession());
                    return true;
                }
                if (!mapping.isAbstractColumnMapping()) {
                    return false;
                }
                field2 = ((AbstractColumnMapping)mapping).getField();
            } else {
                field2 = descriptorForChild.getObjectBuilder().getFieldForQueryKeyName(child.getName());
            }
        } else if (this.secondChild.isFieldExpression()) {
            FieldExpression child = (FieldExpression)this.secondChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            field2 = child.getField();
        } else if (this.secondChild.isQueryKeyExpression()) {
            DatabaseMapping mapping;
            QueryKeyExpression child = (QueryKeyExpression)this.secondChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            descriptorForChild = ((ExpressionBuilder)child.getBaseExpression()).getDescriptor();
            if (descriptorForChild == null) {
                descriptorForChild = descriptor;
            }
            if ((mapping = descriptorForChild.getObjectBuilder().getMappingForAttributeName(child.getName())) != null) {
                if (primaryKeyOnly && !mapping.isPrimaryKeyMapping()) {
                    return false;
                }
                if (mapping.isObjectReferenceMapping() || mapping.isAggregateObjectMapping()) {
                    mapping.writeFromAttributeIntoRow(value2, primaryKeyRow, this.getSession());
                    return true;
                }
                if (!mapping.isAbstractColumnMapping()) {
                    return false;
                }
                field2 = ((AbstractColumnMapping)mapping).getField();
            } else {
                field2 = descriptorForChild.getObjectBuilder().getFieldForQueryKeyName(child.getName());
            }
        } else {
            return false;
        }
        if (field2 == null) {
            return false;
        }
        if (primaryKeyOnly && !descriptor.getPrimaryKeyFields().contains(field2)) {
            return descriptorForChild != null && descriptorForChild != descriptor && descriptorForChild.getPrimaryKeyFields().contains(field2);
        }
        if (primaryKeyRow.get(field2) != null) {
            return false;
        }
        primaryKeyRow.put(field2, value2);
        return true;
    }

    @Override
    public boolean extractFields(boolean requireExactMatch, boolean primaryKey, ClassDescriptor descriptor, List<DatabaseField> searchFields, Set<DatabaseField> foundFields) {
        if (requireExactMatch && this.operator.getSelector() != 4) {
            return false;
        }
        if (!requireExactMatch && this.operator.getSelector() == 13) {
            return false;
        }
        DatabaseField field2 = null;
        if (!(this.secondChild.isConstantExpression() || this.secondChild.isParameterExpression() || this.firstChild.isConstantExpression() || this.firstChild.isParameterExpression())) {
            return false;
        }
        if (this.firstChild.isFieldExpression()) {
            FieldExpression child = (FieldExpression)this.firstChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            field2 = child.getField();
        } else if (this.firstChild.isQueryKeyExpression()) {
            QueryKeyExpression child = (QueryKeyExpression)this.firstChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(child.getName());
            if (mapping != null) {
                if (primaryKey && !mapping.isPrimaryKeyMapping()) {
                    return false;
                }
                if (mapping.isObjectReferenceMapping() || mapping.isAggregateObjectMapping()) {
                    for (DatabaseField mappingField : mapping.getFields()) {
                        if (!searchFields.contains(mappingField)) continue;
                        foundFields.add(mappingField);
                    }
                    return true;
                }
                if (!mapping.isAbstractColumnMapping()) {
                    return false;
                }
                field2 = ((AbstractColumnMapping)mapping).getField();
            } else {
                field2 = descriptor.getObjectBuilder().getFieldForQueryKeyName(child.getName());
            }
        } else if (this.secondChild.isFieldExpression()) {
            FieldExpression child = (FieldExpression)this.secondChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            field2 = child.getField();
        } else if (this.secondChild.isQueryKeyExpression()) {
            QueryKeyExpression child = (QueryKeyExpression)this.secondChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(child.getName());
            if (mapping != null) {
                if (!mapping.isPrimaryKeyMapping()) {
                    return false;
                }
                if (mapping.isObjectReferenceMapping() || mapping.isAggregateObjectMapping()) {
                    for (DatabaseField mappingField : mapping.getFields()) {
                        if (!searchFields.contains(mappingField)) continue;
                        foundFields.add(mappingField);
                    }
                    return true;
                }
                if (!mapping.isAbstractColumnMapping()) {
                    return false;
                }
                field2 = ((AbstractColumnMapping)mapping).getField();
            } else {
                field2 = descriptor.getObjectBuilder().getFieldForQueryKeyName(child.getName());
            }
        } else {
            return false;
        }
        if (field2 == null || !searchFields.contains(field2)) {
            return false;
        }
        foundFields.add(field2);
        return true;
    }

    public boolean isEqualNull(ExpressionSQLPrinter printer) {
        if (this.isObjectComparison(printer.getSession())) {
            return false;
        }
        if (this.operator.getSelector() != 4) {
            return false;
        }
        if (this.secondChild.isConstantExpression() && ((ConstantExpression)this.secondChild).getValue() == null) {
            return true;
        }
        return this.secondChild.isParameterExpression() && printer.getTranslationRow() != null && ((ParameterExpression)this.secondChild).getValue(printer.getTranslationRow(), printer.getSession()) == null;
    }

    public boolean isNotEqualNull(ExpressionSQLPrinter printer) {
        if (this.isObjectComparison(printer.getSession())) {
            return false;
        }
        if (this.operator.getSelector() != 5) {
            return false;
        }
        if (this.secondChild.isConstantExpression() && ((ConstantExpression)this.secondChild).getValue() == null) {
            return true;
        }
        return this.secondChild.isParameterExpression() && printer.getTranslationRow() != null && ((ParameterExpression)this.secondChild).getValue(printer.getTranslationRow(), printer.getSession()) == null;
    }

    protected boolean isObjectComparison(AbstractSession session) {
        if (this.isObjectComparisonExpression == null) {
            DatabaseMapping mapping;
            if (this.firstChild.getBuilder().getSession() == null) {
                this.firstChild.getBuilder().setSession(session.getRootSession(null));
            }
            if (this.secondChild.getBuilder().getSession() == null) {
                this.secondChild.getBuilder().setSession(session.getRootSession(null));
            }
            this.isObjectComparisonExpression = !this.firstChild.isObjectExpression() || ((ObjectExpression)this.firstChild).isAttribute() ? (this.secondChild.isObjectExpression() && !((ObjectExpression)this.secondChild).isAttribute() ? ((mapping = ((ObjectExpression)this.secondChild).getMapping()) != null && mapping.isDirectCollectionMapping() && !this.secondChild.isMapEntryExpression() ? Boolean.FALSE : Boolean.valueOf(this.firstChild.isObjectExpression() || this.firstChild.isValueExpression() || this.firstChild.isSubSelectExpression() || this.firstChild.isFunctionExpression() && ((FunctionExpression)this.firstChild).operator.isAnyOrAll())) : Boolean.FALSE) : ((mapping = ((ObjectExpression)this.firstChild).getMapping()) != null && mapping.isDirectCollectionMapping() && !this.firstChild.isMapEntryExpression() ? Boolean.FALSE : Boolean.valueOf(this.secondChild.isObjectExpression() || this.secondChild.isValueExpression() || this.secondChild.isSubSelectExpression() || this.secondChild.isFunctionExpression() && ((FunctionExpression)this.secondChild).operator.isAnyOrAll()));
        }
        return this.isObjectComparisonExpression;
    }

    @Override
    public boolean isRelationExpression() {
        return true;
    }

    protected Expression checkForeignKeyJoinOptimization(Expression first, Expression second, ExpressionNormalizer normalizer) {
        if (first.isQueryKeyExpression() && ((QueryKeyExpression)first).getBaseExpression() != null && ((QueryKeyExpression)first).getBaseExpression().isQueryKeyExpression()) {
            if (normalizer.getStatement().isSubSelect() && normalizer.getStatement().getParentStatement().getBuilder().equals(first.getBuilder())) {
                return null;
            }
            QueryKeyExpression mappingExpression = (QueryKeyExpression)((QueryKeyExpression)first).getBaseExpression();
            if (mappingExpression.getBaseExpression() != null && mappingExpression.getBaseExpression().isObjectExpression() && !mappingExpression.shouldUseOuterJoin()) {
                mappingExpression.getBaseExpression().normalize(normalizer);
                DatabaseMapping mapping = mappingExpression.getMapping();
                if (mapping != null && mapping.isOneToOneMapping() && !((OneToOneMapping)mapping).hasCustomSelectionQuery() && ((OneToOneMapping)mapping).isForeignKeyRelationship() && (second.isConstantExpression() || second.isParameterExpression())) {
                    DatabaseField targetField = ((QueryKeyExpression)first).getField();
                    DatabaseField sourceField = ((OneToOneMapping)mapping).getTargetToSourceKeyFields().get(targetField);
                    if (sourceField != null) {
                        Expression optimizedExpression = this.operator.expressionFor(mappingExpression.getBaseExpression().getField(sourceField), second);
                        second.setLocalBase(first);
                        return optimizedExpression.normalize(normalizer);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        Expression optimizedExpression = this.checkForeignKeyJoinOptimization(this.firstChild, this.secondChild, normalizer);
        if (optimizedExpression == null) {
            optimizedExpression = this.checkForeignKeyJoinOptimization(this.secondChild, this.firstChild, normalizer);
        }
        if (optimizedExpression != null) {
            return optimizedExpression;
        }
        if (!this.isObjectComparison(normalizer.getSession())) {
            return super.normalize(normalizer);
        }
        this.validateNode();
        if (this.operator.getSelector() != 4 && this.operator.getSelector() != 5 && this.operator.getSelector() != 13 && this.operator.getSelector() != 14) {
            throw QueryException.invalidOperatorForObjectComparison(this);
        }
        if (this.operator.getSelector() == 13 || this.operator.getSelector() == 14) {
            Expression left = this.firstChild;
            if (!left.isObjectExpression()) {
                throw QueryException.invalidExpression(this);
            }
            DatabaseMapping mapping = null;
            if (left.isQueryKeyExpression()) {
                ((ObjectExpression)left).getBaseExpression().normalize(normalizer);
                mapping = ((ObjectExpression)left).getMapping();
            }
            ClassDescriptor descriptor = null;
            List<DatabaseField> sourceFields = null;
            List<DatabaseField> targetFields = null;
            if (mapping != null && mapping.isOneToOneMapping() && !((OneToOneMapping)mapping).hasRelationTableMechanism() && !((OneToOneMapping)mapping).hasCustomSelectionQuery()) {
                left = ((ObjectExpression)left).getBaseExpression();
                descriptor = mapping.getReferenceDescriptor();
                left = left.normalize(normalizer);
                Map<DatabaseField, DatabaseField> targetToSourceKeyFields = ((OneToOneMapping)mapping).getTargetToSourceKeyFields();
                sourceFields = new ArrayList<DatabaseField>(targetToSourceKeyFields.size());
                targetFields = new ArrayList<DatabaseField>(targetToSourceKeyFields.size());
                for (Map.Entry<DatabaseField, DatabaseField> entry2 : targetToSourceKeyFields.entrySet()) {
                    sourceFields.add(entry2.getValue());
                    targetFields.add(entry2.getKey());
                }
            } else {
                mapping = null;
                left = left.normalize(normalizer);
                descriptor = ((ObjectExpression)left).getDescriptor();
                targetFields = sourceFields = descriptor.getPrimaryKeyFields();
            }
            boolean composite = sourceFields.size() > 1;
            DatabaseField sourceField = sourceFields.get(0);
            DatabaseField targetField = targetFields.get(0);
            Expression newLeft = null;
            if (composite) {
                ArrayList<Expression> fieldExpressions = new ArrayList<Expression>();
                for (DatabaseField field2 : sourceFields) {
                    fieldExpressions.add(left.getField(field2));
                }
                newLeft = this.getBuilder().value(sourceFields);
            } else {
                newLeft = left.getField(sourceField);
            }
            this.setFirstChild(newLeft);
            Expression right = this.secondChild;
            if (right.isConstantExpression()) {
                ConstantExpression constant = (ConstantExpression)right;
                if (!(constant.getValue() instanceof Collection)) throw QueryException.invalidExpression(this);
                Collection objects = (Collection)constant.getValue();
                ArrayList<void> newObjects = new ArrayList<void>(objects.size());
                for (Object e : objects) {
                    void var16_36;
                    ArrayList<Object> values;
                    if (e instanceof Expression) {
                        if (composite) {
                            values = new ArrayList<Object>();
                            for (DatabaseField field3 : targetFields) {
                                values.add(((Expression)e).getField(field3));
                            }
                            Expression expression = this.getBuilder().value(values);
                        } else {
                            Expression expression = ((Expression)e).getField(targetField);
                        }
                    } else if (descriptor.getJavaClass().isInstance(e)) {
                        if (composite) {
                            values = new ArrayList();
                            for (DatabaseField field3 : targetFields) {
                                values.add(descriptor.getObjectBuilder().extractValueFromObjectForField(e, field3, normalizer.getSession()));
                            }
                            Expression expression = this.getBuilder().value(values);
                        } else {
                            Object object = descriptor.getObjectBuilder().extractValueFromObjectForField(e, targetField, normalizer.getSession());
                        }
                    }
                    newObjects.add(var16_36);
                }
                constant.setValue(newObjects);
                return super.normalize(normalizer);
            } else {
                if (right.isParameterExpression()) return super.normalize(normalizer);
                throw QueryException.invalidExpression(this);
            }
        }
        ObjectExpression first = null;
        Expression second = null;
        if (this.firstChild.isObjectExpression()) {
            first = (ObjectExpression)this.firstChild;
            second = this.secondChild;
        } else {
            first = (ObjectExpression)this.secondChild;
            second = this.firstChild;
        }
        if (second.isFunctionExpression()) {
            FunctionExpression funcExp = (FunctionExpression)second;
            if (funcExp.operator.isAnyOrAll()) {
                Expression newExp;
                SubSelectExpression subSelectExp = (SubSelectExpression)funcExp.getChildren().get(1);
                ReportQuery subQuery = subSelectExp.getSubQuery();
                subQuery.getItems().clear();
                subQuery.addItem("one", new ConstantExpression(1, subQuery.getExpressionBuilder()));
                Expression subSelectCriteria = subQuery.getSelectionCriteria();
                ExpressionBuilder subBuilder = subQuery.getExpressionBuilder();
                ExpressionBuilder builder = first.getBuilder();
                if (funcExp.operator.isAny()) {
                    subSelectCriteria = this.operator.getSelector() == 4 ? subBuilder.equal(first).and(subSelectCriteria) : subBuilder.notEqual(first).and(subSelectCriteria);
                    subQuery.setSelectionCriteria(subSelectCriteria);
                    newExp = builder.exists(subQuery);
                    return newExp.normalize(normalizer);
                } else {
                    subSelectCriteria = this.operator.getSelector() == 4 ? subBuilder.notEqual(first).and(subSelectCriteria) : subBuilder.equal(first).and(subSelectCriteria);
                    subQuery.setSelectionCriteria(subSelectCriteria);
                    newExp = builder.notExists(subQuery);
                }
                return newExp.normalize(normalizer);
            }
        } else if (second.isSubSelectExpression()) {
            SubSelectExpression subSelectExp = (SubSelectExpression)second;
            ReportQuery subQuery = subSelectExp.getSubQuery();
            subQuery.getItems().clear();
            subQuery.addItem("one", new ConstantExpression(1, subQuery.getExpressionBuilder()));
            Expression subSelectCriteria = subQuery.getSelectionCriteria();
            ExpressionBuilder subBuilder = subQuery.getExpressionBuilder();
            ExpressionBuilder builder = first.getBuilder();
            subSelectCriteria = this.operator.getSelector() == 4 ? subBuilder.equal(first).and(subSelectCriteria) : subBuilder.notEqual(first).and(subSelectCriteria);
            subQuery.setSelectionCriteria(subSelectCriteria);
            Expression newExp = builder.exists(subQuery);
            return newExp.normalize(normalizer);
        }
        Expression foreignKeyJoin = null;
        if (first.isExpressionBuilder() && second.isQueryKeyExpression() && !((QueryKeyExpression)second).hasDerivedExpressions() && normalizer.getSession().getPlatform().shouldPrintInnerJoinInWhereClause()) {
            first = (ExpressionBuilder)first.normalize(normalizer);
            ArrayList<Expression> foreignKeyJoinPointer = new ArrayList<Expression>(1);
            QueryKeyExpression queryKey = (QueryKeyExpression)second;
            if (queryKey.hasBeenNormalized()) {
                queryKey.setHasBeenNormalized(false);
            }
            queryKey = (QueryKeyExpression)queryKey.normalize(normalizer, first, foreignKeyJoinPointer);
            if (!foreignKeyJoinPointer.isEmpty()) {
                foreignKeyJoin = (Expression)foreignKeyJoinPointer.get(0);
                if (first.getTableAliases() == null) {
                    TableAliasLookup tableAliases = new TableAliasLookup();
                    first.setTableAliases(tableAliases);
                    queryKey.setTableAliases(tableAliases);
                } else {
                    queryKey.setTableAliases(first.getTableAliases());
                }
            }
        } else if (!first.isExpressionBuilder() && !((QueryKeyExpression)first).shouldQueryToManyRelationship() && ((QueryKeyExpression)first).getMapping() != null) {
            if (first.getBaseExpression() != null) {
                first.setBaseExpression(first.getBaseExpression().normalize(normalizer));
            }
            if (second.isConstantExpression()) {
                Object targetObject = ((ConstantExpression)second).getValue();
                foreignKeyJoin = first.getMapping().buildObjectJoinExpression((Expression)first, targetObject, this.getSession());
            } else {
                if (!second.isObjectExpression() && !second.isParameterExpression()) throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
                foreignKeyJoin = first.getMapping().buildObjectJoinExpression((Expression)first, second, this.getSession());
            }
        }
        if (foreignKeyJoin == null) {
            first = (ObjectExpression)first.normalize(normalizer);
            if (second.isConstantExpression()) {
                Object value2 = ((ConstantExpression)second).getValue();
                Expression keyExpression = first.getDescriptor().getObjectBuilder().buildPrimaryKeyExpressionFromObject(value2, this.getSession());
                foreignKeyJoin = first.twist(keyExpression, first);
            } else {
                if (!second.isObjectExpression() && !second.isParameterExpression()) throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
                foreignKeyJoin = first.twist(first.getDescriptor().getObjectBuilder().getPrimaryKeyExpression(), second);
            }
        }
        if (this.operator.getSelector() != 5) return foreignKeyJoin.normalize(normalizer);
        foreignKeyJoin = foreignKeyJoin.not();
        return foreignKeyJoin.normalize(normalizer);
    }

    public boolean performSelector(boolean areValuesEqual) {
        if (this.operator.getSelector() == 4) {
            return areValuesEqual;
        }
        if (this.operator.getSelector() == 5) {
            return !areValuesEqual;
        }
        throw QueryException.cannotConformExpression();
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        if (printer.getPlatform().isDynamicSQLRequiredForFunctions() && (this.firstChild.isParameterExpression() || this.firstChild.isConstantExpression()) && (this.secondChild.isParameterExpression() || this.secondChild.isConstantExpression())) {
            printer.getCall().setUsesBinding(false);
        }
        if (this.isEqualNull(printer)) {
            this.firstChild.isNull().printSQL(printer);
        } else if (this.isNotEqualNull(printer)) {
            this.firstChild.notNull().printSQL(printer);
        } else {
            super.printSQL(printer);
        }
    }

    @Override
    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        Expression tempFirstChild = this.firstChild;
        Expression tempSecondChild = this.secondChild;
        realOperator.printJavaDuo(tempFirstChild, tempSecondChild, printer);
    }

    public void printSQLNoParens(ExpressionSQLPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printDuo(this.firstChild, this.secondChild, printer);
    }

    @Override
    public void validateNode() {
        if (this.firstChild.isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.firstChild).getTable());
        }
        if (this.secondChild.isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.secondChild).getTable());
        }
    }
}

