/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class ForUpdateOfClause
extends ForUpdateClause {
    protected List<Expression> lockedExpressions;

    public void addLockedExpression(ObjectExpression expression) {
        this.getLockedExpressions().add(expression);
    }

    public void addLockedExpression(FieldExpression expression) {
        this.getLockedExpressions().add(expression);
    }

    public List<Expression> getLockedExpressions() {
        if (this.lockedExpressions == null) {
            this.lockedExpressions = new ArrayList<Expression>();
        }
        return this.lockedExpressions;
    }

    @Override
    public boolean isForUpdateOfClause() {
        return true;
    }

    @Override
    public boolean isReferenceClassLocked() {
        if (this.lockedExpressions == null) {
            return false;
        }
        int size2 = this.lockedExpressions.size();
        int i = 0;
        while (i < size2) {
            if (this.lockedExpressions.get(i).isExpressionBuilder()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setLockedExpressions(List<Expression> lockedExpressions) {
        this.lockedExpressions = lockedExpressions;
    }

    public void setLockMode(short lockMode) {
        this.lockMode = lockMode;
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        if (printer.getSession().getPlatform().shouldPrintLockingClauseAfterWhereClause()) {
            ExpressionBuilder clonedBuilder = statement.getBuilder();
            printer.printString(printer.getSession().getPlatform().getSelectForUpdateOfString());
            printer.setIsFirstElementPrinted(false);
            for (Expression next2 : this.getLockedExpressions()) {
                if ((next2 = next2.rebuildOn(clonedBuilder)).isObjectExpression()) {
                    ObjectExpression objectExp = (ObjectExpression)next2;
                    objectExp.writeForUpdateOfFields(printer, statement);
                    continue;
                }
                FieldExpression fieldExp = (FieldExpression)next2;
                fieldExp.writeForUpdateOf(printer, statement);
            }
            if (this.lockMode == 2) {
                printer.printString(printer.getSession().getPlatform().getNoWaitString());
            }
        } else {
            super.printSQL(printer, statement);
        }
    }

    @Override
    public Collection getAliasesOfTablesToBeLocked(SQLSelectStatement statement) {
        int expected = statement.getTableAliases().size();
        HashSet<DatabaseTable> aliases = new HashSet<DatabaseTable>(expected);
        ExpressionBuilder clonedBuilder = statement.getBuilder();
        Iterator<Expression> iterator2 = this.getLockedExpressions().iterator();
        while (iterator2.hasNext() && aliases.size() < expected) {
            Expression next2 = iterator2.next();
            if ((next2 = next2.rebuildOn(clonedBuilder)).isFieldExpression()) {
                next2 = ((FieldExpression)next2).getBaseExpression();
            }
            DatabaseTable[] expAliases = next2.getTableAliases().keys();
            int i = 0;
            while (i < expAliases.length) {
                aliases.add(expAliases[i]);
                ++i;
            }
        }
        return aliases;
    }
}

