/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.mappings;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.eis.EISCollectionChangeRecord;
import org.eclipse.persistence.eis.EISOrderedCollectionChangeRecord;
import org.eclipse.persistence.eis.mappings.EISOneToManyMapping;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class EISOneToManyMappingHelper {
    private EISOneToManyMapping mapping;
    private static Object XXX = new Object();

    public EISOneToManyMappingHelper(EISOneToManyMapping mapping) {
        this.mapping = mapping;
    }

    private Object buildAddedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return this.getMapping().buildAddedElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    private Object buildChangeSet(Object element, ObjectChangeSet owner, AbstractSession session) {
        return this.getMapping().buildChangeSet(element, owner, session);
    }

    private Object buildElementFromElement(Object element, MergeManager mergeManager, AbstractSession targetSession) {
        return this.getMapping().buildElementFromElement(element, mergeManager, targetSession);
    }

    private Object buildRemovedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return this.getMapping().buildRemovedElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    private boolean compareAttributeValues(Object collection1, Object collection2, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.sizeFor(collection1) != cp.sizeFor(collection2)) {
            return false;
        }
        if (cp.sizeFor(collection1) == 0) {
            return true;
        }
        if (cp.hasOrder()) {
            return this.compareAttributeValuesWithOrder(collection1, collection2, session);
        }
        return this.compareAttributeValuesWithoutOrder(collection1, collection2, session);
    }

    private ChangeRecord compareAttributeValuesForChangeWithOrder(Object cloneCollection, Object backupCollection, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Vector cloneVector = cp.vectorFor(cloneCollection, session);
        Vector backupVector = cp.vectorFor(backupCollection, session);
        EISOrderedCollectionChangeRecord changeRecord = new EISOrderedCollectionChangeRecord(owner, this.getAttributeName(), this.getDatabaseMapping());
        int i = 0;
        while (i < cloneVector.size()) {
            Object cloneElement = cloneVector.get(i);
            boolean found = false;
            int j = 0;
            while (j < backupVector.size()) {
                if (this.compareElementsForChange(cloneElement, backupVector.get(j), session)) {
                    found = true;
                    backupVector.set(j, XXX);
                    changeRecord.addMovedChangeSet(this.buildChangeSet(cloneElement, owner, session), j, i);
                    break;
                }
                ++j;
            }
            if (!found) {
                changeRecord.addAddedChangeSet(this.buildChangeSet(cloneElement, owner, session), i);
            }
            ++i;
        }
        i = 0;
        while (i < backupVector.size()) {
            Object backupElement = backupVector.get(i);
            if (backupElement != XXX) {
                changeRecord.addRemovedChangeSet(this.buildChangeSet(backupElement, owner, session), i);
            }
            ++i;
        }
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    private ChangeRecord compareAttributeValuesForChangeWithoutOrder(Object cloneCollection, Object backupCollection, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Vector backupVector = cp.vectorFor(backupCollection, session);
        EISCollectionChangeRecord changeRecord = new EISCollectionChangeRecord(owner, this.getAttributeName(), this.getDatabaseMapping());
        Object cloneIter = cp.iteratorFor(cloneCollection);
        while (cp.hasNext(cloneIter)) {
            Object cloneElement = cp.next(cloneIter, session);
            boolean found = false;
            int i = 0;
            while (i < backupVector.size()) {
                if (this.compareElementsForChange(cloneElement, backupVector.get(i), session)) {
                    found = true;
                    backupVector.set(i, XXX);
                    if (!this.mapKeyHasChanged(cloneElement, session)) break;
                    changeRecord.addChangedMapKeyChangeSet(this.buildChangeSet(cloneElement, owner, session));
                    break;
                }
                ++i;
            }
            if (found) continue;
            changeRecord.addAddedChangeSet(this.buildChangeSet(cloneElement, owner, session));
        }
        int i = 0;
        while (i < backupVector.size()) {
            Object backupElement = backupVector.get(i);
            if (backupElement != XXX) {
                changeRecord.addRemovedChangeSet(this.buildChangeSet(backupElement, owner, session));
            }
            ++i;
        }
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    private boolean compareAttributeValuesWithOrder(Object collection1, Object collection2, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter1 = cp.iteratorFor(collection1);
        Object iter2 = cp.iteratorFor(collection2);
        while (cp.hasNext(iter1)) {
            if (this.compareElements(cp.next(iter1, session), cp.next(iter2, session), session)) continue;
            return false;
        }
        return true;
    }

    private boolean compareAttributeValuesWithoutOrder(Object collection1, Object collection2, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Vector vector2 = cp.vectorFor(collection2, session);
        Object iter1 = cp.iteratorFor(collection1);
        while (cp.hasNext(iter1)) {
            Object element1 = cp.next(iter1, session);
            boolean found = false;
            int i = 0;
            while (i < vector2.size()) {
                if (this.compareElements(element1, vector2.get(i), session)) {
                    found = true;
                    vector2.set(i, XXX);
                    break;
                }
                ++i;
            }
            if (found) continue;
            return false;
        }
        for (Object value2 : vector2) {
            if (value2 == XXX) continue;
            return false;
        }
        return true;
    }

    private boolean compareElements(Object element1, Object element2, AbstractSession session) {
        if (element1 == null && element2 == null) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        if (element2 == XXX) {
            return false;
        }
        return this.getMapping().compareElements(element1, element2, session);
    }

    private boolean compareElementsForChange(Object element1, Object element2, AbstractSession session) {
        if (element1 == null && element2 == null) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        if (element2 == XXX) {
            return false;
        }
        return this.getMapping().compareElementsForChange(element1, element2, session);
    }

    public ChangeRecord compareForChange(Object clone2, Object backup, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneCollection = this.getRealCollectionAttributeValueFromObject(clone2, session);
        Object backupCollection = null;
        backupCollection = owner.isNew() ? cp.containerInstance(1) : this.getRealCollectionAttributeValueFromObject(backup, session);
        if (cp.hasOrder()) {
            return this.compareAttributeValuesForChangeWithOrder(cloneCollection, backupCollection, owner, session);
        }
        return this.compareAttributeValuesForChangeWithoutOrder(cloneCollection, backupCollection, owner, session);
    }

    public boolean compareObjects(Object object1, Object object2, AbstractSession session) {
        return this.compareAttributeValues(this.getRealCollectionAttributeValueFromObject(object1, session), this.getRealCollectionAttributeValueFromObject(object2, session), session);
    }

    private String getAttributeName() {
        return this.getMapping().getAttributeName();
    }

    private ContainerPolicy getContainerPolicy() {
        return this.getMapping().getContainerPolicy();
    }

    public DatabaseMapping getDatabaseMapping() {
        return this.getMapping();
    }

    public EISOneToManyMapping getMapping() {
        return this.mapping;
    }

    private Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession session) {
        return this.getMapping().getRealCollectionAttributeValueFromObject(object, session);
    }

    private boolean mapKeyHasChanged(Object element, AbstractSession session) {
        return this.getMapping().mapKeyHasChanged(element, session);
    }

    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.getContainerPolicy().hasOrder()) {
            this.mergeChangesIntoObjectWithOrder(target, changeRecord, source, mergeManager, targetSession);
        } else {
            this.mergeChangesIntoObjectWithoutOrder(target, changeRecord, source, mergeManager, targetSession);
        }
    }

    private void mergeChangesIntoObjectWithOrder(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        ContainerPolicy cp = this.getContainerPolicy();
        AbstractSession session = mergeManager.getSession();
        List changes = ((EISOrderedCollectionChangeRecord)changeRecord).getNewCollection();
        Object targetCollection = cp.containerInstance(changes.size());
        for (Object changed : changes) {
            Object targetElement = this.buildAddedElementFromChangeSet(changed, mergeManager, targetSession);
            cp.addInto(targetElement, targetCollection, session);
        }
        this.setRealAttributeValueInObject(target, targetCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeChangesIntoObjectWithoutOrder(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        EISCollectionChangeRecord sdkChangeRecord = (EISCollectionChangeRecord)changeRecord;
        ContainerPolicy cp = this.getContainerPolicy();
        AbstractSession session = mergeManager.getSession();
        Object targetCollection = null;
        targetCollection = sdkChangeRecord.getOwner().isNew() ? cp.containerInstance(sdkChangeRecord.getAdds().size()) : this.getRealCollectionAttributeValueFromObject(target, session);
        List removes = sdkChangeRecord.getRemoves();
        List adds = sdkChangeRecord.getAdds();
        List changedMapKeys = sdkChangeRecord.getChangedMapKeys();
        Object object = targetCollection;
        synchronized (object) {
            for (Object removed : removes) {
                Object removeElement = this.buildRemovedElementFromChangeSet(removed, mergeManager, targetSession);
                Object targetElement = null;
                Object iter2 = cp.iteratorFor(targetCollection);
                while (cp.hasNext(iter2)) {
                    targetElement = cp.next(iter2, session);
                    if (this.compareElements(targetElement, removeElement, session)) break;
                }
                if (targetElement == null) continue;
                cp.removeFrom(targetElement, targetCollection, session);
            }
            for (Object added : adds) {
                Object addElement = this.buildAddedElementFromChangeSet(added, mergeManager, targetSession);
                cp.addInto(addElement, targetCollection, session);
            }
            for (Object changed : changedMapKeys) {
                Object changedMapKeyElement = this.buildAddedElementFromChangeSet(changed, mergeManager, targetSession);
                Object originalElement = ((UnitOfWorkImpl)session).getOriginalVersionOfObject(changedMapKeyElement);
                cp.removeFrom(originalElement, targetCollection, session);
                cp.addInto(changedMapKeyElement, targetCollection, session);
            }
        }
        this.setRealAttributeValueInObject(target, targetCollection);
    }

    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        ContainerPolicy cp = this.getContainerPolicy();
        AbstractSession session = mergeManager.getSession();
        Object sourceCollection = this.getRealCollectionAttributeValueFromObject(source, session);
        Object targetCollection = cp.containerInstance(cp.sizeFor(sourceCollection));
        Object iter2 = cp.iteratorFor(sourceCollection);
        while (cp.hasNext(iter2)) {
            Object targetElement = this.buildElementFromElement(cp.next(iter2, session), mergeManager, targetSession);
            cp.addInto(targetElement, targetCollection, session);
        }
        this.setRealAttributeValueInObject(target, targetCollection);
    }

    private void setRealAttributeValueInObject(Object object, Object attributeValue) {
        this.getMapping().setRealAttributeValueInObject(object, attributeValue);
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        if (this.getContainerPolicy().hasOrder()) {
            this.simpleAddToCollectionChangeRecordWithOrder(referenceKey, changeSetToAdd, changeSet, session);
        } else {
            this.simpleAddToCollectionChangeRecordWithoutOrder(referenceKey, changeSetToAdd, changeSet, session);
        }
    }

    private void simpleAddToCollectionChangeRecordWithOrder(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        EISOrderedCollectionChangeRecord changeRecord = (EISOrderedCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            changeRecord = new EISOrderedCollectionChangeRecord(changeSet, this.getAttributeName(), this.getDatabaseMapping());
            changeSet.addChange(changeRecord);
        }
        changeRecord.simpleAddChangeSet(changeSetToAdd);
    }

    private void simpleAddToCollectionChangeRecordWithoutOrder(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        EISCollectionChangeRecord changeRecord = (EISCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            changeRecord = new EISCollectionChangeRecord(changeSet, this.getAttributeName(), this.getDatabaseMapping());
            changeSet.addChange(changeRecord);
        }
        changeRecord.simpleAddChangeSet(changeSetToAdd);
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        if (this.getContainerPolicy().hasOrder()) {
            this.simpleRemoveFromCollectionChangeRecordWithOrder(referenceKey, changeSetToRemove, changeSet, session);
        } else {
            this.simpleRemoveFromCollectionChangeRecordWithoutOrder(referenceKey, changeSetToRemove, changeSet, session);
        }
    }

    private void simpleRemoveFromCollectionChangeRecordWithOrder(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        EISOrderedCollectionChangeRecord changeRecord = (EISOrderedCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            changeRecord = new EISOrderedCollectionChangeRecord(changeSet, this.getAttributeName(), this.getDatabaseMapping());
            changeSet.addChange(changeRecord);
        }
        changeRecord.simpleRemoveChangeSet(changeSetToRemove);
    }

    private void simpleRemoveFromCollectionChangeRecordWithoutOrder(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        EISCollectionChangeRecord changeRecord = (EISCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            changeRecord = new EISCollectionChangeRecord(changeSet, this.getAttributeName(), this.getDatabaseMapping());
            changeSet.addChange(changeRecord);
        }
        changeRecord.simpleRemoveChangeSet(changeSetToRemove);
    }
}

