/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.changetracking;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;

public class DeferredChangeDetectionPolicy
implements ObjectChangePolicy,
Serializable {
    @Override
    public ObjectChangeSet calculateChangesForNewObject(Object clone2, UnitOfWorkChangeSet changeSet, UnitOfWorkImpl unitOfWork, ClassDescriptor descriptor, boolean shouldRaiseEvent) {
        return this.calculateChanges(clone2, null, true, changeSet, unitOfWork, descriptor, shouldRaiseEvent);
    }

    @Override
    public ObjectChangeSet calculateChangesForExistingObject(Object clone2, UnitOfWorkChangeSet changeSet, UnitOfWorkImpl unitOfWork, ClassDescriptor descriptor, boolean shouldRaiseEvent) {
        return this.calculateChanges(clone2, unitOfWork.getBackupClone(clone2, descriptor), false, changeSet, unitOfWork, descriptor, shouldRaiseEvent);
    }

    @Override
    public ObjectChangeSet calculateChanges(Object clone2, Object backUp, boolean isNew, UnitOfWorkChangeSet changeSet, UnitOfWorkImpl unitOfWork, ClassDescriptor descriptor, boolean shouldRaiseEvent) {
        ObjectChangeSet changes;
        if (descriptor.getEventManager().hasAnyEventListeners() && shouldRaiseEvent) {
            WriteObjectQuery writeQuery = new WriteObjectQuery(clone2.getClass());
            writeQuery.setObject(clone2);
            writeQuery.setBackupClone(backUp);
            writeQuery.setSession(unitOfWork);
            writeQuery.setDescriptor(descriptor);
            descriptor.getEventManager().executeEvent(new DescriptorEvent(0, writeQuery));
            if (isNew) {
                descriptor.getEventManager().executeEvent(new DescriptorEvent(4, writeQuery));
            } else {
                descriptor.getEventManager().executeEvent(new DescriptorEvent(6, writeQuery));
            }
        }
        if ((changes = this.createObjectChangeSet(clone2, backUp, changeSet, isNew, unitOfWork, descriptor)).hasChanges() && descriptor.hasMappingsPostCalculateChanges() && !changes.isNew() && !unitOfWork.getCommitManager().isActive() && !unitOfWork.isNestedUnitOfWork()) {
            int size2 = descriptor.getMappingsPostCalculateChanges().size();
            int i = 0;
            while (i < size2) {
                DatabaseMapping mapping = descriptor.getMappingsPostCalculateChanges().get(i);
                ChangeRecord record = changes.getChangesForAttributeNamed(mapping.getAttributeName());
                if (record != null) {
                    mapping.postCalculateChanges(record, unitOfWork);
                }
                ++i;
            }
        }
        if (!(changes.getId() != null || isNew || changes.isAggregate() || unitOfWork.isNestedUnitOfWork() && (!unitOfWork.isNestedUnitOfWork() || unitOfWork.isNewObjectInParent(clone2) || unitOfWork.isUnregisteredNewObjectInParent(unitOfWork.getCloneToOriginals().get(clone2))))) {
            Object id = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(clone2, unitOfWork, false);
            throw ValidationException.nullPrimaryKeyInUnitOfWorkClone(clone2, id);
        }
        if (descriptor.getCMPPolicy() != null && descriptor.getCMPPolicy().getForceUpdate()) {
            changes.setHasCmpPolicyForcedUpdate(true);
        }
        if (!changes.hasForcedChangesFromCascadeLocking() && unitOfWork.hasOptimisticReadLockObjects()) {
            Boolean modifyVersionField = (Boolean)unitOfWork.getOptimisticReadLockObjects().get(clone2);
            if (modifyVersionField != null && unitOfWork instanceof RepeatableWriteUnitOfWork && ((RepeatableWriteUnitOfWork)unitOfWork).getCumulativeUOWChangeSet() != null && ((RepeatableWriteUnitOfWork)unitOfWork).getCumulativeUOWChangeSet().getObjectChangeSetForClone(clone2) == null) {
                modifyVersionField = Boolean.TRUE;
            }
            changes.setShouldModifyVersionField(modifyVersionField);
        }
        if (changes.hasChanges() || changes.hasForcedChanges()) {
            return changes;
        }
        return null;
    }

    @Override
    public void clearChanges(Object object, UnitOfWorkImpl uow, ClassDescriptor descriptor, boolean forRefresh) {
    }

    public ObjectChangeSet createObjectChangeSet(Object clone2, Object backUp, UnitOfWorkChangeSet changeSet, boolean isNew, AbstractSession session, ClassDescriptor descriptor) {
        return this.createObjectChangeSetThroughComparison(clone2, backUp, changeSet, isNew, session, descriptor);
    }

    @Override
    public ObjectChangeSet createObjectChangeSetThroughComparison(Object clone2, Object backUp, UnitOfWorkChangeSet changeSet, boolean isNew, AbstractSession session, ClassDescriptor descriptor) {
        ObjectBuilder builder = descriptor.getObjectBuilder();
        ObjectChangeSet changes = builder.createObjectChangeSet(clone2, changeSet, isNew, true, session);
        FetchGroup fetchGroup = null;
        boolean shouldGetFetchGroup = true;
        if (descriptor.usesOptimisticLocking() && changes.getId() != null) {
            if (descriptor.hasFetchGroupManager()) {
                fetchGroup = descriptor.getFetchGroupManager().getObjectFetchGroup(clone2);
            }
            if (fetchGroup == null || fetchGroup != descriptor.getFetchGroupManager().getIdEntityFetchGroup()) {
                changes.setOptimisticLockingPolicyAndInitialWriteLockValue(descriptor.getOptimisticLockingPolicy(), session);
            }
            shouldGetFetchGroup = false;
        }
        if (!isNew || descriptor.shouldUseFullChangeSetsForNewObjects() || descriptor.isDescriptorTypeAggregate()) {
            Vector<DatabaseMapping> mappings = descriptor.getMappings();
            int mappingsSize = mappings.size();
            if (shouldGetFetchGroup && descriptor.hasFetchGroupManager()) {
                fetchGroup = descriptor.getFetchGroupManager().getObjectFetchGroup(clone2);
            }
            int index2 = 0;
            while (index2 < mappingsSize) {
                DatabaseMapping mapping = (DatabaseMapping)mappings.get(index2);
                if (fetchGroup == null || fetchGroup.containsAttributeInternal(mapping.getAttributeName())) {
                    changes.addChange(mapping.compareForChange(clone2, backUp, changes, session));
                }
                ++index2;
            }
        }
        return changes;
    }

    @Override
    public void dissableEventProcessing(Object changeTracker) {
    }

    @Override
    public void enableEventProcessing(Object changeTracker) {
    }

    @Override
    public boolean shouldCompareExistingObjectForChange(Object object, UnitOfWorkImpl unitOfWork, ClassDescriptor descriptor) {
        return true;
    }

    @Override
    public Object buildBackupClone(Object clone2, ObjectBuilder builder, UnitOfWorkImpl uow) {
        return builder.buildBackupClone(clone2, uow);
    }

    @Override
    public void setAggregateChangeListener(Object parent, Object aggregate, UnitOfWorkImpl uow, ClassDescriptor descriptor, String mappingAttribute) {
    }

    @Override
    public PropertyChangeListener setChangeListener(Object clone2, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        return null;
    }

    @Override
    public void setChangeSetOnListener(ObjectChangeSet objectChangeSet, Object clone2) {
    }

    @Override
    public void updateWithChanges(Object clone2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        if (objectChangeSet == null) {
            return;
        }
        Object backupClone = uow.getCloneMapping().get(clone2);
        if (backupClone != null) {
            if (objectChangeSet.isNew()) {
                uow.getCloneMapping().put(clone2, descriptor.getObjectBuilder().buildBackupClone(clone2, uow));
            } else {
                MergeManager mergeManager = new MergeManager(uow);
                mergeManager.setCascadePolicy(1);
                descriptor.getObjectBuilder().mergeChangesIntoObject(backupClone, objectChangeSet, clone2, mergeManager, mergeManager.getSession());
            }
        }
        this.clearChanges(clone2, uow, descriptor, false);
    }

    @Override
    public void raiseInternalPropertyChangeEvent(Object source, String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void revertChanges(Object clone2, ClassDescriptor descriptor, UnitOfWorkImpl uow, Map cloneMapping, boolean forRefresh) {
        cloneMapping.put(clone2, this.buildBackupClone(clone2, descriptor.getObjectBuilder(), uow));
        this.clearChanges(clone2, uow, descriptor, forRefresh);
    }

    @Override
    public void initialize(AbstractSession session, ClassDescriptor descriptor) {
    }

    @Override
    public boolean isDeferredChangeDetectionPolicy() {
        return true;
    }

    @Override
    public boolean isObjectChangeTrackingPolicy() {
        return false;
    }

    @Override
    public boolean isAttributeChangeTrackingPolicy() {
        return false;
    }

    @Override
    public void updateListenerForSelfMerge(ObjectChangeListener listener, ForeignReferenceMapping mapping, Object source, Object target, UnitOfWorkImpl unitOfWork) {
    }
}

