/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.core.queries;

import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.core.descriptors.CoreInheritancePolicy;
import org.eclipse.persistence.core.queries.CoreAttributeItem;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.core.queries.CoreAttributeConverter;
import org.eclipse.persistence.internal.helper.StringHelper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;

public class CoreAttributeGroup<ATTRIBUTE_ITEM extends CoreAttributeItem, DESCRIPTOR extends CoreDescriptor>
implements Serializable,
Cloneable {
    private static final String FIELD_SEP = ", ";
    protected String name;
    protected String typeName;
    protected Class type;
    protected CoreAttributeGroup superClassGroup;
    protected transient Set<CoreAttributeGroup> subClasses;
    protected Map<Object, CoreAttributeGroup> allsubclasses;
    protected Map<String, ATTRIBUTE_ITEM> items;
    protected boolean isValidated;

    public CoreAttributeGroup(String name) {
        this.name = name;
    }

    public CoreAttributeGroup(String name, String type, boolean isValidated) {
        this(name);
        this.typeName = type;
        this.isValidated = isValidated;
    }

    public CoreAttributeGroup(String name, Class type, boolean isValidated) {
        this(name);
        this.type = type;
        this.isValidated = isValidated;
    }

    public CoreAttributeGroup() {
        this("");
    }

    public void addAttribute(String attributeNameOrPath) {
        this.addAttribute(attributeNameOrPath, (CoreAttributeGroup)null);
    }

    public void addAttribute(String attributeNameOrPath, Collection<? extends CoreAttributeGroup> groups) {
        ATTRIBUTE_ITEM item = this.getItem(CoreAttributeConverter.convert(attributeNameOrPath), true);
        ((CoreAttributeItem)item).addGroups(groups);
    }

    public void addAttribute(String attributeNameOrPath, CoreAttributeGroup group) {
        ATTRIBUTE_ITEM item = this.getItem(CoreAttributeConverter.convert(attributeNameOrPath), true);
        ((CoreAttributeItem)item).addSubGroup((CoreAttributeGroup)group);
    }

    public void addAttributeKey(String attributeNameOrPath, CoreAttributeGroup group) {
        ATTRIBUTE_ITEM item = this.getItem(CoreAttributeConverter.convert(attributeNameOrPath), true);
        ((CoreAttributeItem)item).addKeyGroup((CoreAttributeGroup)group);
    }

    public void addAttributes(Collection<String> attrOrPaths) {
        for (String attr : attrOrPaths) {
            this.addAttribute(attr);
        }
    }

    public CoreAttributeGroup clone() {
        IdentityHashMap<CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR>, CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR>> cloneMap = new IdentityHashMap<CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR>, CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR>>();
        return this.clone(cloneMap);
    }

    public CoreAttributeGroup clone(Map<CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR>, CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR>> cloneMap) {
        CoreAttributeGroup clone2 = cloneMap.get(this);
        if (clone2 != null) {
            return clone2;
        }
        try {
            clone2 = (CoreAttributeGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone2.name = this.name;
        clone2.type = this.type;
        clone2.typeName = this.typeName;
        clone2.isValidated = this.isValidated;
        cloneMap.put(this, clone2);
        if (this.allsubclasses != null) {
            for (CoreAttributeGroup group : this.allsubclasses.values()) {
                clone2.getSubClassGroups().put(group.getType(), group.clone(cloneMap));
            }
        }
        if (this.superClassGroup != null) {
            clone2.superClassGroup = this.superClassGroup.clone(cloneMap);
        }
        if (this.subClasses != null) {
            clone2.subClasses = new HashSet<CoreAttributeGroup>();
            for (CoreAttributeGroup group : this.subClasses) {
                clone2.subClasses.add(group.clone(cloneMap));
            }
        }
        clone2.items = null;
        if (this.hasItems()) {
            clone2.items = new HashMap<String, ATTRIBUTE_ITEM>();
            for (CoreAttributeItem item : this.items.values()) {
                clone2.items.put(item.getAttributeName(), item.clone(cloneMap, clone2));
            }
        }
        return clone2;
    }

    public boolean containsAttribute(String attributeNameOrPath) {
        String[] path = CoreAttributeConverter.convert(attributeNameOrPath);
        if (this.getItem(path, false) != null) {
            return true;
        }
        if (this.hasInheritance() && this.superClassGroup != null) {
            return this.superClassGroup.containsAttribute(attributeNameOrPath);
        }
        return false;
    }

    public boolean containsAttributeInternal(String attributeName) {
        if (this.items != null && this.items.containsKey(attributeName)) {
            return true;
        }
        if (this.hasInheritance() && this.superClassGroup != null) {
            return this.superClassGroup.containsAttributeInternal(attributeName);
        }
        return false;
    }

    protected String[] convert(String ... nameOrPath) {
        return CoreAttributeConverter.convert(nameOrPath);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.type == null) {
            block11: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.type = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.typeName, true, classLoader));
                            break block11;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.typeName, exception.getException());
                        }
                    }
                    this.type = PrivilegedAccessHelper.getClassForName(this.typeName, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.typeName, exc);
                }
            }
            if (this.items != null) {
                for (CoreAttributeItem item : this.items.values()) {
                    item.convertClassNamesToClasses(classLoader);
                }
            }
            if (this.allsubclasses != null) {
                HashMap<Object, CoreAttributeGroup> allGroups = new HashMap<Object, CoreAttributeGroup>();
                this.subClasses = new HashSet<CoreAttributeGroup>();
                for (CoreAttributeGroup subClass : this.allsubclasses.values()) {
                    subClass.convertClassNamesToClasses(classLoader);
                    allGroups.put(subClass.getType(), subClass);
                }
                this.allsubclasses = allGroups;
                for (CoreAttributeGroup subClass : this.allsubclasses.values()) {
                    if (!CoreAttributeItem.orderInheritance(subClass, allGroups)) continue;
                    this.insertSubClass(subClass);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) {
            return false;
        }
        CoreAttributeGroup anotherGroup = null;
        try {
            anotherGroup = (CoreAttributeGroup)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.hasItems()) {
            if (!anotherGroup.hasItems()) return false;
            if (!this.getItems().equals(anotherGroup.getItems())) {
                return false;
            }
        } else if (anotherGroup.hasItems()) {
            return false;
        }
        if (this.superClassGroup == null) return anotherGroup.superClassGroup == null;
        if (anotherGroup.superClassGroup == null) return false;
        return this.superClassGroup.equals(anotherGroup.superClassGroup);
    }

    public CoreAttributeGroup findGroup(DESCRIPTOR type) {
        if (this.type == null || this.type.equals(((CoreDescriptor)type).getJavaClass())) {
            return this;
        }
        if (this.hasInheritance()) {
            CoreAttributeGroup result2 = this.getSubClassGroups().get(((CoreDescriptor)type).getJavaClass());
            while (result2 == null && ((CoreInheritancePolicy)((CoreDescriptor)type).getInheritancePolicy()).getParentDescriptor() != null) {
                type = ((CoreInheritancePolicy)((CoreDescriptor)type).getInheritancePolicy()).getParentDescriptor();
                result2 = this.getSubClassGroups().get(((CoreDescriptor)type).getJavaClass());
            }
            if (result2 != null) {
                return result2;
            }
        }
        return this;
    }

    public Map<String, ATTRIBUTE_ITEM> getAllItems() {
        HashMap<String, ATTRIBUTE_ITEM> allItems = new HashMap<String, ATTRIBUTE_ITEM>();
        if (this.superClassGroup != null) {
            allItems.putAll(this.superClassGroup.getAllItems());
        }
        allItems.putAll(this.getItems());
        return allItems;
    }

    public Set<String> getAttributeNames() {
        HashSet<String> attributes = new HashSet<String>();
        if (this.superClassGroup != null && this.superClassGroup != this) {
            attributes.addAll(this.superClassGroup.getAttributeNames());
        }
        attributes.addAll(this.getItems().keySet());
        return attributes;
    }

    public CoreAttributeGroup getGroup(String attributeNameOrPath) {
        ATTRIBUTE_ITEM item = this.getItem(CoreAttributeConverter.convert(attributeNameOrPath), false);
        if (item != null) {
            return ((CoreAttributeItem)item).getGroup();
        }
        if (this.hasInheritance()) {
            return this.superClassGroup.getGroup(attributeNameOrPath);
        }
        return null;
    }

    public ATTRIBUTE_ITEM getItem(String attributeNameOrPath) {
        return this.getItem(CoreAttributeConverter.convert(attributeNameOrPath), false);
    }

    protected ATTRIBUTE_ITEM getItem(String[] attributePath, boolean create2) {
        CoreAttributeItem item = null;
        CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR> currentGroup = this;
        int index2 = 0;
        while (index2 < attributePath.length) {
            String attrName = attributePath[index2];
            item = (CoreAttributeItem)currentGroup.getItems().get(attrName);
            if (item == null) {
                if (!create2) {
                    if (this.superClassGroup != null) {
                        return this.superClassGroup.getItem(attributePath, create2);
                    }
                    return null;
                }
                item = this.newItem(currentGroup, attrName);
                currentGroup.getItems().put(attrName, item);
            }
            if (item.getGroup() == null && index2 < attributePath.length - 1) {
                if (!create2) {
                    return null;
                }
                CoreAttributeGroup newGroup = this.newGroup(attrName, currentGroup);
                item.setRootGroup(newGroup);
            }
            currentGroup = item.getGroup();
            ++index2;
        }
        return (ATTRIBUTE_ITEM)item;
    }

    public Map<String, ATTRIBUTE_ITEM> getItems() {
        if (this.items == null) {
            this.items = new HashMap<String, ATTRIBUTE_ITEM>();
        }
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public Map<Object, CoreAttributeGroup> getSubClassGroups() {
        if (this.allsubclasses == null) {
            this.allsubclasses = new HashMap<Object, CoreAttributeGroup>();
        }
        return this.allsubclasses;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean hasInheritance() {
        return this.subClasses != null && !this.subClasses.isEmpty() || this.superClassGroup != null;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public void insertSubClass(CoreAttributeGroup group) {
        if (this == group) {
            return;
        }
        group.superClassGroup = this;
        if (this.subClasses != null) {
            Iterator<CoreAttributeGroup> subClasses = this.subClasses.iterator();
            while (subClasses.hasNext()) {
                CoreAttributeGroup subClass = subClasses.next();
                if (group == subClass || !group.getType().isAssignableFrom(subClass.getType())) continue;
                group.subClasses.add(subClass);
                subClass.superClassGroup = group;
                subClasses.remove();
            }
        } else {
            this.subClasses = new HashSet<CoreAttributeGroup>();
        }
        this.subClasses.add(group);
    }

    public boolean isConcurrent() {
        return false;
    }

    public boolean isCopyGroup() {
        return false;
    }

    public boolean isFetchGroup() {
        return false;
    }

    public boolean isLoadGroup() {
        return false;
    }

    public boolean isSupersetOf(CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR> anotherGroup) {
        if (anotherGroup == null) {
            return false;
        }
        if (anotherGroup != this) {
            if (this.hasItems()) {
                if (anotherGroup.hasItems()) {
                    for (Map.Entry<String, ATTRIBUTE_ITEM> otherItemEntry : anotherGroup.getItems().entrySet()) {
                        CoreAttributeGroup otherElement;
                        CoreAttributeGroup element;
                        String otherAttributeName = otherItemEntry.getKey();
                        CoreAttributeItem item = (CoreAttributeItem)this.items.get(otherAttributeName);
                        if (item == null) {
                            return false;
                        }
                        Object group = item.getGroup();
                        Object otherGroup = ((CoreAttributeItem)otherItemEntry.getValue()).getGroup();
                        if (group != null) {
                            if (!((CoreAttributeGroup)group).isSupersetOf((CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR>)otherGroup)) {
                                return false;
                            }
                        } else if (otherGroup != null) {
                            return true;
                        }
                        group = item.getKeyGroup();
                        otherGroup = ((CoreAttributeItem)otherItemEntry.getValue()).getKeyGroup();
                        if (group != null) {
                            if (!((CoreAttributeGroup)group).isSupersetOf((CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR>)otherGroup)) {
                                return false;
                            }
                        } else if (otherGroup != null) {
                            return true;
                        }
                        if (item.getGroups() != null) {
                            if (((CoreAttributeItem)otherItemEntry.getValue()).getGroups() == null) {
                                return true;
                            }
                            for (Object next2 : item.getGroups().values()) {
                                element = (CoreAttributeGroup)next2;
                                if (element.isSupersetOf(otherElement = (CoreAttributeGroup)((CoreAttributeItem)otherItemEntry.getValue()).getGroups().get(element.getType()))) continue;
                                return false;
                            }
                        }
                        if (item.getKeyGroups() == null) continue;
                        if (((CoreAttributeItem)otherItemEntry.getValue()).getKeyGroups() == null) {
                            return true;
                        }
                        for (Object next2 : item.getKeyGroups().values()) {
                            element = (CoreAttributeGroup)next2;
                            if (element.isSupersetOf(otherElement = (CoreAttributeGroup)((CoreAttributeItem)otherItemEntry.getValue()).getKeyGroups().get(element.getType()))) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return true;
            }
            return !anotherGroup.hasItems();
        }
        return true;
    }

    public boolean isValidated() {
        return this.isValidated;
    }

    protected CoreAttributeGroup newGroup(String name, CoreAttributeGroup parent) {
        return new CoreAttributeGroup<ATTRIBUTE_ITEM, DESCRIPTOR>(name);
    }

    protected CoreAttributeItem newItem(CoreAttributeGroup group, String attrName) {
        return new CoreAttributeItem<CoreAttributeGroup>(group, attrName);
    }

    public void removeAttribute(String attributeNameOrPath) {
        ATTRIBUTE_ITEM item = this.getItem(attributeNameOrPath);
        if (item != null) {
            ((CoreAttributeGroup)((CoreAttributeItem)item).getParent()).getItems().remove(((CoreAttributeItem)item).getAttributeName());
        }
    }

    public void setAllSubclasses(Map<Object, CoreAttributeGroup> subclasses) {
        this.allsubclasses = subclasses;
    }

    public void setAttributeNames(Set attributeNames) {
        Iterator it = attributeNames.iterator();
        while (it.hasNext()) {
            this.addAttribute((String)it.next());
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        String className = StringHelper.nonNullString(this.getClass().getSimpleName());
        String name = StringHelper.nonNullString(this.getName());
        String items = StringHelper.nonNullString(this.toStringItems());
        String additionalInfo = StringHelper.nonNullString(this.toStringAdditionalInfo());
        StringBuilder str = new StringBuilder(className.length() + name.length() + additionalInfo.length() + items.length() + 4);
        str.append(className);
        str.append('(').append(name).append(')');
        str.append(additionalInfo);
        str.append('{').append(items).append('}');
        return str.toString();
    }

    protected String toStringAdditionalInfo() {
        return "";
    }

    protected String toStringItems() {
        String superClassGroupItems;
        int length = 0;
        if (this.superClassGroup != null) {
            superClassGroupItems = this.superClassGroup.toStringItems();
            length += FIELD_SEP.length();
            length += superClassGroupItems.length();
        } else {
            superClassGroupItems = null;
        }
        Collection<ATTRIBUTE_ITEM> values = this.items.values();
        length += values != null && values.size() > 0 ? (values.size() - 1) * FIELD_SEP.length() : 0;
        Iterator<ATTRIBUTE_ITEM> it = values.iterator();
        while (it.hasNext()) {
            length += ((CoreAttributeItem)it.next()).toStringNoClassName().length();
        }
        StringBuilder str = new StringBuilder(length > 0 ? length : 0);
        Iterator<ATTRIBUTE_ITEM> it2 = values.iterator();
        while (it2.hasNext()) {
            str.append(((CoreAttributeItem)it2.next()).toStringNoClassName());
            if (!it2.hasNext()) continue;
            str.append(FIELD_SEP);
        }
        if (this.superClassGroup != null) {
            str.append(FIELD_SEP);
            str.append(superClassGroupItems);
        }
        return str.toString();
    }

    protected static String toStringPath(String[] attributePath, int position) {
        StringWriter writer = new StringWriter();
        int index2 = 0;
        while (index2 <= position) {
            writer.write(attributePath[index2]);
            if (index2 < position) {
                writer.write(".");
            }
            ++index2;
        }
        return writer.toString();
    }
}

