/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Visitor;
import org.dom4j.tree.AbstractNode;

public abstract class AbstractProcessingInstruction
extends AbstractNode
implements ProcessingInstruction {
    public short getNodeType() {
        return 7;
    }

    public String getPath(Element context) {
        Element parent = this.getParent();
        return parent != null && parent != context ? parent.getPath(context) + "/processing-instruction()" : "processing-instruction()";
    }

    public String getUniquePath(Element context) {
        Element parent = this.getParent();
        return parent != null && parent != context ? parent.getUniquePath(context) + "/processing-instruction()" : "processing-instruction()";
    }

    public String toString() {
        return super.toString() + " [ProcessingInstruction: &" + this.getName() + ";]";
    }

    public String asXML() {
        return "<?" + this.getName() + " " + this.getText() + "?>";
    }

    public void write(Writer writer) throws IOException {
        writer.write("<?");
        writer.write(this.getName());
        writer.write(" ");
        writer.write(this.getText());
        writer.write("?>");
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void setValue(String name, String value2) {
        throw new UnsupportedOperationException("This PI is read-only and cannot be modified");
    }

    public void setValues(Map data2) {
        throw new UnsupportedOperationException("This PI is read-only and cannot be modified");
    }

    public String getName() {
        return this.getTarget();
    }

    public void setName(String name) {
        this.setTarget(name);
    }

    public boolean removeValue(String name) {
        return false;
    }

    protected String toString(Map values) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter2 = values.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry entry2 = iter2.next();
            String name = (String)entry2.getKey();
            String value2 = (String)entry2.getValue();
            buffer.append(name);
            buffer.append("=\"");
            buffer.append(value2);
            buffer.append("\" ");
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    protected Map parseValues(String text2) {
        HashMap<String, String> data2 = new HashMap<String, String>();
        StringTokenizer s2 = new StringTokenizer(text2, " ='\"", true);
        while (s2.hasMoreTokens()) {
            String name = this.getName(s2);
            if (!s2.hasMoreTokens()) continue;
            String value2 = this.getValue(s2);
            data2.put(name, value2);
        }
        return data2;
    }

    private String getName(StringTokenizer tokenizer) {
        String token2 = tokenizer.nextToken();
        StringBuffer name = new StringBuffer(token2);
        while (tokenizer.hasMoreTokens() && !(token2 = tokenizer.nextToken()).equals("=")) {
            name.append(token2);
        }
        return name.toString().trim();
    }

    private String getValue(StringTokenizer tokenizer) {
        String token2 = tokenizer.nextToken();
        StringBuffer value2 = new StringBuffer();
        while (tokenizer.hasMoreTokens() && !token2.equals("'") && !token2.equals("\"")) {
            token2 = tokenizer.nextToken();
        }
        String quote = token2;
        while (tokenizer.hasMoreTokens() && !quote.equals(token2 = tokenizer.nextToken())) {
            value2.append(token2);
        }
        return value2.toString();
    }
}

