/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.swing;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.dom4j.Branch;
import org.dom4j.CharacterData;
import org.dom4j.Node;
import org.dom4j.swing.LeafTreeNode;

public class BranchTreeNode
extends LeafTreeNode {
    protected List children;

    public BranchTreeNode() {
    }

    public BranchTreeNode(Branch xmlNode) {
        super(xmlNode);
    }

    public BranchTreeNode(TreeNode parent, Branch xmlNode) {
        super(parent, xmlNode);
    }

    public Enumeration children() {
        return new Enumeration(){
            private int index = -1;

            public boolean hasMoreElements() {
                return this.index + 1 < BranchTreeNode.this.getChildCount();
            }

            public Object nextElement() {
                return BranchTreeNode.this.getChildAt(++this.index);
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.getChildList().get(childIndex);
    }

    public int getChildCount() {
        return this.getChildList().size();
    }

    public int getIndex(TreeNode node) {
        return this.getChildList().indexOf(node);
    }

    public boolean isLeaf() {
        return this.getXmlBranch().nodeCount() <= 0;
    }

    public String toString() {
        return this.xmlNode.getName();
    }

    protected List getChildList() {
        if (this.children == null) {
            this.children = this.createChildList();
        }
        return this.children;
    }

    protected List createChildList() {
        Branch branch = this.getXmlBranch();
        int size2 = branch.nodeCount();
        ArrayList<TreeNode> childList = new ArrayList<TreeNode>(size2);
        for (int i = 0; i < size2; ++i) {
            String text2;
            Node node = branch.node(i);
            if (node instanceof CharacterData && ((text2 = node.getText()) == null || (text2 = text2.trim()).length() <= 0)) continue;
            childList.add(this.createChildTreeNode(node));
        }
        return childList;
    }

    protected TreeNode createChildTreeNode(Node xmlNode) {
        if (xmlNode instanceof Branch) {
            return new BranchTreeNode((TreeNode)this, (Branch)xmlNode);
        }
        return new LeafTreeNode(this, xmlNode);
    }

    protected Branch getXmlBranch() {
        return (Branch)this.xmlNode;
    }
}

