/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.bean;

import java.util.AbstractList;
import org.dom4j.Attribute;
import org.dom4j.QName;
import org.dom4j.bean.BeanAttribute;
import org.dom4j.bean.BeanElement;
import org.dom4j.bean.BeanMetaData;

public class BeanAttributeList
extends AbstractList {
    private BeanElement parent;
    private BeanMetaData beanMetaData;
    private BeanAttribute[] attributes;

    public BeanAttributeList(BeanElement parent, BeanMetaData beanMetaData) {
        this.parent = parent;
        this.beanMetaData = beanMetaData;
        this.attributes = new BeanAttribute[beanMetaData.attributeCount()];
    }

    public BeanAttributeList(BeanElement parent) {
        this.parent = parent;
        Object data2 = parent.getData();
        Class<?> beanClass = data2 != null ? data2.getClass() : null;
        this.beanMetaData = BeanMetaData.get(beanClass);
        this.attributes = new BeanAttribute[this.beanMetaData.attributeCount()];
    }

    public Attribute attribute(String name) {
        int index2 = this.beanMetaData.getIndex(name);
        return this.attribute(index2);
    }

    public Attribute attribute(QName qname) {
        int index2 = this.beanMetaData.getIndex(qname);
        return this.attribute(index2);
    }

    public BeanAttribute attribute(int index2) {
        if (index2 >= 0 && index2 <= this.attributes.length) {
            BeanAttribute attribute = this.attributes[index2];
            if (attribute == null) {
                this.attributes[index2] = attribute = this.createAttribute(this.parent, index2);
            }
            return attribute;
        }
        return null;
    }

    public BeanElement getParent() {
        return this.parent;
    }

    public QName getQName(int index2) {
        return this.beanMetaData.getQName(index2);
    }

    public Object getData(int index2) {
        return this.beanMetaData.getData(index2, this.parent.getData());
    }

    public void setData(int index2, Object data2) {
        this.beanMetaData.setData(index2, this.parent.getData(), data2);
    }

    public int size() {
        return this.attributes.length;
    }

    public Object get(int index2) {
        BeanAttribute attribute = this.attributes[index2];
        if (attribute == null) {
            this.attributes[index2] = attribute = this.createAttribute(this.parent, index2);
        }
        return attribute;
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException("add(Object) unsupported");
    }

    public void add(int index2, Object object) {
        throw new UnsupportedOperationException("add(int,Object) unsupported");
    }

    public Object set(int index2, Object object) {
        throw new UnsupportedOperationException("set(int,Object) unsupported");
    }

    public boolean remove(Object object) {
        return false;
    }

    public Object remove(int index2) {
        BeanAttribute attribute = (BeanAttribute)this.get(index2);
        String oldValue = attribute.getValue();
        attribute.setValue(null);
        return oldValue;
    }

    public void clear() {
        int size2 = this.attributes.length;
        for (int i = 0; i < size2; ++i) {
            BeanAttribute attribute = this.attributes[i];
            if (attribute == null) continue;
            attribute.setValue(null);
        }
    }

    protected BeanAttribute createAttribute(BeanElement element, int index2) {
        return new BeanAttribute(this, index2);
    }
}

