/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl.jcajce;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.JcaJceHelper;
import org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;

public class JcaPEMKeyConverter {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcaPEMKeyConverter setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaPEMKeyConverter setProvider(String string2) {
        this.helper = new NamedJcaJceHelper(string2);
        return this;
    }

    public KeyPair getKeyPair(PEMKeyPair pEMKeyPair) throws PEMException {
        try {
            String string2 = pEMKeyPair.getPrivateKeyInfo().getPrivateKeyAlgorithm().getAlgorithm().getId();
            if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(string2)) {
                string2 = "ECDSA";
            }
            KeyFactory keyFactory = this.helper.createKeyFactory(string2);
            return new KeyPair(keyFactory.generatePublic(new X509EncodedKeySpec(pEMKeyPair.getPublicKeyInfo().getEncoded())), keyFactory.generatePrivate(new PKCS8EncodedKeySpec(pEMKeyPair.getPrivateKeyInfo().getEncoded())));
        }
        catch (Exception exception) {
            throw new PEMException("unable to convert key pair: " + exception.getMessage(), exception);
        }
    }

    public PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PEMException {
        try {
            String string2 = subjectPublicKeyInfo.getAlgorithm().getAlgorithm().getId();
            if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(string2)) {
                string2 = "ECDSA";
            }
            KeyFactory keyFactory = this.helper.createKeyFactory(string2);
            return keyFactory.generatePublic(new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded()));
        }
        catch (Exception exception) {
            throw new PEMException("unable to convert key pair: " + exception.getMessage(), exception);
        }
    }

    public PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws PEMException {
        try {
            String string2 = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId();
            if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(string2)) {
                string2 = "ECDSA";
            }
            KeyFactory keyFactory = this.helper.createKeyFactory(string2);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded()));
        }
        catch (Exception exception) {
            throw new PEMException("unable to convert key pair: " + exception.getMessage(), exception);
        }
    }
}

