/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.tls.AbstractTlsContext;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.NewSessionTicket;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.bouncycastle.crypto.tls.TlsPeer;
import org.bouncycastle.crypto.tls.TlsProtocol;
import org.bouncycastle.crypto.tls.TlsServer;
import org.bouncycastle.crypto.tls.TlsServerContextImpl;
import org.bouncycastle.crypto.tls.TlsSigner;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.util.Arrays;

public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    protected TlsServerContextImpl tlsServerContext = null;
    protected int[] offeredCipherSuites;
    protected short[] offeredCompressionMethods;
    protected Hashtable clientExtensions;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected Hashtable serverExtensions;
    protected TlsKeyExchange keyExchange = null;
    protected TlsCredentials serverCredentials = null;
    protected CertificateRequest certificateRequest = null;
    protected short clientCertificateType = (short)-1;
    protected Certificate clientCertificate = null;
    protected byte[] certificateVerifyHash = null;

    public TlsServerProtocol(InputStream inputStream, OutputStream outputStream, SecureRandom secureRandom) {
        super(inputStream, outputStream, secureRandom);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("accept can only be called once");
        }
        this.tlsServer = tlsServer;
        this.securityParameters = new SecurityParameters();
        this.securityParameters.entity = 0;
        this.securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(this.secureRandom);
        this.tlsServerContext = new TlsServerContextImpl(this.secureRandom, this.securityParameters);
        this.tlsServer.init(this.tlsServerContext);
        this.recordStream.init(this.tlsServerContext);
        this.recordStream.setRestrictReadVersion(false);
        this.completeHandshake();
        this.tlsServer.notifyHandshakeComplete();
    }

    protected AbstractTlsContext getContext() {
        return this.tlsServerContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    protected void handleChangeCipherSpecMessage() throws IOException {
        switch (this.connection_state) {
            case 10: {
                if (this.certificateVerifyHash != null) {
                    this.failWithError((short)2, (short)10);
                }
            }
            case 11: {
                this.connection_state = (short)12;
                break;
            }
            default: {
                this.failWithError((short)2, (short)40);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void handleHandshakeMessage(short var1_1, byte[] var2_2) throws IOException {
        var3_3 = new ByteArrayInputStream(var2_2);
        block0 : switch (var1_1) {
            case 1: {
                switch (this.connection_state) {
                    case 0: {
                        this.receiveClientHelloMessage(var3_3);
                        this.connection_state = 1;
                        this.sendServerHelloMessage();
                        this.connection_state = (short)2;
                        this.securityParameters.prfAlgorithm = TlsServerProtocol.getPRFAlgorithm(this.selectedCipherSuite);
                        this.securityParameters.compressionAlgorithm = this.selectedCompressionMethod;
                        this.securityParameters.verifyDataLength = 12;
                        this.recordStream.notifyHelloComplete();
                        var4_4 = this.tlsServer.getServerSupplementalData();
                        if (var4_4 != null) {
                            this.sendSupplementalDataMessage(var4_4);
                        }
                        this.connection_state = (short)3;
                        this.keyExchange = this.tlsServer.getKeyExchange();
                        this.keyExchange.init(this.getContext());
                        this.serverCredentials = this.tlsServer.getCredentials();
                        if (this.serverCredentials == null) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(this.serverCredentials);
                            this.sendCertificateMessage(this.serverCredentials.getCertificate());
                        }
                        this.connection_state = (short)4;
                        var5_6 = this.keyExchange.generateServerKeyExchange();
                        if (var5_6 != null) {
                            this.sendServerKeyExchangeMessage(var5_6);
                        }
                        this.connection_state = (short)5;
                        if (this.serverCredentials != null) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (this.certificateRequest != null) {
                                this.keyExchange.validateCertificateRequest(this.certificateRequest);
                                this.sendCertificateRequestMessage(this.certificateRequest);
                            }
                        }
                        this.connection_state = (short)6;
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)7;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 23: {
                switch (this.connection_state) {
                    case 7: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(var3_3));
                        this.connection_state = (short)8;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 11: {
                switch (this.connection_state) {
                    case 7: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 8: {
                        if (this.certificateRequest == null) {
                            this.failWithError((short)2, (short)10);
                        }
                        this.receiveCertificateMessage(var3_3);
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 16: {
                switch (this.connection_state) {
                    case 7: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 8: {
                        if (this.certificateRequest != null) ** GOTO lbl70
                        this.keyExchange.skipClientCredentials();
                        ** GOTO lbl79
lbl70:
                        // 1 sources

                        var4_5 = this.getContext().getServerVersion().getEquivalentTLSVersion();
                        if (!ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(var4_5)) ** GOTO lbl74
                        this.failWithError((short)2, (short)10);
                        ** GOTO lbl79
lbl74:
                        // 1 sources

                        if (var4_5.isSSL()) {
                            if (this.clientCertificate == null) {
                                this.failWithError((short)2, (short)10);
                            }
                        } else {
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
lbl79:
                    // 5 sources

                    case 9: {
                        this.receiveClientKeyExchangeMessage(var3_3);
                        this.connection_state = (short)10;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 15: {
                switch (this.connection_state) {
                    case 10: {
                        if (this.certificateVerifyHash == null) {
                            this.failWithError((short)2, (short)10);
                        }
                        this.receiveCertificateVerifyMessage(var3_3);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 20: {
                switch (this.connection_state) {
                    case 12: {
                        this.processFinishedMessage(var3_3);
                        this.connection_state = (short)13;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                        }
                        this.connection_state = (short)14;
                        this.sendChangeCipherSpecMessage();
                        this.connection_state = (short)15;
                        this.sendFinishedMessage();
                        this.connection_state = (short)16;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            default: {
                this.failWithError((short)2, (short)10);
            }
        }
    }

    protected void handleWarningMessage(short s2) throws IOException {
        switch (s2) {
            case 41: {
                if (!this.getContext().getServerVersion().isSSL() || this.certificateRequest == null) break;
                this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                break;
            }
            default: {
                super.handleWarningMessage(s2);
            }
        }
    }

    protected void notifyClientCertificate(Certificate certificate) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        if (this.clientCertificate != null) {
            throw new TlsFatalAlert(10);
        }
        this.clientCertificate = certificate;
        if (certificate.isEmpty()) {
            this.keyExchange.skipClientCredentials();
        } else {
            this.clientCertificateType = TlsUtils.getClientCertificateType(certificate, this.serverCredentials.getCertificate());
            this.keyExchange.processClientCertificate(certificate);
        }
        this.tlsServer.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Certificate certificate = Certificate.parse(byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        try {
            TlsSigner tlsSigner = TlsUtils.createTlsSigner(this.clientCertificateType);
            tlsSigner.init(this.getContext());
            org.bouncycastle.asn1.x509.Certificate certificate = this.clientCertificate.getCertificateAt(0);
            SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
            AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey(subjectPublicKeyInfo);
            tlsSigner.verifyRawSignature(byArray, asymmetricKeyParameter, this.certificateVerifyHash);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(51);
        }
    }

    protected void receiveClientHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray;
        int n;
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        if (protocolVersion.isDTLS()) {
            this.failWithError((short)2, (short)47);
        }
        byte[] byArray2 = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray3 = TlsUtils.readOpaque8(byteArrayInputStream);
        if (byArray3.length > 32) {
            this.failWithError((short)2, (short)47);
        }
        if ((n = TlsUtils.readUint16(byteArrayInputStream)) < 2 || (n & 1) != 0) {
            this.failWithError((short)2, (short)50);
        }
        this.offeredCipherSuites = TlsUtils.readUint16Array(n / 2, byteArrayInputStream);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (s2 < 1) {
            this.failWithError((short)2, (short)47);
        }
        this.offeredCompressionMethods = TlsUtils.readUint8Array(s2, byteArrayInputStream);
        this.clientExtensions = TlsServerProtocol.readExtensions(byteArrayInputStream);
        this.getContext().setClientVersion(protocolVersion);
        this.tlsServer.notifyClientVersion(protocolVersion);
        this.securityParameters.clientRandom = byArray2;
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        this.tlsServer.notifyOfferedCompressionMethods(this.offeredCompressionMethods);
        if (TlsServerProtocol.arrayContains(this.offeredCipherSuites, 255)) {
            this.secure_renegotiation = true;
        }
        if (this.clientExtensions != null && (byArray = (byte[])this.clientExtensions.get(EXT_RenegotiationInfo)) != null) {
            this.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual(byArray, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                this.failWithError((short)2, (short)40);
            }
        }
        this.tlsServer.notifySecureRenegotiation(this.secure_renegotiation);
        if (this.clientExtensions != null) {
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.keyExchange.processClientKeyExchange(byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        TlsServerProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
        this.recordStream.setPendingConnectionState(this.tlsServer.getCompression(), this.tlsServer.getCipher());
        if (this.expectCertificateVerifyMessage()) {
            this.certificateVerifyHash = this.recordStream.getCurrentHash(null);
        }
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)13, byteArrayOutputStream);
        TlsUtils.writeUint24(0, byteArrayOutputStream);
        certificateRequest.encode(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint24(byArray.length - 4, byArray, 1);
        this.safeWriteRecord((short)22, byArray, 0, byArray.length);
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)4, byteArrayOutputStream);
        TlsUtils.writeUint24(0, byteArrayOutputStream);
        newSessionTicket.encode(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint24(byArray.length - 4, byArray, 1);
        this.safeWriteRecord((short)22, byArray, 0, byArray.length);
    }

    protected void sendServerHelloMessage() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)2, byteArrayOutputStream);
        TlsUtils.writeUint24(0, byteArrayOutputStream);
        ProtocolVersion protocolVersion = this.tlsServer.getServerVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(this.getContext().getClientVersion())) {
            this.failWithError((short)2, (short)80);
        }
        this.recordStream.setReadVersion(protocolVersion);
        this.recordStream.setWriteVersion(protocolVersion);
        this.recordStream.setRestrictReadVersion(true);
        this.getContext().setServerVersion(protocolVersion);
        TlsUtils.writeVersion(protocolVersion, byteArrayOutputStream);
        byteArrayOutputStream.write(this.securityParameters.serverRandom);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        this.selectedCipherSuite = this.tlsServer.getSelectedCipherSuite();
        if (!TlsServerProtocol.arrayContains(this.offeredCipherSuites, this.selectedCipherSuite) || this.selectedCipherSuite == 0 || this.selectedCipherSuite == 255) {
            this.failWithError((short)2, (short)80);
        }
        this.selectedCompressionMethod = this.tlsServer.getSelectedCompressionMethod();
        if (!TlsServerProtocol.arrayContains(this.offeredCompressionMethods, this.selectedCompressionMethod)) {
            this.failWithError((short)2, (short)80);
        }
        TlsUtils.writeUint16(this.selectedCipherSuite, byteArrayOutputStream);
        TlsUtils.writeUint8(this.selectedCompressionMethod, byteArrayOutputStream);
        this.serverExtensions = this.tlsServer.getServerExtensions();
        if (this.secure_renegotiation) {
            boolean bl;
            boolean bl2 = bl = this.serverExtensions == null || !this.serverExtensions.containsKey(EXT_RenegotiationInfo);
            if (bl) {
                if (this.serverExtensions == null) {
                    this.serverExtensions = new Hashtable();
                }
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (this.serverExtensions != null) {
            this.expectSessionTicket = this.serverExtensions.containsKey(EXT_SessionTicket);
            TlsServerProtocol.writeExtensions(byteArrayOutputStream, this.serverExtensions);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint24(byArray.length - 4, byArray, 1);
        this.safeWriteRecord((short)22, byArray, 0, byArray.length);
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        byte[] byArray = new byte[4];
        TlsUtils.writeUint8((short)14, byArray, 0);
        TlsUtils.writeUint24(0, byArray, 1);
        this.safeWriteRecord((short)22, byArray, 0, byArray.length);
    }

    protected void sendServerKeyExchangeMessage(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)12, byteArrayOutputStream);
        TlsUtils.writeUint24(byArray.length, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.safeWriteRecord((short)22, byArray2, 0, byArray2.length);
    }

    protected boolean expectCertificateVerifyMessage() {
        return this.clientCertificateType >= 0 && TlsUtils.hasSigningCapability(this.clientCertificateType);
    }
}

