/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.crypto.tls.AbstractTlsContext;
import org.bouncycastle.crypto.tls.ByteQueue;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.RecordStream;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.SupplementalDataEntry;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsInputStream;
import org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.bouncycastle.crypto.tls.TlsOutputStream;
import org.bouncycastle.crypto.tls.TlsPeer;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public abstract class TlsProtocol {
    protected static final Integer EXT_RenegotiationInfo = Integers.valueOf(65281);
    protected static final Integer EXT_SessionTicket = Integers.valueOf(35);
    private static final String TLS_ERROR_MESSAGE = "Internal TLS error, this could be an attack";
    protected static final short CS_START = 0;
    protected static final short CS_CLIENT_HELLO = 1;
    protected static final short CS_SERVER_HELLO = 2;
    protected static final short CS_SERVER_SUPPLEMENTAL_DATA = 3;
    protected static final short CS_SERVER_CERTIFICATE = 4;
    protected static final short CS_SERVER_KEY_EXCHANGE = 5;
    protected static final short CS_CERTIFICATE_REQUEST = 6;
    protected static final short CS_SERVER_HELLO_DONE = 7;
    protected static final short CS_CLIENT_SUPPLEMENTAL_DATA = 8;
    protected static final short CS_CLIENT_CERTIFICATE = 9;
    protected static final short CS_CLIENT_KEY_EXCHANGE = 10;
    protected static final short CS_CERTIFICATE_VERIFY = 11;
    protected static final short CS_CLIENT_CHANGE_CIPHER_SPEC = 12;
    protected static final short CS_CLIENT_FINISHED = 13;
    protected static final short CS_SERVER_SESSION_TICKET = 14;
    protected static final short CS_SERVER_CHANGE_CIPHER_SPEC = 15;
    protected static final short CS_SERVER_FINISHED = 16;
    private ByteQueue applicationDataQueue = new ByteQueue();
    private ByteQueue changeCipherSpecQueue = new ByteQueue();
    private ByteQueue alertQueue = new ByteQueue();
    private ByteQueue handshakeQueue = new ByteQueue();
    protected RecordStream recordStream;
    protected SecureRandom secureRandom;
    private TlsInputStream tlsInputStream = null;
    private TlsOutputStream tlsOutputStream = null;
    private volatile boolean closed = false;
    private volatile boolean failedWithError = false;
    private volatile boolean appDataReady = false;
    private volatile boolean writeExtraEmptyRecords = true;
    private byte[] expected_verify_data = null;
    protected SecurityParameters securityParameters = null;
    protected short connection_state = 0;
    protected boolean secure_renegotiation = false;
    protected boolean expectSessionTicket = false;

    public TlsProtocol(InputStream inputStream, OutputStream outputStream, SecureRandom secureRandom) {
        this.recordStream = new RecordStream(this, inputStream, outputStream);
        this.secureRandom = secureRandom;
    }

    protected abstract AbstractTlsContext getContext();

    protected abstract TlsPeer getPeer();

    protected abstract void handleChangeCipherSpecMessage() throws IOException;

    protected abstract void handleHandshakeMessage(short var1, byte[] var2) throws IOException;

    protected void handleWarningMessage(short s2) throws IOException {
    }

    protected void completeHandshake() throws IOException {
        this.expected_verify_data = null;
        while (this.connection_state != 16) {
            this.safeReadRecord();
        }
        this.recordStream.finaliseHandshake();
        ProtocolVersion protocolVersion = this.getContext().getServerVersion();
        this.writeExtraEmptyRecords = protocolVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv10);
        if (!this.appDataReady) {
            this.appDataReady = true;
            this.tlsInputStream = new TlsInputStream(this);
            this.tlsOutputStream = new TlsOutputStream(this);
        }
    }

    protected void processRecord(short s2, byte[] byArray, int n, int n2) throws IOException {
        switch (s2) {
            case 20: {
                this.changeCipherSpecQueue.addData(byArray, n, n2);
                this.processChangeCipherSpec();
                break;
            }
            case 21: {
                this.alertQueue.addData(byArray, n, n2);
                this.processAlert();
                break;
            }
            case 22: {
                this.handshakeQueue.addData(byArray, n, n2);
                this.processHandshake();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    this.failWithError((short)2, (short)10);
                }
                this.applicationDataQueue.addData(byArray, n, n2);
                this.processApplicationData();
                break;
            }
        }
    }

    private void processHandshake() throws IOException {
        boolean bl;
        do {
            bl = false;
            if (this.handshakeQueue.size() < 4) continue;
            byte[] byArray = new byte[4];
            this.handshakeQueue.read(byArray, 0, 4, 0);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            short s2 = TlsUtils.readUint8(byteArrayInputStream);
            int n = TlsUtils.readUint24(byteArrayInputStream);
            if (this.handshakeQueue.size() < n + 4) continue;
            byte[] byArray2 = new byte[n];
            this.handshakeQueue.read(byArray2, 0, n, 4);
            this.handshakeQueue.removeData(n + 4);
            switch (s2) {
                case 0: {
                    break;
                }
                case 20: {
                    if (this.expected_verify_data == null) {
                        this.expected_verify_data = this.createVerifyData(!this.getContext().isServer());
                    }
                }
                default: {
                    this.recordStream.updateHandshakeData(byArray, 0, 4);
                    this.recordStream.updateHandshakeData(byArray2, 0, n);
                }
            }
            this.handleHandshakeMessage(s2, byArray2);
            bl = true;
        } while (bl);
    }

    private void processApplicationData() {
    }

    private void processAlert() throws IOException {
        while (this.alertQueue.size() >= 2) {
            byte[] byArray = new byte[2];
            this.alertQueue.read(byArray, 0, 2, 0);
            this.alertQueue.removeData(2);
            short s2 = byArray[0];
            short s3 = byArray[1];
            this.getPeer().notifyAlertReceived(s2, s3);
            if (s2 == 2) {
                this.failedWithError = true;
                this.closed = true;
                try {
                    this.recordStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (s3 == 0) {
                this.handleClose(false);
            }
            this.handleWarningMessage(s3);
        }
    }

    private void processChangeCipherSpec() throws IOException {
        while (this.changeCipherSpecQueue.size() > 0) {
            byte[] byArray = new byte[1];
            this.changeCipherSpecQueue.read(byArray, 0, 1, 0);
            this.changeCipherSpecQueue.removeData(1);
            if (byArray[0] != 1) {
                this.failWithError((short)2, (short)10);
            }
            this.recordStream.receivedReadCipherSpec();
            this.handleChangeCipherSpecMessage();
        }
    }

    protected int readApplicationData(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 1) {
            return 0;
        }
        while (this.applicationDataQueue.size() == 0) {
            if (this.closed) {
                if (this.failedWithError) {
                    throw new IOException(TLS_ERROR_MESSAGE);
                }
                return -1;
            }
            this.safeReadRecord();
        }
        n2 = Math.min(n2, this.applicationDataQueue.size());
        this.applicationDataQueue.read(byArray, n, n2, 0);
        this.applicationDataQueue.removeData(n2);
        return n2;
    }

    protected void safeReadRecord() throws IOException {
        try {
            this.recordStream.readRecord();
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            if (!this.closed) {
                this.failWithError((short)2, tlsFatalAlert.getAlertDescription());
            }
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw runtimeException;
        }
    }

    protected void safeWriteRecord(short s2, byte[] byArray, int n, int n2) throws IOException {
        try {
            this.recordStream.writeRecord(s2, byArray, n, n2);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            if (!this.closed) {
                this.failWithError((short)2, tlsFatalAlert.getAlertDescription());
            }
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw runtimeException;
        }
    }

    protected void writeData(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            if (this.failedWithError) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            throw new IOException("Sorry, connection has been closed, you cannot write more data");
        }
        while (n2 > 0) {
            if (this.writeExtraEmptyRecords) {
                this.safeWriteRecord((short)23, TlsUtils.EMPTY_BYTES, 0, 0);
            }
            int n3 = Math.min(n2, 16384);
            this.safeWriteRecord((short)23, byArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public OutputStream getOutputStream() {
        return this.tlsOutputStream;
    }

    public InputStream getInputStream() {
        return this.tlsInputStream;
    }

    protected void failWithError(short s2, short s3) throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (s2 == 2) {
                this.failedWithError = true;
            }
            this.raiseAlert(s2, s3, null, null);
            this.recordStream.close();
            if (s2 == 2) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
        } else {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
    }

    protected void processFinishedMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray = TlsUtils.readFully(this.expected_verify_data.length, (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!Arrays.constantTimeAreEqual(this.expected_verify_data, byArray)) {
            this.failWithError((short)2, (short)51);
        }
    }

    protected void raiseAlert(short s2, short s3, String string2, Exception exception) throws IOException {
        this.getPeer().notifyAlertRaised(s2, s3, string2, exception);
        byte[] byArray = new byte[]{(byte)s2, (byte)s3};
        this.safeWriteRecord((short)21, byArray, 0, 2);
    }

    protected void raiseWarning(short s2, String string2) throws IOException {
        this.raiseAlert((short)1, s2, string2, null);
    }

    protected void sendCertificateMessage(Certificate certificate) throws IOException {
        Object object;
        Object object2;
        if (certificate == null) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        if (certificate.getLength() == 0 && !(object2 = this.getContext()).isServer() && ((ProtocolVersion)(object = this.getContext().getServerVersion())).isSSL()) {
            String string2 = ((ProtocolVersion)object).toString() + " client didn't provide credentials";
            this.raiseWarning((short)41, string2);
            return;
        }
        object2 = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)11, (OutputStream)object2);
        TlsUtils.writeUint24(0, (OutputStream)object2);
        certificate.encode((OutputStream)object2);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        TlsUtils.writeUint24(((Object)object).length - 4, (byte[])object, 1);
        this.safeWriteRecord((short)22, (byte[])object, 0, ((Object)object).length);
    }

    protected void sendChangeCipherSpecMessage() throws IOException {
        byte[] byArray = new byte[]{1};
        this.safeWriteRecord((short)20, byArray, 0, byArray.length);
        this.recordStream.sentWriteCipherSpec();
    }

    protected void sendFinishedMessage() throws IOException {
        byte[] byArray = this.createVerifyData(this.getContext().isServer());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)20, byteArrayOutputStream);
        TlsUtils.writeUint24(byArray.length, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.safeWriteRecord((short)22, byArray2, 0, byArray2.length);
    }

    protected void sendSupplementalDataMessage(Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)23, byteArrayOutputStream);
        TlsUtils.writeUint24(0, byteArrayOutputStream);
        TlsProtocol.writeSupplementalData(byteArrayOutputStream, vector);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint24(byArray.length - 4, byArray, 1);
        this.safeWriteRecord((short)22, byArray, 0, byArray.length);
    }

    protected byte[] createVerifyData(boolean bl) {
        AbstractTlsContext abstractTlsContext = this.getContext();
        if (bl) {
            return TlsUtils.calculateVerifyData(abstractTlsContext, "server finished", this.recordStream.getCurrentHash(TlsUtils.SSL_SERVER));
        }
        return TlsUtils.calculateVerifyData(abstractTlsContext, "client finished", this.recordStream.getCurrentHash(TlsUtils.SSL_CLIENT));
    }

    public void close() throws IOException {
        this.handleClose(true);
    }

    protected void handleClose(boolean bl) throws IOException {
        if (!this.closed) {
            if (bl && !this.appDataReady) {
                this.raiseWarning((short)90, "User canceled handshake");
            }
            this.failWithError((short)1, (short)0);
        }
    }

    protected void flush() throws IOException {
        this.recordStream.flush();
    }

    protected static boolean arrayContains(short[] sArray, short s2) {
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != s2) continue;
            return true;
        }
        return false;
    }

    protected static boolean arrayContains(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    protected static void assertEmpty(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (byteArrayInputStream.available() > 0) {
            throw new TlsFatalAlert(50);
        }
    }

    protected static byte[] createRandomBlock(SecureRandom secureRandom) {
        byte[] byArray = new byte[32];
        secureRandom.nextBytes(byArray);
        TlsUtils.writeGMTUnixTime(byArray, 0);
        return byArray;
    }

    protected static byte[] createRenegotiationInfo(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeOpaque8(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void establishMasterSecret(TlsContext tlsContext, TlsKeyExchange tlsKeyExchange) throws IOException {
        byte[] byArray = tlsKeyExchange.generatePremasterSecret();
        try {
            tlsContext.getSecurityParameters().masterSecret = TlsUtils.calculateMasterSecret(tlsContext, byArray);
        }
        finally {
            if (byArray != null) {
                Arrays.fill(byArray, (byte)0);
            }
        }
    }

    protected static Hashtable readExtensions(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (byteArrayInputStream.available() < 1) {
            return null;
        }
        byte[] byArray = TlsUtils.readOpaque16(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
        Hashtable<Integer, byte[]> hashtable = new Hashtable<Integer, byte[]>();
        while (byteArrayInputStream2.available() > 0) {
            byte[] byArray2;
            Integer n = Integers.valueOf(TlsUtils.readUint16(byteArrayInputStream2));
            if (null == hashtable.put(n, byArray2 = TlsUtils.readOpaque16(byteArrayInputStream2))) continue;
            throw new TlsFatalAlert(47);
        }
        return hashtable;
    }

    protected static Vector readSupplementalDataMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque24(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
        Vector<SupplementalDataEntry> vector = new Vector<SupplementalDataEntry>();
        while (byteArrayInputStream2.available() > 0) {
            int n = TlsUtils.readUint16(byteArrayInputStream2);
            byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream2);
            vector.addElement(new SupplementalDataEntry(n, byArray2));
        }
        return vector;
    }

    protected static void writeExtensions(OutputStream outputStream, Hashtable hashtable) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (Integer)enumeration.nextElement();
            byte[] byArray = (byte[])hashtable.get(object);
            TlsUtils.writeUint16((Integer)object, byteArrayOutputStream);
            TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
        }
        object = byteArrayOutputStream.toByteArray();
        TlsUtils.writeOpaque16((byte[])object, outputStream);
    }

    protected static void writeSupplementalData(OutputStream outputStream, Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < vector.size(); ++i) {
            SupplementalDataEntry supplementalDataEntry = (SupplementalDataEntry)vector.elementAt(i);
            TlsUtils.writeUint16(supplementalDataEntry.getDataType(), byteArrayOutputStream);
            TlsUtils.writeOpaque16(supplementalDataEntry.getData(), byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeOpaque24(byArray, outputStream);
    }

    protected static int getPRFAlgorithm(int n) {
        switch (n) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: {
                return 1;
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: {
                return 2;
            }
        }
        return 0;
    }
}

