/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.bouncycastle.crypto.tls.TlsUtils;

class DeferredHash
implements TlsHandshakeHash {
    protected TlsContext context;
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private int prfAlgorithm = -1;
    private Digest hash = null;

    DeferredHash() {
        this.buf = new ByteArrayOutputStream();
        this.hash = null;
    }

    private DeferredHash(Digest digest) {
        this.buf = null;
        this.hash = digest;
    }

    public void init(TlsContext tlsContext) {
        this.context = tlsContext;
    }

    public TlsHandshakeHash commit() {
        int n = this.context.getSecurityParameters().getPrfAlgorithm();
        Digest digest = TlsUtils.createPRFHash(n);
        byte[] byArray = this.buf.toByteArray();
        digest.update(byArray, 0, byArray.length);
        if (digest instanceof TlsHandshakeHash) {
            TlsHandshakeHash tlsHandshakeHash = (TlsHandshakeHash)digest;
            tlsHandshakeHash.init(this.context);
            return tlsHandshakeHash.commit();
        }
        this.prfAlgorithm = n;
        this.hash = digest;
        this.buf = null;
        return this;
    }

    public TlsHandshakeHash fork() {
        this.checkHash();
        return new DeferredHash(TlsUtils.clonePRFHash(this.prfAlgorithm, this.hash));
    }

    public String getAlgorithmName() {
        this.checkHash();
        return this.hash.getAlgorithmName();
    }

    public int getDigestSize() {
        this.checkHash();
        return this.hash.getDigestSize();
    }

    public void update(byte by2) {
        if (this.hash == null) {
            this.buf.write(by2);
        } else {
            this.hash.update(by2);
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.hash == null) {
            this.buf.write(byArray, n, n2);
        } else {
            this.hash.update(byArray, n, n2);
        }
    }

    public int doFinal(byte[] byArray, int n) {
        this.checkHash();
        return this.hash.doFinal(byArray, n);
    }

    public void reset() {
        if (this.hash == null) {
            this.buf.reset();
        } else {
            this.hash.reset();
        }
    }

    protected void checkHash() {
        if (this.hash == null) {
            throw new IllegalStateException("No hash algorithm has been set");
        }
    }
}

