/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DTLSProtocol;
import org.bouncycastle.crypto.tls.DTLSRecordLayer;
import org.bouncycastle.crypto.tls.DTLSReliableHandshake;
import org.bouncycastle.crypto.tls.DTLSTransport;
import org.bouncycastle.crypto.tls.DatagramTransport;
import org.bouncycastle.crypto.tls.NewSessionTicket;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.bouncycastle.crypto.tls.TlsProtocol;
import org.bouncycastle.crypto.tls.TlsServer;
import org.bouncycastle.crypto.tls.TlsServerContextImpl;
import org.bouncycastle.crypto.tls.TlsSigner;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.util.Arrays;

public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public DTLSServerProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean bl) {
        this.verifyRequests = bl;
    }

    public DTLSTransport accept(TlsServer tlsServer, DatagramTransport datagramTransport) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.entity = 0;
        securityParameters.serverRandom = TlsProtocol.createRandomBlock(this.secureRandom);
        ServerHandshakeState serverHandshakeState = new ServerHandshakeState();
        serverHandshakeState.server = tlsServer;
        serverHandshakeState.serverContext = new TlsServerContextImpl(this.secureRandom, securityParameters);
        tlsServer.init(serverHandshakeState.serverContext);
        DTLSRecordLayer dTLSRecordLayer = new DTLSRecordLayer(datagramTransport, serverHandshakeState.serverContext, tlsServer, 22);
        try {
            return this.serverHandshake(serverHandshakeState, dTLSRecordLayer);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            dTLSRecordLayer.fail(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            dTLSRecordLayer.fail((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            dTLSRecordLayer.fail((short)80);
            throw new TlsFatalAlert(80);
        }
    }

    public DTLSTransport serverHandshake(ServerHandshakeState serverHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        Object object;
        byte[] byArray;
        SecurityParameters securityParameters = serverHandshakeState.serverContext.getSecurityParameters();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake(serverHandshakeState.serverContext, dTLSRecordLayer);
        DTLSReliableHandshake.Message message = dTLSReliableHandshake.receiveMessage();
        Object object2 = dTLSRecordLayer.getDiscoveredPeerVersion();
        serverHandshakeState.serverContext.setClientVersion((ProtocolVersion)object2);
        if (message.getType() != 1) {
            throw new TlsFatalAlert(10);
        }
        this.processClientHello(serverHandshakeState, message.getBody());
        object2 = this.generateServerHello(serverHandshakeState);
        dTLSReliableHandshake.sendMessage((short)2, (byte[])object2);
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm(serverHandshakeState.selectedCipherSuite);
        securityParameters.compressionAlgorithm = serverHandshakeState.selectedCompressionMethod;
        securityParameters.verifyDataLength = 12;
        dTLSReliableHandshake.notifyHelloComplete();
        Vector vector = serverHandshakeState.server.getServerSupplementalData();
        if (vector != null) {
            byArray = DTLSServerProtocol.generateSupplementalData(vector);
            dTLSReliableHandshake.sendMessage((short)23, byArray);
        }
        serverHandshakeState.keyExchange = serverHandshakeState.server.getKeyExchange();
        serverHandshakeState.keyExchange.init(serverHandshakeState.serverContext);
        serverHandshakeState.serverCredentials = serverHandshakeState.server.getCredentials();
        if (serverHandshakeState.serverCredentials == null) {
            serverHandshakeState.keyExchange.skipServerCredentials();
        } else {
            serverHandshakeState.keyExchange.processServerCredentials(serverHandshakeState.serverCredentials);
            byArray = DTLSServerProtocol.generateCertificate(serverHandshakeState.serverCredentials.getCertificate());
            dTLSReliableHandshake.sendMessage((short)11, byArray);
        }
        byArray = serverHandshakeState.keyExchange.generateServerKeyExchange();
        if (byArray != null) {
            dTLSReliableHandshake.sendMessage((short)12, byArray);
        }
        if (serverHandshakeState.serverCredentials != null) {
            serverHandshakeState.certificateRequest = serverHandshakeState.server.getCertificateRequest();
            if (serverHandshakeState.certificateRequest != null) {
                serverHandshakeState.keyExchange.validateCertificateRequest(serverHandshakeState.certificateRequest);
                object = this.generateCertificateRequest(serverHandshakeState, serverHandshakeState.certificateRequest);
                dTLSReliableHandshake.sendMessage((short)13, (byte[])object);
            }
        }
        dTLSReliableHandshake.sendMessage((short)14, TlsUtils.EMPTY_BYTES);
        message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() == 23) {
            this.processClientSupplementalData(serverHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            serverHandshakeState.server.processClientSupplementalData(null);
        }
        if (serverHandshakeState.certificateRequest == null) {
            serverHandshakeState.keyExchange.skipClientCredentials();
        } else if (message.getType() == 11) {
            this.processClientCertificate(serverHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            object = serverHandshakeState.serverContext.getServerVersion().getEquivalentTLSVersion();
            if (ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf((ProtocolVersion)object)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(serverHandshakeState, Certificate.EMPTY_CHAIN);
        }
        if (message.getType() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(serverHandshakeState, message.getBody());
        dTLSRecordLayer.initPendingEpoch(serverHandshakeState.server.getCipher());
        if (this.expectCertificateVerifyMessage(serverHandshakeState)) {
            object = dTLSReliableHandshake.getCurrentHash();
            message = dTLSReliableHandshake.receiveMessage();
            if (message.getType() == 15) {
                this.processCertificateVerify(serverHandshakeState, message.getBody(), (byte[])object);
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        object = dTLSReliableHandshake.getCurrentHash();
        message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() != 20) {
            throw new TlsFatalAlert(10);
        }
        Object object3 = TlsUtils.calculateVerifyData(serverHandshakeState.serverContext, "client finished", object);
        this.processFinished(message.getBody(), (byte[])object3);
        if (serverHandshakeState.expectSessionTicket) {
            object3 = serverHandshakeState.server.getNewSessionTicket();
            byte[] byArray2 = this.generateNewSessionTicket(serverHandshakeState, (NewSessionTicket)object3);
            dTLSReliableHandshake.sendMessage((short)4, byArray2);
        }
        object3 = TlsUtils.calculateVerifyData(serverHandshakeState.serverContext, "server finished", dTLSReliableHandshake.getCurrentHash());
        dTLSReliableHandshake.sendMessage((short)20, (byte[])object3);
        dTLSReliableHandshake.finish();
        serverHandshakeState.server.notifyHandshakeComplete();
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateRequest(ServerHandshakeState serverHandshakeState, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateNewSessionTicket(ServerHandshakeState serverHandshakeState, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        newSessionTicket.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateServerHello(ServerHandshakeState serverHandshakeState) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = serverHandshakeState.server.getServerVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(serverHandshakeState.serverContext.getClientVersion())) {
            throw new TlsFatalAlert(80);
        }
        serverHandshakeState.serverContext.setServerVersion(protocolVersion);
        TlsUtils.writeVersion(serverHandshakeState.serverContext.getServerVersion(), byteArrayOutputStream);
        byteArrayOutputStream.write(serverHandshakeState.serverContext.getSecurityParameters().serverRandom);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        serverHandshakeState.selectedCipherSuite = serverHandshakeState.server.getSelectedCipherSuite();
        if (!TlsProtocol.arrayContains(serverHandshakeState.offeredCipherSuites, serverHandshakeState.selectedCipherSuite) || serverHandshakeState.selectedCipherSuite == 0 || serverHandshakeState.selectedCipherSuite == 255) {
            throw new TlsFatalAlert(80);
        }
        DTLSServerProtocol.validateSelectedCipherSuite(serverHandshakeState.selectedCipherSuite, (short)80);
        serverHandshakeState.selectedCompressionMethod = serverHandshakeState.server.getSelectedCompressionMethod();
        if (!TlsProtocol.arrayContains(serverHandshakeState.offeredCompressionMethods, serverHandshakeState.selectedCompressionMethod)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint16(serverHandshakeState.selectedCipherSuite, byteArrayOutputStream);
        TlsUtils.writeUint8(serverHandshakeState.selectedCompressionMethod, byteArrayOutputStream);
        serverHandshakeState.serverExtensions = serverHandshakeState.server.getServerExtensions();
        if (serverHandshakeState.secure_renegotiation) {
            boolean bl;
            boolean bl2 = bl = serverHandshakeState.serverExtensions == null || !serverHandshakeState.serverExtensions.containsKey(TlsProtocol.EXT_RenegotiationInfo);
            if (bl) {
                if (serverHandshakeState.serverExtensions == null) {
                    serverHandshakeState.serverExtensions = new Hashtable();
                }
                serverHandshakeState.serverExtensions.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (serverHandshakeState.serverExtensions != null) {
            serverHandshakeState.expectSessionTicket = serverHandshakeState.serverExtensions.containsKey(TlsProtocol.EXT_SessionTicket);
            TlsProtocol.writeExtensions(byteArrayOutputStream, serverHandshakeState.serverExtensions);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void notifyClientCertificate(ServerHandshakeState serverHandshakeState, Certificate certificate) throws IOException {
        if (serverHandshakeState.certificateRequest == null) {
            throw new IllegalStateException();
        }
        if (serverHandshakeState.clientCertificate != null) {
            throw new TlsFatalAlert(10);
        }
        serverHandshakeState.clientCertificate = certificate;
        if (certificate.isEmpty()) {
            serverHandshakeState.keyExchange.skipClientCredentials();
        } else {
            serverHandshakeState.clientCertificateType = TlsUtils.getClientCertificateType(certificate, serverHandshakeState.serverCredentials.getCertificate());
            serverHandshakeState.keyExchange.processClientCertificate(certificate);
        }
        serverHandshakeState.server.notifyClientCertificate(certificate);
    }

    protected void processClientCertificate(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = Certificate.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(serverHandshakeState, certificate);
    }

    protected void processCertificateVerify(ServerHandshakeState serverHandshakeState, byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray3 = TlsUtils.readOpaque16(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        try {
            TlsSigner tlsSigner = TlsUtils.createTlsSigner(serverHandshakeState.clientCertificateType);
            tlsSigner.init(serverHandshakeState.serverContext);
            org.bouncycastle.asn1.x509.Certificate certificate = serverHandshakeState.clientCertificate.getCertificateAt(0);
            SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
            AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey(subjectPublicKeyInfo);
            tlsSigner.verifyRawSignature(byArray3, asymmetricKeyParameter, byArray2);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(51);
        }
    }

    protected void processClientHello(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray3 = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray4 = TlsUtils.readOpaque8(byteArrayInputStream);
        if (byArray4.length > 32) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray5 = TlsUtils.readOpaque8(byteArrayInputStream);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n < 2 || (n & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        serverHandshakeState.offeredCipherSuites = TlsUtils.readUint16Array(n / 2, byteArrayInputStream);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (s2 < 1) {
            throw new TlsFatalAlert(47);
        }
        serverHandshakeState.offeredCompressionMethods = TlsUtils.readUint8Array(s2, byteArrayInputStream);
        serverHandshakeState.clientExtensions = TlsProtocol.readExtensions(byteArrayInputStream);
        serverHandshakeState.serverContext.setClientVersion(protocolVersion);
        serverHandshakeState.server.notifyClientVersion(protocolVersion);
        serverHandshakeState.serverContext.getSecurityParameters().clientRandom = byArray3;
        serverHandshakeState.server.notifyOfferedCipherSuites(serverHandshakeState.offeredCipherSuites);
        serverHandshakeState.server.notifyOfferedCompressionMethods(serverHandshakeState.offeredCompressionMethods);
        if (TlsProtocol.arrayContains(serverHandshakeState.offeredCipherSuites, 255)) {
            serverHandshakeState.secure_renegotiation = true;
        }
        if (serverHandshakeState.clientExtensions != null && (byArray2 = (byte[])serverHandshakeState.clientExtensions.get(TlsProtocol.EXT_RenegotiationInfo)) != null) {
            serverHandshakeState.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual(byArray2, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        serverHandshakeState.server.notifySecureRenegotiation(serverHandshakeState.secure_renegotiation);
        if (serverHandshakeState.clientExtensions != null) {
            serverHandshakeState.server.processClientExtensions(serverHandshakeState.clientExtensions);
        }
    }

    protected void processClientKeyExchange(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        serverHandshakeState.keyExchange.processClientKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        TlsProtocol.establishMasterSecret(serverHandshakeState.serverContext, serverHandshakeState.keyExchange);
    }

    protected void processClientSupplementalData(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        serverHandshakeState.server.processClientSupplementalData(vector);
    }

    protected boolean expectCertificateVerifyMessage(ServerHandshakeState serverHandshakeState) {
        return serverHandshakeState.clientCertificateType >= 0 && TlsUtils.hasSigningCapability(serverHandshakeState.clientCertificateType);
    }

    protected static class ServerHandshakeState {
        TlsServer server = null;
        TlsServerContextImpl serverContext = null;
        int[] offeredCipherSuites;
        short[] offeredCompressionMethods;
        Hashtable clientExtensions;
        int selectedCipherSuite = -1;
        short selectedCompressionMethod = (short)-1;
        boolean secure_renegotiation = false;
        boolean expectSessionTicket = false;
        Hashtable serverExtensions = null;
        TlsKeyExchange keyExchange = null;
        TlsCredentials serverCredentials = null;
        CertificateRequest certificateRequest = null;
        short clientCertificateType = (short)-1;
        Certificate clientCertificate = null;

        protected ServerHandshakeState() {
        }
    }
}

