/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;

public class DSTU4145Signer
implements DSA {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private ECKeyParameters key;
    private SecureRandom random;

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.random = parametersWithRandom.getRandom();
                cipherParameters = parametersWithRandom.getParameters();
            } else {
                this.random = new SecureRandom();
            }
            this.key = (ECPrivateKeyParameters)cipherParameters;
        } else {
            this.key = (ECPublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        ECFieldElement eCFieldElement = DSTU4145Signer.hash2FieldElement(this.key.getParameters().getCurve(), byArray);
        if (eCFieldElement.toBigInteger().signum() == 0) {
            eCFieldElement = this.key.getParameters().getCurve().fromBigInteger(ONE);
        }
        while (true) {
            BigInteger bigInteger3 = DSTU4145Signer.generateRandomInteger(this.key.getParameters().getN(), this.random);
            ECFieldElement eCFieldElement2 = this.key.getParameters().getG().multiply(bigInteger3).getX();
            if (eCFieldElement2.toBigInteger().signum() == 0) continue;
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(eCFieldElement2);
            bigInteger2 = DSTU4145Signer.fieldElement2Integer(this.key.getParameters().getN(), eCFieldElement3);
            if (bigInteger2.signum() != 0 && (bigInteger = bigInteger2.multiply(((ECPrivateKeyParameters)this.key).getD()).add(bigInteger3).mod(this.key.getParameters().getN())).signum() != 0) break;
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        if (bigInteger.signum() == 0 || bigInteger2.signum() == 0) {
            return false;
        }
        if (bigInteger.compareTo(this.key.getParameters().getN()) >= 0 || bigInteger2.compareTo(this.key.getParameters().getN()) >= 0) {
            return false;
        }
        ECFieldElement eCFieldElement = DSTU4145Signer.hash2FieldElement(this.key.getParameters().getCurve(), byArray);
        if (eCFieldElement.toBigInteger().signum() == 0) {
            eCFieldElement = this.key.getParameters().getCurve().fromBigInteger(ONE);
        }
        if ((eCPoint = ECAlgorithms.sumOfTwoMultiplies(this.key.getParameters().getG(), bigInteger2, ((ECPublicKeyParameters)this.key).getQ(), bigInteger)).isInfinity()) {
            return false;
        }
        ECFieldElement eCFieldElement2 = eCFieldElement.multiply(eCPoint.getX());
        return DSTU4145Signer.fieldElement2Integer(this.key.getParameters().getN(), eCFieldElement2).compareTo(bigInteger) == 0;
    }

    private static BigInteger generateRandomInteger(BigInteger bigInteger, SecureRandom secureRandom) {
        return new BigInteger(bigInteger.bitLength() - 1, secureRandom);
    }

    private static void reverseBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length / 2; ++i) {
            byte by2 = byArray[i];
            byArray[i] = byArray[byArray.length - 1 - i];
            byArray[byArray.length - 1 - i] = by2;
        }
    }

    private static ECFieldElement hash2FieldElement(ECCurve eCCurve, byte[] byArray) {
        byte[] byArray2 = Arrays.clone(byArray);
        DSTU4145Signer.reverseBytes(byArray2);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        while (bigInteger.bitLength() >= eCCurve.getFieldSize()) {
            bigInteger = bigInteger.clearBit(bigInteger.bitLength() - 1);
        }
        return eCCurve.fromBigInteger(bigInteger);
    }

    private static BigInteger fieldElement2Integer(BigInteger bigInteger, ECFieldElement eCFieldElement) {
        BigInteger bigInteger2 = eCFieldElement.toBigInteger();
        while (bigInteger2.bitLength() >= bigInteger.bitLength()) {
            bigInteger2 = bigInteger2.clearBit(bigInteger2.bitLength() - 1);
        }
        return bigInteger2;
    }
}

