/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.OIDTokenizer;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;

public class DERObjectIdentifier
extends ASN1Primitive {
    String identifier;
    private byte[] body;
    private static final long LONG_LIMIT = 0xFFFFFFFFFFFF80L;
    private static ASN1ObjectIdentifier[][] cache = new ASN1ObjectIdentifier[256][];

    public static ASN1ObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)object;
        }
        if (object instanceof DERObjectIdentifier) {
            return new ASN1ObjectIdentifier(((DERObjectIdentifier)object).getId());
        }
        if (object instanceof ASN1Encodable && ((ASN1Encodable)object).toASN1Primitive() instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)((ASN1Encodable)object).toASN1Primitive();
        }
        if (object instanceof byte[]) {
            return ASN1ObjectIdentifier.fromOctetString((byte[])object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl || aSN1Primitive instanceof DERObjectIdentifier) {
            return DERObjectIdentifier.getInstance(aSN1Primitive);
        }
        return ASN1ObjectIdentifier.fromOctetString(ASN1OctetString.getInstance(aSN1TaggedObject.getObject()).getOctets());
    }

    DERObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        BigInteger bigInteger = null;
        boolean bl = true;
        for (int i = 0; i != byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (l <= 0xFFFFFFFFFFFF80L) {
                l += (long)(n & 0x7F);
                if ((n & 0x80) == 0) {
                    if (bl) {
                        if (l < 40L) {
                            stringBuffer.append('0');
                        } else if (l < 80L) {
                            stringBuffer.append('1');
                            l -= 40L;
                        } else {
                            stringBuffer.append('2');
                            l -= 80L;
                        }
                        bl = false;
                    }
                    stringBuffer.append('.');
                    stringBuffer.append(l);
                    l = 0L;
                    continue;
                }
                l <<= 7;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l);
            }
            bigInteger = bigInteger.or(BigInteger.valueOf(n & 0x7F));
            if ((n & 0x80) == 0) {
                if (bl) {
                    stringBuffer.append('2');
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(80L));
                    bl = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(bigInteger);
                bigInteger = null;
                l = 0L;
                continue;
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
        this.identifier = stringBuffer.toString();
        this.body = Arrays.clone(byArray);
    }

    public DERObjectIdentifier(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("'identifier' cannot be null");
        }
        if (!DERObjectIdentifier.isValidIdentifier(string2)) {
            throw new IllegalArgumentException("string " + string2 + " not an OID");
        }
        this.identifier = string2;
    }

    DERObjectIdentifier(DERObjectIdentifier dERObjectIdentifier, String string2) {
        if (!DERObjectIdentifier.isValidBranchID(string2, 0)) {
            throw new IllegalArgumentException("string " + string2 + " not a valid OID branch");
        }
        this.identifier = dERObjectIdentifier.getId() + "." + string2;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(ByteArrayOutputStream byteArrayOutputStream, long l) {
        byte[] byArray = new byte[9];
        int n = 8;
        byArray[n] = (byte)((int)l & 0x7F);
        while (l >= 128L) {
            byArray[--n] = (byte)((int)(l >>= 7) & 0x7F | 0x80);
        }
        byteArrayOutputStream.write(byArray, n, 9 - n);
    }

    private void writeField(ByteArrayOutputStream byteArrayOutputStream, BigInteger bigInteger) {
        int n = (bigInteger.bitLength() + 6) / 7;
        if (n == 0) {
            byteArrayOutputStream.write(0);
        } else {
            BigInteger bigInteger2 = bigInteger;
            byte[] byArray = new byte[n];
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)(bigInteger2.intValue() & 0x7F | 0x80);
                bigInteger2 = bigInteger2.shiftRight(7);
            }
            int n2 = n - 1;
            byArray[n2] = (byte)(byArray[n2] & 0x7F);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
    }

    private void doOutput(ByteArrayOutputStream byteArrayOutputStream) {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.identifier);
        int n = Integer.parseInt(oIDTokenizer.nextToken()) * 40;
        String string2 = oIDTokenizer.nextToken();
        if (string2.length() <= 18) {
            this.writeField(byteArrayOutputStream, (long)n + Long.parseLong(string2));
        } else {
            this.writeField(byteArrayOutputStream, new BigInteger(string2).add(BigInteger.valueOf(n)));
        }
        while (oIDTokenizer.hasMoreTokens()) {
            String string3 = oIDTokenizer.nextToken();
            if (string3.length() <= 18) {
                this.writeField(byteArrayOutputStream, Long.parseLong(string3));
                continue;
            }
            this.writeField(byteArrayOutputStream, new BigInteger(string3));
        }
    }

    protected synchronized byte[] getBody() {
        if (this.body == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.doOutput(byteArrayOutputStream);
            this.body = byteArrayOutputStream.toByteArray();
        }
        return this.body;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() throws IOException {
        int n = this.getBody().length;
        return 1 + StreamUtil.calculateBodyLength(n) + n;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        byte[] byArray = this.getBody();
        aSN1OutputStream.write(6);
        aSN1OutputStream.writeLength(byArray.length);
        aSN1OutputStream.write(byArray);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)aSN1Primitive).identifier);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isValidBranchID(String string2, int n) {
        boolean bl = false;
        int n2 = string2.length();
        while (--n2 >= n) {
            char c = string2.charAt(n2);
            if ('0' <= c && c <= '9') {
                bl = true;
                continue;
            }
            if (c == '.') {
                if (!bl) {
                    return false;
                }
                bl = false;
                continue;
            }
            return false;
        }
        return bl;
    }

    private static boolean isValidIdentifier(String string2) {
        if (string2.length() < 3 || string2.charAt(1) != '.') {
            return false;
        }
        char c = string2.charAt(0);
        if (c < '0' || c > '2') {
            return false;
        }
        return DERObjectIdentifier.isValidBranchID(string2, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ASN1ObjectIdentifier fromOctetString(byte[] byArray) {
        if (byArray.length < 3) {
            return new ASN1ObjectIdentifier(byArray);
        }
        int n = byArray[byArray.length - 2] & 0xFF;
        int n2 = byArray[byArray.length - 1] & 0x7F;
        ASN1ObjectIdentifier[][] aSN1ObjectIdentifierArray = cache;
        synchronized (cache) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray2 = cache[n];
            if (aSN1ObjectIdentifierArray2 == null) {
                DERObjectIdentifier.cache[n] = new ASN1ObjectIdentifier[128];
                aSN1ObjectIdentifierArray2 = DERObjectIdentifier.cache[n];
            }
            if ((aSN1ObjectIdentifier = aSN1ObjectIdentifierArray2[n2]) == null) {
                aSN1ObjectIdentifierArray2[n2] = new ASN1ObjectIdentifier(byArray);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return aSN1ObjectIdentifierArray2[n2];
            }
            if (Arrays.areEqual(byArray, aSN1ObjectIdentifier.getBody())) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return aSN1ObjectIdentifier;
            }
            aSN1ObjectIdentifierArray2 = cache[n = n + 1 & 0xFF];
            if (aSN1ObjectIdentifierArray2 == null) {
                DERObjectIdentifier.cache[n] = new ASN1ObjectIdentifier[128];
                aSN1ObjectIdentifierArray2 = DERObjectIdentifier.cache[n];
            }
            if ((aSN1ObjectIdentifier = aSN1ObjectIdentifierArray2[n2]) == null) {
                aSN1ObjectIdentifierArray2[n2] = new ASN1ObjectIdentifier(byArray);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return aSN1ObjectIdentifierArray2[n2];
            }
            if (Arrays.areEqual(byArray, aSN1ObjectIdentifier.getBody())) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return aSN1ObjectIdentifier;
            }
            aSN1ObjectIdentifier = aSN1ObjectIdentifierArray2[n2 = n2 + 1 & 0x7F];
            if (aSN1ObjectIdentifier == null) {
                aSN1ObjectIdentifierArray2[n2] = new ASN1ObjectIdentifier(byArray);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return aSN1ObjectIdentifierArray2[n2];
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (Arrays.areEqual(byArray, aSN1ObjectIdentifier.getBody())) {
                return aSN1ObjectIdentifier;
            }
            return new ASN1ObjectIdentifier(byArray);
        }
    }
}

