/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import org.apache.tika.mime.Clause;
import org.apache.tika.mime.MimeType;

class Magic
implements Clause,
Comparable<Magic> {
    private final MimeType type;
    private final int priority;
    private final Clause clause;
    private final String string;

    Magic(MimeType type, int priority, Clause clause) {
        this.type = type;
        this.priority = priority;
        this.clause = clause;
        this.string = "[" + priority + "/" + clause + "]";
    }

    MimeType getType() {
        return this.type;
    }

    int getPriority() {
        return this.priority;
    }

    @Override
    public boolean eval(byte[] data2) {
        return this.clause.eval(data2);
    }

    @Override
    public int size() {
        return this.clause.size();
    }

    public String toString() {
        return this.string;
    }

    @Override
    public int compareTo(Magic o) {
        int diff2 = o.priority - this.priority;
        if (diff2 == 0) {
            diff2 = o.size() - this.size();
        }
        if (diff2 == 0) {
            diff2 = o.type.compareTo(this.type);
        }
        if (diff2 == 0) {
            diff2 = o.string.compareTo(this.string);
        }
        return diff2;
    }

    public boolean equals(Object o) {
        if (o instanceof Magic) {
            Magic that = (Magic)o;
            return this.type.equals(that.type) && this.string.equals(that.string);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.string.hashCode();
    }
}

