/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class IOUtils {
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(Reader input2) {
        try {
            if (input2 != null) {
                input2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Channel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream input2) {
        try {
            if (input2 != null) {
                input2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream input2) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input2, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input2) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input2, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input2, String encoding) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input2, output, encoding);
        return output.toByteArray();
    }

    @Deprecated
    public static byte[] toByteArray(String input2) throws IOException {
        return input2.getBytes(UTF_8);
    }

    public static char[] toCharArray(InputStream is) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.copy(is, (Writer)output);
        return output.toCharArray();
    }

    public static char[] toCharArray(InputStream is, String encoding) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.copy(is, output, encoding);
        return output.toCharArray();
    }

    public static char[] toCharArray(Reader input2) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IOUtils.copy(input2, (Writer)sw);
        return sw.toCharArray();
    }

    public static String toString(InputStream input2) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input2, (Writer)sw);
        return sw.toString();
    }

    public static String toString(InputStream input2, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input2, sw, encoding);
        return sw.toString();
    }

    public static String toString(Reader input2) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input2, (Writer)sw);
        return sw.toString();
    }

    @Deprecated
    public static String toString(byte[] input2) throws IOException {
        return new String(input2, UTF_8);
    }

    @Deprecated
    public static String toString(byte[] input2, String encoding) throws IOException {
        if (encoding == null) {
            return new String(input2, UTF_8);
        }
        return new String(input2, encoding);
    }

    public static List<String> readLines(InputStream input2) throws IOException {
        InputStreamReader reader = new InputStreamReader(input2, UTF_8);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(InputStream input2, String encoding) throws IOException {
        if (encoding == null) {
            return IOUtils.readLines(input2);
        }
        InputStreamReader reader = new InputStreamReader(input2, encoding);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(Reader input2) throws IOException {
        BufferedReader reader = new BufferedReader(input2);
        ArrayList<String> list2 = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list2.add(line);
            line = reader.readLine();
        }
        return list2;
    }

    public static InputStream toInputStream(CharSequence input2) {
        return IOUtils.toInputStream(input2.toString());
    }

    public static InputStream toInputStream(CharSequence input2, String encoding) throws IOException {
        return IOUtils.toInputStream(input2.toString(), encoding);
    }

    public static InputStream toInputStream(String input2) {
        byte[] bytes = input2.getBytes(UTF_8);
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream toInputStream(String input2, String encoding) throws IOException {
        byte[] bytes = encoding != null ? input2.getBytes(encoding) : input2.getBytes(UTF_8);
        return new ByteArrayInputStream(bytes);
    }

    public static void write(byte[] data2, OutputStream output) throws IOException {
        if (data2 != null) {
            output.write(data2);
        }
    }

    public static void write(byte[] data2, Writer output) throws IOException {
        if (data2 != null) {
            output.write(new String(data2, UTF_8));
        }
    }

    public static void write(byte[] data2, Writer output, String encoding) throws IOException {
        if (data2 != null) {
            if (encoding == null) {
                IOUtils.write(data2, output);
            } else {
                output.write(new String(data2, encoding));
            }
        }
    }

    public static void write(char[] data2, Writer output) throws IOException {
        if (data2 != null) {
            output.write(data2);
        }
    }

    public static void write(char[] data2, OutputStream output) throws IOException {
        if (data2 != null) {
            output.write(new String(data2).getBytes(UTF_8));
        }
    }

    public static void write(char[] data2, OutputStream output, String encoding) throws IOException {
        if (data2 != null) {
            if (encoding == null) {
                IOUtils.write(data2, output);
            } else {
                output.write(new String(data2).getBytes(encoding));
            }
        }
    }

    public static void write(CharSequence data2, Writer output) throws IOException {
        if (data2 != null) {
            IOUtils.write(data2.toString(), output);
        }
    }

    public static void write(CharSequence data2, OutputStream output) throws IOException {
        if (data2 != null) {
            IOUtils.write(data2.toString(), output);
        }
    }

    public static void write(CharSequence data2, OutputStream output, String encoding) throws IOException {
        if (data2 != null) {
            IOUtils.write(data2.toString(), output, encoding);
        }
    }

    public static void write(String data2, Writer output) throws IOException {
        if (data2 != null) {
            output.write(data2);
        }
    }

    public static void write(String data2, OutputStream output) throws IOException {
        if (data2 != null) {
            output.write(data2.getBytes(UTF_8));
        }
    }

    public static void write(String data2, OutputStream output, String encoding) throws IOException {
        if (data2 != null) {
            if (encoding == null) {
                IOUtils.write(data2, output);
            } else {
                output.write(data2.getBytes(encoding));
            }
        }
    }

    @Deprecated
    public static void write(StringBuffer data2, Writer output) throws IOException {
        if (data2 != null) {
            output.write(data2.toString());
        }
    }

    @Deprecated
    public static void write(StringBuffer data2, OutputStream output) throws IOException {
        if (data2 != null) {
            output.write(data2.toString().getBytes(UTF_8));
        }
    }

    @Deprecated
    public static void write(StringBuffer data2, OutputStream output, String encoding) throws IOException {
        if (data2 != null) {
            if (encoding == null) {
                IOUtils.write(data2, output);
            } else {
                output.write(data2.toString().getBytes(encoding));
            }
        }
    }

    public static int copy(InputStream input2, OutputStream output) throws IOException {
        long count2 = IOUtils.copyLarge(input2, output);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copyLarge(InputStream input2, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count2 = 0L;
        int n = 0;
        while (-1 != (n = input2.read(buffer))) {
            output.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static void copy(InputStream input2, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input2, UTF_8);
        IOUtils.copy((Reader)in, output);
    }

    public static void copy(InputStream input2, Writer output, String encoding) throws IOException {
        if (encoding == null) {
            IOUtils.copy(input2, output);
        } else {
            InputStreamReader in = new InputStreamReader(input2, encoding);
            IOUtils.copy((Reader)in, output);
        }
    }

    public static int copy(Reader input2, Writer output) throws IOException {
        long count2 = IOUtils.copyLarge(input2, output);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copyLarge(Reader input2, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count2 = 0L;
        int n = 0;
        while (-1 != (n = input2.read(buffer))) {
            output.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static void copy(Reader input2, OutputStream output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output, UTF_8);
        IOUtils.copy(input2, (Writer)out);
        out.flush();
    }

    public static void copy(Reader input2, OutputStream output, String encoding) throws IOException {
        if (encoding == null) {
            IOUtils.copy(input2, output);
        } else {
            OutputStreamWriter out = new OutputStreamWriter(output, encoding);
            IOUtils.copy(input2, (Writer)out);
            out.flush();
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedReader)) {
            input1 = new BufferedReader(input1);
        }
        if (!(input2 instanceof BufferedReader)) {
            input2 = new BufferedReader(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }
}

