/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fork;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tika.fork.ForkResource;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class ContentHandlerResource
implements ForkResource {
    private final ContentHandler handler;

    public ContentHandlerResource(ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public Throwable process(DataInputStream input2, DataOutputStream output) throws IOException {
        try {
            this.internalProcess(input2);
            return null;
        }
        catch (SAXException e) {
            return e;
        }
    }

    private void internalProcess(DataInputStream input2) throws IOException, SAXException {
        int type = input2.readUnsignedByte();
        if (type == 1) {
            this.handler.startDocument();
        } else if (type == 2) {
            this.handler.endDocument();
        } else if (type == 3) {
            this.handler.startPrefixMapping(this.readString(input2), this.readString(input2));
        } else if (type == 4) {
            this.handler.endPrefixMapping(this.readString(input2));
        } else if (type == 5) {
            String uri = this.readString(input2);
            String localName = this.readString(input2);
            String qName = this.readString(input2);
            AttributesImpl atts = null;
            int n = input2.readInt();
            if (n >= 0) {
                atts = new AttributesImpl();
                for (int i = 0; i < n; ++i) {
                    atts.addAttribute(this.readString(input2), this.readString(input2), this.readString(input2), this.readString(input2), this.readString(input2));
                }
            }
            this.handler.startElement(uri, localName, qName, atts);
        } else if (type == 6) {
            String uri = this.readString(input2);
            String localName = this.readString(input2);
            String qName = this.readString(input2);
            this.handler.endElement(uri, localName, qName);
        } else if (type == 7) {
            char[] ch = this.readCharacters(input2);
            this.handler.characters(ch, 0, ch.length);
        } else if (type == 8) {
            char[] ch = this.readCharacters(input2);
            this.handler.characters(ch, 0, ch.length);
        } else if (type == 9) {
            this.handler.processingInstruction(this.readString(input2), this.readString(input2));
        } else if (type == 10) {
            this.handler.skippedEntity(this.readString(input2));
        }
    }

    private String readString(DataInputStream input2) throws IOException {
        if (input2.readBoolean()) {
            return input2.readUTF();
        }
        return null;
    }

    private char[] readCharacters(DataInputStream input2) throws IOException {
        int n = input2.readInt();
        char[] ch = new char[n];
        for (int i = 0; i < n; ++i) {
            ch[i] = input2.readChar();
        }
        return ch;
    }
}

