/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.TriConsumer;

@AsynchronouslyFormattable
@PerformanceSensitive(value={"allocation"})
public class MapMessage<M extends MapMessage<M, V>, V>
implements MultiformatMessage,
StringBuilderFormattable {
    private static final long serialVersionUID = -5031471831131487120L;
    private final IndexedStringMap data;

    public MapMessage() {
        this.data = new SortedArrayStringMap();
    }

    public MapMessage(int initialCapacity) {
        this.data = new SortedArrayStringMap(initialCapacity);
    }

    public MapMessage(Map<String, V> map2) {
        this.data = new SortedArrayStringMap(map2);
    }

    @Override
    public String[] getFormats() {
        return MapFormat.names();
    }

    @Override
    public Object[] getParameters() {
        Object[] result2 = new Object[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            result2[i] = this.data.getValueAt(i);
        }
        return result2;
    }

    @Override
    public String getFormat() {
        return "";
    }

    public Map<String, V> getData() {
        TreeMap result2 = new TreeMap();
        for (int i = 0; i < this.data.size(); ++i) {
            result2.put(this.data.getKeyAt(i), this.data.getValueAt(i));
        }
        return Collections.unmodifiableMap(result2);
    }

    public IndexedReadOnlyStringMap getIndexedReadOnlyStringMap() {
        return this.data;
    }

    public void clear() {
        this.data.clear();
    }

    public boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    public void put(String key, String value2) {
        if (value2 == null) {
            throw new IllegalArgumentException("No value provided for key " + key);
        }
        this.validate(key, value2);
        this.data.putValue(key, value2);
    }

    public void putAll(Map<String, String> map2) {
        for (Map.Entry<String, String> entry2 : map2.entrySet()) {
            this.data.putValue(entry2.getKey(), entry2.getValue());
        }
    }

    public String get(String key) {
        return (String)this.data.getValue(key);
    }

    public String remove(String key) {
        String result2 = (String)this.data.getValue(key);
        this.data.remove(key);
        return result2;
    }

    public String asString() {
        return this.format(null, new StringBuilder()).toString();
    }

    public String asString(String format2) {
        try {
            return this.format(EnglishEnums.valueOf(MapFormat.class, format2), new StringBuilder()).toString();
        }
        catch (IllegalArgumentException ex) {
            return this.asString();
        }
    }

    public <CV> void forEach(BiConsumer<String, ? super CV> action) {
        this.data.forEach(action);
    }

    public <CV, S> void forEach(TriConsumer<String, ? super CV, S> action, S state) {
        this.data.forEach(action, state);
    }

    private StringBuilder format(MapFormat format2, StringBuilder sb) {
        if (format2 == null) {
            this.appendMap(sb);
        } else {
            switch (format2) {
                case XML: {
                    this.asXml(sb);
                    break;
                }
                case JSON: {
                    this.asJson(sb);
                    break;
                }
                case JAVA: {
                    this.asJava(sb);
                    break;
                }
                default: {
                    this.appendMap(sb);
                }
            }
        }
        return sb;
    }

    public void asXml(StringBuilder sb) {
        sb.append("<Map>\n");
        for (int i = 0; i < this.data.size(); ++i) {
            sb.append("  <Entry key=\"").append(this.data.getKeyAt(i)).append("\">").append((String)this.data.getValueAt(i)).append("</Entry>\n");
        }
        sb.append("</Map>");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString();
    }

    @Override
    public String getFormattedMessage(String[] formats) {
        if (formats == null || formats.length == 0) {
            return this.asString();
        }
        for (int i = 0; i < formats.length; ++i) {
            MapFormat mapFormat = MapFormat.lookupIgnoreCase(formats[i]);
            if (mapFormat == null) continue;
            return this.format(mapFormat, new StringBuilder()).toString();
        }
        return this.asString();
    }

    protected void appendMap(StringBuilder sb) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            StringBuilders.appendKeyDqValue(sb, this.data.getKeyAt(i), this.data.getValueAt(i));
        }
    }

    protected void asJson(StringBuilder sb) {
        sb.append('{');
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            StringBuilders.appendDqValue(sb, this.data.getKeyAt(i)).append(':');
            StringBuilders.appendDqValue(sb, this.data.getValueAt(i));
        }
        sb.append('}');
    }

    protected void asJava(StringBuilder sb) {
        sb.append('{');
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            StringBuilders.appendKeyDqValue(sb, this.data.getKeyAt(i), this.data.getValueAt(i));
        }
        sb.append('}');
    }

    public M newInstance(Map<String, V> map2) {
        return (M)new MapMessage<M, V>(map2);
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        this.format(null, buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapMessage that = (MapMessage)o;
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    protected void validate(String key, boolean value2) {
    }

    protected void validate(String key, byte value2) {
    }

    protected void validate(String key, char value2) {
    }

    protected void validate(String key, double value2) {
    }

    protected void validate(String key, float value2) {
    }

    protected void validate(String key, int value2) {
    }

    protected void validate(String key, long value2) {
    }

    protected void validate(String key, Object value2) {
    }

    protected void validate(String key, short value2) {
    }

    protected void validate(String key, String value2) {
    }

    public M with(String key, boolean value2) {
        this.validate(key, value2);
        this.data.putValue(key, value2);
        return (M)this;
    }

    public M with(String key, byte value2) {
        this.validate(key, value2);
        this.data.putValue(key, value2);
        return (M)this;
    }

    public M with(String key, char value2) {
        this.validate(key, value2);
        this.data.putValue(key, Character.valueOf(value2));
        return (M)this;
    }

    public M with(String key, double value2) {
        this.validate(key, value2);
        this.data.putValue(key, value2);
        return (M)this;
    }

    public M with(String key, float value2) {
        this.validate(key, value2);
        this.data.putValue(key, Float.valueOf(value2));
        return (M)this;
    }

    public M with(String key, int value2) {
        this.validate(key, value2);
        this.data.putValue(key, value2);
        return (M)this;
    }

    public M with(String key, long value2) {
        this.validate(key, value2);
        this.data.putValue(key, value2);
        return (M)this;
    }

    public M with(String key, Object value2) {
        this.validate(key, value2);
        this.data.putValue(key, value2);
        return (M)this;
    }

    public M with(String key, short value2) {
        this.validate(key, value2);
        this.data.putValue(key, value2);
        return (M)this;
    }

    public M with(String key, String value2) {
        this.put(key, value2);
        return (M)this;
    }

    public static enum MapFormat {
        XML,
        JSON,
        JAVA;


        public static MapFormat lookupIgnoreCase(String format2) {
            return XML.name().equalsIgnoreCase(format2) ? XML : (JSON.name().equalsIgnoreCase(format2) ? JSON : (JAVA.name().equalsIgnoreCase(format2) ? JAVA : null));
        }

        public static String[] names() {
            return new String[]{XML.name(), JSON.name(), JAVA.name()};
        }
    }
}

