/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.lang.reflect.Array;

public final class CyclicBuffer<T> {
    private final T[] ring;
    private int first = 0;
    private int last = 0;
    private int numElems = 0;
    private final Class<T> clazz;

    public CyclicBuffer(Class<T> clazz, int size2) throws IllegalArgumentException {
        if (size2 < 0) {
            throw new IllegalArgumentException("The maxSize argument (" + size2 + ") cannot be negative.");
        }
        this.ring = this.makeArray(clazz, size2);
        this.clazz = clazz;
    }

    private T[] makeArray(Class<T> cls, int size2) {
        return (Object[])Array.newInstance(cls, size2);
    }

    public synchronized void add(T item) {
        if (this.ring.length > 0) {
            this.ring[this.last] = item;
            if (++this.last == this.ring.length) {
                this.last = 0;
            }
            if (this.numElems < this.ring.length) {
                ++this.numElems;
            } else if (++this.first == this.ring.length) {
                this.first = 0;
            }
        }
    }

    public synchronized T[] removeAll() {
        T[] array = this.makeArray(this.clazz, this.numElems);
        int index2 = 0;
        while (this.numElems > 0) {
            --this.numElems;
            array[index2++] = this.ring[this.first];
            this.ring[this.first] = null;
            if (++this.first != this.ring.length) continue;
            this.first = 0;
        }
        return array;
    }

    public boolean isEmpty() {
        return 0 == this.numElems;
    }
}

