/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rewrite;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="MapRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public final class MapRewritePolicy
implements RewritePolicy {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private final Map<String, Object> map;
    private final Mode mode;

    private MapRewritePolicy(Map<String, Object> map2, Mode mode) {
        this.map = map2;
        this.mode = mode;
    }

    @Override
    public LogEvent rewrite(LogEvent source) {
        Message msg = source.getMessage();
        if (msg == null || !(msg instanceof MapMessage)) {
            return source;
        }
        MapMessage mapMsg = (MapMessage)msg;
        HashMap<String, Object> newMap = new HashMap<String, Object>(mapMsg.getData());
        switch (this.mode) {
            case Add: {
                newMap.putAll(this.map);
                break;
            }
            default: {
                for (Map.Entry<String, Object> entry2 : this.map.entrySet()) {
                    if (!newMap.containsKey(entry2.getKey())) continue;
                    newMap.put(entry2.getKey(), entry2.getValue());
                }
            }
        }
        Object message = mapMsg.newInstance(newMap);
        Log4jLogEvent result2 = new Log4jLogEvent.Builder(source).setMessage((Message)message).build();
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("mode=").append((Object)this.mode);
        sb.append(" {");
        boolean first = true;
        for (Map.Entry<String, Object> entry2 : this.map.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(entry2.getKey()).append('=').append(entry2.getValue());
            first = false;
        }
        sb.append('}');
        return sb.toString();
    }

    @PluginFactory
    public static MapRewritePolicy createPolicy(@PluginAttribute(value="mode") String mode, @PluginElement(value="KeyValuePair") KeyValuePair[] pairs) {
        Mode op;
        Mode mode2 = op = mode == null ? (op = Mode.Add) : Mode.valueOf(mode);
        if (pairs == null || pairs.length == 0) {
            LOGGER.error("keys and values must be specified for the MapRewritePolicy");
            return null;
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        for (KeyValuePair pair2 : pairs) {
            String key = pair2.getKey();
            if (key == null) {
                LOGGER.error("A null key is not valid in MapRewritePolicy");
                continue;
            }
            String value2 = pair2.getValue();
            if (value2 == null) {
                LOGGER.error("A null value for key " + key + " is not allowed in MapRewritePolicy");
                continue;
            }
            map2.put(pair2.getKey(), pair2.getValue());
        }
        if (map2.isEmpty()) {
            LOGGER.error("MapRewritePolicy is not configured with any valid key value pairs");
            return null;
        }
        return new MapRewritePolicy(map2, op);
    }

    public static enum Mode {
        Add,
        Update;

    }
}

