/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jpa.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import javax.persistence.PersistenceException;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.Strings;

@Converter(autoApply=false)
public class ContextDataJsonAttributeConverter
implements AttributeConverter<ReadOnlyStringMap, String> {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public String convertToDatabaseColumn(ReadOnlyStringMap contextData) {
        if (contextData == null) {
            return null;
        }
        try {
            JsonNodeFactory factory = OBJECT_MAPPER.getNodeFactory();
            final ObjectNode root2 = factory.objectNode();
            contextData.forEach(new BiConsumer<String, Object>(){

                @Override
                public void accept(String key, Object value2) {
                    root2.put(key, String.valueOf(value2));
                }
            });
            return OBJECT_MAPPER.writeValueAsString(root2);
        }
        catch (Exception e) {
            throw new PersistenceException("Failed to convert contextData to JSON string.", (Throwable)e);
        }
    }

    public ReadOnlyStringMap convertToEntityAttribute(String s2) {
        if (Strings.isEmpty(s2)) {
            return null;
        }
        try {
            StringMap result2 = ContextDataFactory.createContextData();
            ObjectNode root2 = (ObjectNode)OBJECT_MAPPER.readTree(s2);
            Iterator<Map.Entry<String, JsonNode>> entries = root2.fields();
            while (entries.hasNext()) {
                Map.Entry<String, JsonNode> entry2 = entries.next();
                String value2 = entry2.getValue().textValue();
                result2.putValue(entry2.getKey(), value2);
            }
            return result2;
        }
        catch (IOException e) {
            throw new PersistenceException("Failed to convert JSON string to map.", (Throwable)e);
        }
    }
}

