/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class OffsetCommitRequest
extends AbstractRequestResponse {
    public static Schema curSchema = ProtoUtils.currentRequestSchema(ApiKeys.OFFSET_COMMIT.id);
    private static String GROUP_ID_KEY_NAME = "group_id";
    private static String GENERATION_ID_KEY_NAME = "group_generation_id";
    private static String CONSUMER_ID_KEY_NAME = "consumer_id";
    private static String TOPICS_KEY_NAME = "topics";
    private static String TOPIC_KEY_NAME = "topic";
    private static String PARTITIONS_KEY_NAME = "partitions";
    private static String PARTITION_KEY_NAME = "partition";
    private static String COMMIT_OFFSET_KEY_NAME = "offset";
    private static String TIMESTAMP_KEY_NAME = "timestamp";
    private static String METADATA_KEY_NAME = "metadata";
    public static final int DEFAULT_GENERATION_ID = -1;
    public static final String DEFAULT_CONSUMER_ID = "";
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final String groupId;
    private final int generationId;
    private final String consumerId;
    private final Map<TopicPartition, PartitionData> offsetData;

    @Deprecated
    public OffsetCommitRequest(String groupId, Map<TopicPartition, PartitionData> offsetData) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.OFFSET_COMMIT.id, 0)));
        this.initCommonFields(groupId, offsetData, 0);
        this.groupId = groupId;
        this.generationId = -1;
        this.consumerId = DEFAULT_CONSUMER_ID;
        this.offsetData = offsetData;
    }

    public OffsetCommitRequest(String groupId, int generationId, String consumerId, Map<TopicPartition, PartitionData> offsetData) {
        super(new Struct(curSchema));
        this.initCommonFields(groupId, offsetData, 1);
        this.struct.set(GENERATION_ID_KEY_NAME, (Object)generationId);
        this.struct.set(CONSUMER_ID_KEY_NAME, (Object)consumerId);
        this.groupId = groupId;
        this.generationId = generationId;
        this.consumerId = consumerId;
        this.offsetData = offsetData;
    }

    private void initCommonFields(String groupId, Map<TopicPartition, PartitionData> offsetData, int versionId) {
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(offsetData);
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(TOPICS_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData fetchPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(COMMIT_OFFSET_KEY_NAME, (Object)fetchPartitionData.offset);
                if (versionId == 1) {
                    partitionData.set(TIMESTAMP_KEY_NAME, (Object)fetchPartitionData.timestamp);
                }
                partitionData.set(METADATA_KEY_NAME, (Object)fetchPartitionData.metadata);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
    }

    public OffsetCommitRequest(Struct struct) {
        super(struct);
        this.offsetData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition2 = partitionResponse.getInt(PARTITION_KEY_NAME);
                long offset = partitionResponse.getLong(COMMIT_OFFSET_KEY_NAME);
                long timestamp = partitionResponse.hasField(TIMESTAMP_KEY_NAME) ? partitionResponse.getLong(TIMESTAMP_KEY_NAME) : -1L;
                String metadata = partitionResponse.getString(METADATA_KEY_NAME);
                PartitionData partitionData = new PartitionData(offset, timestamp, metadata);
                this.offsetData.put(new TopicPartition(topic, partition2), partitionData);
            }
        }
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
        this.generationId = struct.hasField(GENERATION_ID_KEY_NAME) ? struct.getInt(GENERATION_ID_KEY_NAME) : -1;
        this.consumerId = struct.hasField(CONSUMER_ID_KEY_NAME) ? struct.getString(CONSUMER_ID_KEY_NAME) : DEFAULT_CONSUMER_ID;
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public String consumerId() {
        return this.consumerId;
    }

    public Map<TopicPartition, PartitionData> offsetData() {
        return this.offsetData;
    }

    public static OffsetCommitRequest parse(ByteBuffer buffer, int versionId) {
        Schema schema = ProtoUtils.requestSchema(ApiKeys.OFFSET_COMMIT.id, versionId);
        return new OffsetCommitRequest((Struct)schema.read(buffer));
    }

    public static OffsetCommitRequest parse(ByteBuffer buffer) {
        return new OffsetCommitRequest((Struct)curSchema.read(buffer));
    }

    public static final class PartitionData {
        public final long offset;
        public final long timestamp;
        public final String metadata;

        public PartitionData(long offset, String metadata) {
            this(offset, -1L, metadata);
        }

        public PartitionData(long offset, long timestamp, String metadata) {
            this.offset = offset;
            this.timestamp = timestamp;
            this.metadata = metadata;
        }
    }
}

