/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import org.apache.kafka.common.network.Receive;

public class NetworkReceive
implements Receive {
    private final int source;
    private final ByteBuffer size;
    private ByteBuffer buffer;

    public NetworkReceive(int source, ByteBuffer buffer) {
        this.source = source;
        this.buffer = buffer;
        this.size = null;
    }

    public NetworkReceive(int source) {
        this.source = source;
        this.size = ByteBuffer.allocate(4);
        this.buffer = null;
    }

    @Override
    public int source() {
        return this.source;
    }

    @Override
    public boolean complete() {
        return !this.size.hasRemaining() && !this.buffer.hasRemaining();
    }

    @Override
    public ByteBuffer[] reify() {
        return new ByteBuffer[]{this.buffer};
    }

    @Override
    public long readFrom(ScatteringByteChannel channel) throws IOException {
        int bytesRead;
        int read2 = 0;
        if (this.size.hasRemaining()) {
            bytesRead = channel.read(this.size);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            read2 += bytesRead;
            if (!this.size.hasRemaining()) {
                this.size.rewind();
                int requestSize = this.size.getInt();
                if (requestSize < 0) {
                    throw new IllegalStateException("Invalid request (size = " + requestSize + ")");
                }
                this.buffer = ByteBuffer.allocate(requestSize);
            }
        }
        if (this.buffer != null) {
            bytesRead = channel.read(this.buffer);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            read2 += bytesRead;
        }
        return read2;
    }

    public ByteBuffer payload() {
        return this.buffer;
    }
}

