/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConfig {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> used;
    private final Map<String, ?> originals;
    private final Map<String, Object> values;

    public AbstractConfig(ConfigDef definition, Map<?, ?> originals) {
        for (Object key : originals.keySet()) {
            if (key instanceof String) continue;
            throw new ConfigException(key.toString(), originals.get(key), "Key must be a string.");
        }
        this.originals = originals;
        this.values = definition.parse(this.originals);
        this.used = Collections.synchronizedSet(new HashSet());
        this.logAll();
    }

    protected Object get(String key) {
        if (!this.values.containsKey(key)) {
            throw new ConfigException(String.format("Unknown configuration '%s'", key));
        }
        this.used.add(key);
        return this.values.get(key);
    }

    public int getInt(String key) {
        return (Integer)this.get(key);
    }

    public long getLong(String key) {
        return (Long)this.get(key);
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    public List<String> getList(String key) {
        return (List)this.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public Class<?> getClass(String key) {
        return (Class)this.get(key);
    }

    public Set<String> unused() {
        HashSet<String> keys = new HashSet<String>(this.originals.keySet());
        keys.removeAll(this.used);
        return keys;
    }

    public Map<String, ?> originals() {
        HashMap copy = new HashMap();
        copy.putAll(this.originals);
        return copy;
    }

    private void logAll() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append(" values: ");
        b.append(Utils.NL);
        for (Map.Entry<String, Object> entry2 : this.values.entrySet()) {
            b.append('\t');
            b.append(entry2.getKey());
            b.append(" = ");
            b.append(entry2.getValue());
            b.append(Utils.NL);
        }
        this.log.info(b.toString());
    }

    public void logUnused() {
        for (String key : this.unused()) {
            this.log.warn("The configuration {} = {} was supplied but isn't a known config.", (Object)key, this.values.get(key));
        }
    }

    public <T> T getConfiguredInstance(String key, Class<T> t) {
        Class<?> c = this.getClass(key);
        if (c == null) {
            return null;
        }
        Object o = Utils.newInstance(c);
        if (!t.isInstance(o)) {
            throw new KafkaException(c.getName() + " is not an instance of " + t.getName());
        }
        if (o instanceof Configurable) {
            ((Configurable)o).configure(this.originals);
        }
        return t.cast(o);
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t) {
        List<String> klasses = this.getList(key);
        ArrayList<T> objects = new ArrayList<T>();
        for (String klass : klasses) {
            Class<?> c;
            try {
                c = Class.forName(klass);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(key, klass, "Class " + klass + " could not be found.");
            }
            if (c == null) {
                return null;
            }
            Object o = Utils.newInstance(c);
            if (!t.isInstance(o)) {
                throw new KafkaException(c.getName() + " is not an instance of " + t.getName());
            }
            if (o instanceof Configurable) {
                ((Configurable)o).configure(this.originals);
            }
            objects.add(t.cast(o));
        }
        return objects;
    }
}

