/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.Partitioner;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class MockProducer
implements Producer<byte[], byte[]> {
    private final Cluster cluster;
    private final Partitioner partitioner = new Partitioner();
    private final List<ProducerRecord<byte[], byte[]>> sent;
    private final Deque<Completion> completions;
    private boolean autoComplete;
    private Map<TopicPartition, Long> offsets;

    public MockProducer(Cluster cluster, boolean autoComplete) {
        this.cluster = cluster;
        this.autoComplete = autoComplete;
        this.offsets = new HashMap<TopicPartition, Long>();
        this.sent = new ArrayList<ProducerRecord<byte[], byte[]>>();
        this.completions = new ArrayDeque<Completion>();
    }

    public MockProducer(boolean autoComplete) {
        this(Cluster.empty(), autoComplete);
    }

    public MockProducer() {
        this(true);
    }

    @Override
    public synchronized Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record) {
        return this.send(record, (Callback)null);
    }

    @Override
    public synchronized Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record, Callback callback) {
        int partition2 = 0;
        if (this.cluster.partitionsForTopic(record.topic()) != null) {
            partition2 = this.partitioner.partition(record, this.cluster);
        }
        ProduceRequestResult result2 = new ProduceRequestResult();
        FutureRecordMetadata future = new FutureRecordMetadata(result2, 0L);
        TopicPartition topicPartition = new TopicPartition(record.topic(), partition2);
        long offset = this.nextOffset(topicPartition);
        Completion completion = new Completion(topicPartition, offset, new RecordMetadata(topicPartition, 0L, offset), result2, callback);
        this.sent.add(record);
        if (this.autoComplete) {
            completion.complete(null);
        } else {
            this.completions.addLast(completion);
        }
        return future;
    }

    private long nextOffset(TopicPartition tp) {
        Long offset = this.offsets.get(tp);
        if (offset == null) {
            this.offsets.put(tp, 1L);
            return 0L;
        }
        Long next2 = offset + 1L;
        this.offsets.put(tp, next2);
        return offset;
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        return this.cluster.partitionsForTopic(topic);
    }

    @Override
    public Map<MetricName, Metric> metrics() {
        return Collections.emptyMap();
    }

    @Override
    public void close() {
    }

    public synchronized List<ProducerRecord<byte[], byte[]>> history() {
        return new ArrayList<ProducerRecord<byte[], byte[]>>(this.sent);
    }

    public synchronized void clear() {
        this.sent.clear();
        this.completions.clear();
    }

    public synchronized boolean completeNext() {
        return this.errorNext(null);
    }

    public synchronized boolean errorNext(RuntimeException e) {
        Completion completion = this.completions.pollFirst();
        if (completion != null) {
            completion.complete(e);
            return true;
        }
        return false;
    }

    private static class Completion {
        private final long offset;
        private final RecordMetadata metadata;
        private final ProduceRequestResult result;
        private final Callback callback;
        private final TopicPartition topicPartition;

        public Completion(TopicPartition topicPartition, long offset, RecordMetadata metadata, ProduceRequestResult result2, Callback callback) {
            this.metadata = metadata;
            this.offset = offset;
            this.result = result2;
            this.callback = callback;
            this.topicPartition = topicPartition;
        }

        public void complete(RuntimeException e) {
            this.result.done(this.topicPartition, e == null ? this.offset : -1L, e);
            if (this.callback != null) {
                if (e == null) {
                    this.callback.onCompletion(this.metadata, null);
                } else {
                    this.callback.onCompletion(null, e);
                }
            }
        }
    }
}

