/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGenOrMethodGen;
import org.apache.bcel.generic.FieldObserver;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELComparator;

public class FieldGen
extends FieldGenOrMethodGen {
    private Object value = null;
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            FieldGen THIS = (FieldGen)o1;
            FieldGen THAT = (FieldGen)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        @Override
        public int hashCode(Object o) {
            FieldGen THIS = (FieldGen)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private List<FieldObserver> observers;

    public FieldGen(int access_flags, Type type, String name, ConstantPoolGen cp) {
        super(access_flags);
        this.setType(type);
        this.setName(name);
        this.setConstantPool(cp);
    }

    public FieldGen(Field field2, ConstantPoolGen cp) {
        this(field2.getAccessFlags(), Type.getType(field2.getSignature()), field2.getName(), cp);
        Attribute[] attrs;
        for (Attribute attr : attrs = field2.getAttributes()) {
            if (attr instanceof ConstantValue) {
                this.setValue(((ConstantValue)attr).getConstantValueIndex());
                continue;
            }
            if (attr instanceof Annotations) {
                AnnotationEntry[] annotationEntries;
                Annotations runtimeAnnotations = (Annotations)attr;
                for (AnnotationEntry element : annotationEntries = runtimeAnnotations.getAnnotationEntries()) {
                    this.addAnnotationEntry(new AnnotationEntryGen(element, cp, false));
                }
                continue;
            }
            this.addAttribute(attr);
        }
    }

    private void setValue(int index2) {
        ConstantPool cp = super.getConstantPool().getConstantPool();
        Constant c = cp.getConstant(index2);
        this.value = ((ConstantObject)((Object)c)).getConstantValue(cp);
    }

    public void setInitValue(String str) {
        this.checkType(ObjectType.getInstance("java.lang.String"));
        if (str != null) {
            this.value = str;
        }
    }

    public void setInitValue(long l) {
        this.checkType(Type.LONG);
        if (l != 0L) {
            this.value = l;
        }
    }

    public void setInitValue(int i) {
        this.checkType(Type.INT);
        if (i != 0) {
            this.value = i;
        }
    }

    public void setInitValue(short s2) {
        this.checkType(Type.SHORT);
        if (s2 != 0) {
            this.value = (int)s2;
        }
    }

    public void setInitValue(char c) {
        this.checkType(Type.CHAR);
        if (c != '\u0000') {
            this.value = (int)c;
        }
    }

    public void setInitValue(byte b) {
        this.checkType(Type.BYTE);
        if (b != 0) {
            this.value = (int)b;
        }
    }

    public void setInitValue(boolean b) {
        this.checkType(Type.BOOLEAN);
        if (b) {
            this.value = 1;
        }
    }

    public void setInitValue(float f) {
        this.checkType(Type.FLOAT);
        if ((double)f != 0.0) {
            this.value = new Float(f);
        }
    }

    public void setInitValue(double d) {
        this.checkType(Type.DOUBLE);
        if (d != 0.0) {
            this.value = new Double(d);
        }
    }

    public void cancelInitValue() {
        this.value = null;
    }

    private void checkType(Type atype) {
        Type superType = super.getType();
        if (superType == null) {
            throw new ClassGenException("You haven't defined the type of the field yet");
        }
        if (!this.isFinal()) {
            throw new ClassGenException("Only final fields may have an initial value!");
        }
        if (!superType.equals(atype)) {
            throw new ClassGenException("Types are not compatible: " + superType + " vs. " + atype);
        }
    }

    public Field getField() {
        String signature = this.getSignature();
        int name_index = super.getConstantPool().addUtf8(super.getName());
        int signature_index = super.getConstantPool().addUtf8(signature);
        if (this.value != null) {
            this.checkType(super.getType());
            int index2 = this.addConstant();
            this.addAttribute(new ConstantValue(super.getConstantPool().addUtf8("ConstantValue"), 2, index2, super.getConstantPool().getConstantPool()));
        }
        this.addAnnotationsAsAttribute(super.getConstantPool());
        return new Field(super.getAccessFlags(), name_index, signature_index, this.getAttributes(), super.getConstantPool().getConstantPool());
    }

    private void addAnnotationsAsAttribute(ConstantPoolGen cp) {
        Attribute[] attrs;
        for (Attribute attr : attrs = AnnotationEntryGen.getAnnotationAttributes(cp, super.getAnnotationEntries())) {
            this.addAttribute(attr);
        }
    }

    private int addConstant() {
        switch (super.getType().getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return super.getConstantPool().addInteger((Integer)this.value);
            }
            case 6: {
                return super.getConstantPool().addFloat(((Float)this.value).floatValue());
            }
            case 7: {
                return super.getConstantPool().addDouble((Double)this.value);
            }
            case 11: {
                return super.getConstantPool().addLong((Long)this.value);
            }
            case 14: {
                return super.getConstantPool().addString((String)this.value);
            }
        }
        throw new RuntimeException("Oops: Unhandled : " + super.getType().getType());
    }

    @Override
    public String getSignature() {
        return super.getType().getSignature();
    }

    public void addObserver(FieldObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<FieldObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(FieldObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (FieldObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }

    public String getInitValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public final String toString() {
        String access = Utility.accessToString(super.getAccessFlags());
        access = access.isEmpty() ? "" : access + " ";
        String signature = super.getType().toString();
        String name = this.getName();
        StringBuilder buf = new StringBuilder(32);
        buf.append(access).append(signature).append(" ").append(name);
        String value2 = this.getInitValue();
        if (value2 != null) {
            buf.append(" = ").append(value2);
        }
        return buf.toString();
    }

    public FieldGen copy(ConstantPoolGen cp) {
        FieldGen fg = (FieldGen)this.clone();
        fg.setConstantPool(cp);
        return fg;
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator comparator) {
        bcelComparator = comparator;
    }

    public boolean equals(Object obj) {
        return bcelComparator.equals(this, obj);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

