/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Synthetic
extends Attribute {
    private byte[] bytes;

    public Synthetic(Synthetic c) {
        this(c.getNameIndex(), c.getLength(), c.getBytes(), c.getConstantPool());
    }

    public Synthetic(int name_index, int length, byte[] bytes, ConstantPool constant_pool) {
        super((byte)7, name_index, length, constant_pool);
        this.bytes = bytes;
    }

    Synthetic(int name_index, int length, DataInput input2, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (byte[])null, constant_pool);
        if (length > 0) {
            this.bytes = new byte[length];
            input2.readFully(this.bytes);
            System.err.println("Synthetic attribute with length > 0");
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitSynthetic(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        if (super.getLength() > 0) {
            file.write(this.bytes, 0, super.getLength());
        }
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public final void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder("Synthetic");
        if (super.getLength() > 0) {
            buf.append(" ").append(Utility.toHexString(this.bytes));
        }
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        Synthetic c = (Synthetic)this.clone();
        if (this.bytes != null) {
            c.bytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, c.bytes, 0, this.bytes.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

