/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.Visitor;

public final class StackMap
extends Attribute {
    private StackMapEntry[] map;

    public StackMap(int name_index, int length, StackMapEntry[] map2, ConstantPool constant_pool) {
        super((byte)11, name_index, length, constant_pool);
        this.map = map2;
    }

    StackMap(int name_index, int length, DataInput input2, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (StackMapEntry[])null, constant_pool);
        int map_length = input2.readUnsignedShort();
        this.map = new StackMapEntry[map_length];
        for (int i = 0; i < map_length; ++i) {
            this.map[i] = new StackMapEntry(input2, constant_pool);
        }
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.map.length);
        for (StackMapEntry entry2 : this.map) {
            entry2.dump(file);
        }
    }

    public final StackMapEntry[] getStackMap() {
        return this.map;
    }

    public final void setStackMap(StackMapEntry[] map2) {
        this.map = map2;
        int len = 2;
        for (StackMapEntry element : map2) {
            len += element.getMapEntrySize();
        }
        this.setLength(len);
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder("StackMap(");
        for (int i = 0; i < this.map.length; ++i) {
            buf.append(this.map[i]);
            if (i >= this.map.length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        StackMap c = (StackMap)this.clone();
        c.map = new StackMapEntry[this.map.length];
        for (int i = 0; i < this.map.length; ++i) {
            c.map[i] = this.map[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public void accept(Visitor v) {
        v.visitStackMap(this);
    }

    public final int getMapLength() {
        return this.map == null ? 0 : this.map.length;
    }
}

