/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;

public class MethodParameter
implements Cloneable {
    private int name_index;
    private int access_flags;

    public MethodParameter() {
    }

    MethodParameter(DataInput input2) throws IOException {
        this.name_index = input2.readUnsignedShort();
        this.access_flags = input2.readUnsignedShort();
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public void setNameIndex(int name_index) {
        this.name_index = name_index;
    }

    public String getParameterName(ConstantPool constant_pool) {
        if (this.name_index == 0) {
            return null;
        }
        return ((ConstantUtf8)constant_pool.getConstant(this.name_index, (byte)1)).getBytes();
    }

    public int getAccessFlags() {
        return this.access_flags;
    }

    public void setAccessFlags(int access_flags) {
        this.access_flags = access_flags;
    }

    public boolean isFinal() {
        return (this.access_flags & 0x10) != 0;
    }

    public boolean isSynthetic() {
        return (this.access_flags & 0x1000) != 0;
    }

    public boolean isMandated() {
        return (this.access_flags & Short.MIN_VALUE) != 0;
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.name_index);
        file.writeShort(this.access_flags);
    }

    public MethodParameter copy() {
        try {
            return (MethodParameter)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

